/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.connection.AbstractResponse;

public class OtherResponse
extends AbstractResponse {
    protected URL url;
    protected InputStream in;
    protected long lastModified;

    protected OtherResponse(URL uRL) {
        this.url = uRL;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            this.in = this.connection.getInputStream();
            this.lastModified = this.connection.getLastModified();
        }
        return this.in;
    }

    public InputStream getInputStream(IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        if (this.in == null && this.url != null) {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            this.in = iProgressMonitor != null ? this.openStreamWithCancel(this.connection, iProgressMonitor) : this.connection.getInputStream();
            if (this.in != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        return 200;
    }

    public String getStatusMessage() {
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L && this.connection != null) {
            this.lastModified = this.connection.getLastModified();
        }
        return this.lastModified;
    }
}

