/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ercp.xml.dom.AttrImpl;
import org.eclipse.ercp.xml.dom.ElementImpl;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeMap
implements NamedNodeMap {
    ElementImpl owner;
    Hashtable attributes;

    public AttributeMap(ElementImpl owner) {
        this.owner = owner;
        this.attributes = new Hashtable();
    }

    public Node getNamedItem(String name) {
        return (Node)this.attributes.get(name);
    }

    public Node setNamedItem(Node arg) throws DOMException {
        if (this.owner.getOwnerDocument() != arg.getOwnerDocument()) {
            throw new DOMException(4, EXmlMsg.getDefault().getString(30));
        }
        AttrImpl attr = (AttrImpl)arg;
        if (attr.getOwnerElement() != null && attr.getOwnerElement() != this.owner) {
            throw new DOMException(10, EXmlMsg.getDefault().getString(31));
        }
        attr.setOwnerElement(this.owner);
        AttrImpl oldAttr = (AttrImpl)this.getNamedItem(attr.getName());
        this.attributes.put(attr.getName(), attr);
        if (oldAttr != null) {
            oldAttr.setOwnerElement(null);
        }
        return oldAttr;
    }

    public Node removeNamedItem(String name) throws DOMException {
        AttrImpl oldAttr = (AttrImpl)this.getNamedItem(name);
        this.attributes.remove(name);
        if (oldAttr != null) {
            oldAttr.setOwnerElement(null);
        }
        return oldAttr;
    }

    public Node item(int index) {
        Enumeration anEnumeration = this.attributes.elements();
        int pos = -1;
        while (anEnumeration.hasMoreElements()) {
            Node node = (Node)anEnumeration.nextElement();
            if (++pos != index) continue;
            return node;
        }
        return null;
    }

    public int getLength() {
        return this.attributes.size();
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return null;
        }
        Enumeration anEnumeration = this.attributes.elements();
        while (anEnumeration.hasMoreElements()) {
            Node attribute = (Node)anEnumeration.nextElement();
            if (!namespaceURI.equals(attribute.getNamespaceURI()) || !localName.equals(attribute.getLocalName())) continue;
            return attribute;
        }
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        return this.owner.setAttributeNodeNS((Attr)arg);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        AttrImpl oldAttr = (AttrImpl)this.getNamedItemNS(namespaceURI, localName);
        if (oldAttr != null) {
            this.attributes.remove(oldAttr.getName());
            oldAttr.setOwnerElement(null);
        }
        return oldAttr;
    }

    Node removeItem(Node node) throws DOMException {
        if (node == null) {
            return null;
        }
        AttrImpl attr = (AttrImpl)node;
        if (attr.getOwnerElement() != this.owner) {
            throw new DOMException(8, EXmlMsg.getDefault().getString(32));
        }
        this.attributes.remove(attr.getName());
        attr.setOwnerElement(null);
        return attr;
    }

    void setNamedItemNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttrImpl attribute = (AttrImpl)this.getNamedItem(qualifiedName);
        if (attribute == null) {
            attribute = (AttrImpl)this.owner.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            this.attributes.put(qualifiedName, attribute);
            attribute.setOwnerElement(this.owner);
        }
        attribute.setValue(value);
    }

    void setNamedItem(String name, String value) throws DOMException {
        AttrImpl attribute = (AttrImpl)this.getNamedItem(name);
        if (attribute == null) {
            attribute = (AttrImpl)this.owner.getOwnerDocument().createAttribute(name);
            this.attributes.put(name, attribute);
            attribute.setOwnerElement(this.owner);
        }
        attribute.setValue(value);
    }
}

