/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.SAXParser;
import org.eclipse.ercp.xml.io.IOSpecificCall;
import org.eclipse.ercp.xml.io.XmlInputStreamReader;
import org.eclipse.ercp.xml.parser.AttributesImpl;
import org.eclipse.ercp.xml.parser.CharDecoder;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.eclipse.ercp.xml.parser.NSDeclaration;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractSAXParserImpl
extends SAXParser
implements Locator {
    Reader reader;
    InputSource source;
    CharDecoder charDecoder = CharDecoder.forXml();
    int lineNumber;
    int columnNumber;
    int currentState;
    char[] writeBuffer;
    int writeBufferIndex;
    int columnIndex;
    char[] refBuffer;
    int refBufferIndex;
    int cdataHeaderIndex;
    static final String CDATA_HEADER = "[CDATA[";
    int doctypeHeaderIndex;
    static final String DOCTYPE_HEADER = "DOCTYPE";
    int openSquareBrackets;
    int openAngleBrackets;
    String elementQName;
    String elementNamespace;
    String elementLocalName;
    String attributeQName;
    String attributeNamespace;
    String attributeLocalName;
    String attributeValue;
    AttributesImpl attributes;
    protected NSDeclaration currentNSDecl;
    int elementsDepth;
    boolean parsingYet;
    int closingValue;
    boolean checkXmlDeclaration;
    boolean fNamespaces = true;
    boolean fNamespacesPrefixes = false;
    protected boolean fStringInterning = this.canDoStringInterning();
    protected boolean fXmlNSUris = false;
    public static int WriteBufferSize = 5120;
    public static final String XmlOrgFeaturesPrefix = "http://xml.org/sax/features/";
    public static final String NamespacesFeature = "namespaces";
    public static final String NamespacePrefixesFeature = "namespace-prefixes";
    public static final String StringInterningFeature = "string-interning";
    public static final String XmlNSUris = "xmlns-uris";
    static final String[] XmlOrgFeatureIDs = new String[]{"namespaces", "namespace-prefixes", "validation", "external-general-entities", "external-parameter-entities", "is-standalone", "lexical-handler/parameter-entities", "resolve-dtd-uris", "string-interning", "use-attributes2", "use-locator2", "use-entity-resolver2", "xmlns-uris"};
    public static final String XmlOrgPropertiesPrefix = "http://xml.org/sax/properties/";
    public static final String LexicalHandlerID = "lexical-handler";
    static final String[] XmlOrgPropertyIDs = new String[]{"declaration-handler", "dom-node", "lexical-handler", "xml-string"};
    public static final int DOC_STATE = 0;
    public static final int PROLOG_STATE = 1;
    public static final int XPI_STATE = 2;
    public static final int MISC_STATE = 3;
    public static final int MISC2_STATE = 4;
    public static final int DT_DECL_STATE = 5;
    public static final int CMT2_STATE = 6;
    public static final int CMT3_STATE = 7;
    public static final int CMT4_STATE = 8;
    public static final int CMT5_STATE = 9;
    public static final int START_ELEMENT_STATE = 10;
    public static final int END_ELEMENT_STATE = 11;
    public static final int END_ELEMENT_NAME_STATE = 12;
    public static final int END_ELEMENT2_STATE = 13;
    public static final int ENDTAG_STATE = 14;
    public static final int ATTLIST_STATE = 15;
    public static final int ATTNAME_STATE = 16;
    public static final int ATTEQUAL_STATE = 17;
    public static final int ATTVALUE_STATE = 18;
    public static final int VALUE_STATE = 19;
    public static final int REF_STATE = 20;
    public static final int REFNAME_STATE = 21;
    public static final int REF2_STATE = 22;
    public static final int REF2NAME_STATE = 23;
    public static final int XPI_TARGET_NAME_STATE = 24;
    public static final int XPI_DATA_STATE = 25;
    public static final int XPI_DATA_VALUE_STATE = 26;
    public static final int XPI_DATA_END_STATE = 27;
    public static final int XPI_XML_END_STATE = 28;
    public static final int XPI_XML_TARGET_STATE = 29;
    public static final int XPI_ATTNAME_STATE = 30;
    public static final int XPI_ATTEQUAL_STATE = 31;
    public static final int XPI_ATTVALUE_STATE = 32;
    public static final int XPI_VALUE_STATE = 33;
    public static final int CDATA_STATE = 34;
    public static final int DOCTYPE_STATE = 35;
    public static final int CDATA_VALUE_STATE = 36;
    public static final int DOCTYPE_VALUE_STATE = 37;
    public static final int CDATA_END_STATE = 38;
    public static final int CDATA_END2_STATE = 39;

    public AbstractSAXParserImpl() {
        this.resetParser();
    }

    public void resetParser() {
        this.currentState = 0;
        this.writeBuffer = new char[WriteBufferSize];
        this.resetWriteBuffer();
        this.refBuffer = new char[WriteBufferSize];
        this.refBufferIndex = 0;
        this.currentNSDecl = new NSDeclaration();
        this.elementsDepth = 0;
        this.parsingYet = false;
        this.lineNumber = 0;
        this.columnNumber = 0;
        this.attributes = null;
    }

    final void resetWriteBufferWith(int c) {
        this.resetWriteBuffer();
        this.writeBuffer[this.writeBufferIndex++] = (char)c;
    }

    final void resetWriteBuffer() {
        this.writeBufferIndex = 0;
        this.columnIndex = -1;
    }

    final void appendToWriteBuffer(int c) {
        this.writeBuffer[this.writeBufferIndex++] = (char)c;
    }

    final void appendToWriteBuffer(char[] text, int start, int length) {
        while (this.writeBufferIndex + length > this.writeBuffer.length) {
            int max = this.writeBuffer.length + WriteBufferSize;
            char[] newWBuffer = new char[max];
            System.arraycopy(this.writeBuffer, 0, newWBuffer, 0, this.writeBuffer.length);
            this.writeBuffer = newWBuffer;
        }
        System.arraycopy(text, start, this.writeBuffer, this.writeBufferIndex - 1, length);
        this.writeBufferIndex += length;
    }

    final void appendAndGrowToWriteBuffer(int c) {
        try {
            this.writeBuffer[this.writeBufferIndex++] = (char)c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int max = this.writeBuffer.length + WriteBufferSize;
            char[] newWBuffer = new char[max];
            System.arraycopy(this.writeBuffer, 0, newWBuffer, 0, this.writeBuffer.length);
            this.writeBuffer = newWBuffer;
            this.writeBuffer[this.writeBufferIndex - 1] = (char)c;
        }
    }

    final void resetRefBufferWith(int c) {
        this.refBufferIndex = 0;
        this.refBuffer[this.refBufferIndex++] = (char)c;
    }

    final void appendToRefBuffer(int c) {
        this.refBuffer[this.refBufferIndex++] = (char)c;
    }

    final void appendRefBufferToWriteBuffer() {
        this.appendToWriteBuffer(38);
        System.arraycopy(this.refBuffer, 0, this.writeBuffer, this.writeBufferIndex, this.refBufferIndex);
        this.writeBufferIndex += this.refBufferIndex;
    }

    final void appendRefValueToWriteBuffer() throws SAXException {
        String charName = new String(this.refBuffer, 0, this.refBufferIndex);
        String charValue = this.charDecoder.getCharValue(charName);
        if (charValue == null) {
            this.warning(EXmlMsg.getDefault().getString(24), "&" + charName + ";");
            this.appendToWriteBuffer(38);
            this.appendToWriteBuffer(this.refBuffer, 0, this.refBufferIndex);
            this.appendToWriteBuffer(59);
        } else {
            this.appendToWriteBuffer(charValue.charAt(0));
        }
    }

    final void resetElementQName() {
        this.elementQName = null;
        this.elementNamespace = null;
        this.elementLocalName = null;
    }

    final void endStartElementName() {
        this.endElementLocalName();
        if (this.fNamespaces) {
            this.pushNamespaceDeclaration();
        }
    }

    final void endElementLocalName() {
        this.elementQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
        if (this.columnIndex != -1) {
            this.elementNamespace = new String(this.writeBuffer, 0, this.columnIndex - 1);
            this.elementLocalName = !this.fNamespaces ? "" : new String(this.writeBuffer, this.columnIndex, this.writeBufferIndex - this.columnIndex);
        } else {
            this.elementNamespace = null;
            this.elementLocalName = !this.fNamespaces ? "" : this.elementQName;
        }
        this.resetWriteBuffer();
        this.attributes = null;
    }

    final void endElementNamespace() {
        this.columnIndex = this.writeBufferIndex;
    }

    final void resetAttributeQName() {
        this.attributeQName = null;
        this.attributeNamespace = null;
        this.attributeLocalName = null;
    }

    final void endAttributeLocalName() {
        this.attributeQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
        if (this.columnIndex != -1) {
            this.attributeNamespace = new String(this.writeBuffer, 0, this.columnIndex - 1);
            this.attributeLocalName = new String(this.writeBuffer, this.columnIndex, this.writeBufferIndex - this.columnIndex);
        } else {
            this.attributeNamespace = null;
            this.attributeLocalName = this.attributeQName;
        }
        this.resetWriteBuffer();
    }

    final void endAttributeNamespace() {
        this.columnIndex = this.writeBufferIndex;
    }

    final void resetAttributeValue() {
        this.attributeValue = null;
    }

    final void endAttValue() throws SAXException {
        this.attributeValue = new String(this.writeBuffer, 0, this.writeBufferIndex);
        this.resetWriteBuffer();
        this.addAttribute(this.attributeNamespace, this.attributeQName, this.attributeLocalName, this.attributeValue);
    }

    protected void addAttribute(String namespace, String qName, String localName, String attvalue) throws SAXException {
        if (!this.fNamespaces) {
            this.addAttribute(null, namespace, qName, "", "CDATA", attvalue);
        } else {
            if ("xmlns".equals(localName)) {
                namespace = localName;
                localName = "";
            }
            if ("xmlns".equals(namespace)) {
                this.startPrefixMapping(localName, attvalue);
                if (this.fNamespacesPrefixes) {
                    this.addAttribute(this.fXmlNSUris ? this.currentNSDecl : null, namespace, qName, localName, "CDATA", attvalue);
                }
            } else {
                this.addAttribute(this.fXmlNSUris ? this.currentNSDecl : null, namespace, qName, localName, "CDATA", this.attributeValue);
            }
        }
    }

    void addAttribute(NSDeclaration nsDeclaration, String prefix, String qName, String localName, String type, String value) {
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        this.attributes.addAttribute(nsDeclaration, prefix, qName, localName, type, value);
    }

    final int endPITargetName() {
        this.elementQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
        boolean wasXMLTarget = this.isXMLTargetNameWasFound();
        this.resetWriteBuffer();
        this.attributes = null;
        return wasXMLTarget ? 29 : 25;
    }

    final boolean isXMLTargetNameWasFound() {
        return !(this.writeBufferIndex != 3 || this.writeBuffer[0] != 'x' && this.writeBuffer[0] != 'X' || this.writeBuffer[1] != 'm' && this.writeBuffer[1] != 'M' || this.writeBuffer[2] != 'l' && this.writeBuffer[2] != 'L');
    }

    final void endPIAttributeName() {
        this.attributeQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
    }

    final void endPIAttValue() {
        this.attributeValue = new String(this.writeBuffer, 0, this.writeBufferIndex);
        this.addAttribute(null, "", this.attributeQName, this.attributeQName, "CDATA", this.attributeValue);
        this.resetWriteBuffer();
    }

    final void checkXmlDeclaration() throws SAXException {
        String ianaEncoding;
        if (this.elementQName != null && this.attributes != null && (ianaEncoding = this.attributes.getValue("", "encoding")) != null && this.source.getByteStream() != null) {
            try {
                ((XmlInputStreamReader)this.reader).setEncoding(ianaEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.warning(EXmlMsg.getDefault().getString(26), ianaEncoding);
            }
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        Reader openedReader = null;
        try {
            if (this.parsingYet) {
                throw new NullPointerException(EXmlMsg.getDefault().getString(3));
            }
            this.parsingYet = true;
            this.resetParser();
            this.reader = null;
            this.source = inputSource;
            if (inputSource.getCharacterStream() != null) {
                this.reader = inputSource.getCharacterStream();
            } else if (inputSource.getByteStream() != null) {
                this.reader = new XmlInputStreamReader(inputSource.getByteStream(), inputSource.getEncoding());
            } else if (inputSource.getSystemId() != null) {
                this.reader = openedReader = IOSpecificCall.getDefault().getReaderFromSystemID(inputSource.getSystemId(), inputSource.getEncoding());
            }
            if (this.reader == null) {
                throw new IllegalArgumentException(EXmlMsg.getDefault().getString(52));
            }
            this.doParse();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parsingYet = false;
            if (openedReader == null) throw throwable;
            try {
                openedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.parsingYet = false;
            if (openedReader == null) return;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        openedReader.close();
    }

    void doParse() throws IOException, SAXException {
        this.closingValue = -1;
        this.checkXmlDeclaration = false;
        boolean proceed = true;
        this.startDocument();
        while (proceed) {
            proceed = this.parseNextCharacter(this.reader.read());
        }
    }

    final void newLine() {
        this.columnNumber = 0;
        ++this.lineNumber;
    }

    public boolean parseNextCharacter(int c) throws SAXException {
        ++this.columnNumber;
        switch (this.currentState) {
            case 0: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 60) {
                    this.currentState = 1;
                    return true;
                }
                if (c == -1) {
                    return false;
                }
                this.fatalError(16);
                return false;
            }
            case 1: {
                if (c == 63) {
                    this.checkXmlDeclaration = true;
                    this.currentState = 2;
                    return true;
                }
                if (c == 33) {
                    this.currentState = 5;
                    return true;
                }
                if (this.isNameStartChar(c)) {
                    this.resetWriteBufferWith(c);
                    this.currentState = 10;
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 2: {
                if (this.isNameStartChar(c)) {
                    this.resetWriteBufferWith(c);
                    this.currentState = 24;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 3: {
                if (c == 32 || c == 9 || c == 10) {
                    this.appendAndGrowToWriteBuffer(c);
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    this.appendAndGrowToWriteBuffer(c);
                    return true;
                }
                if (c == 60) {
                    this.fireCharacters();
                    this.resetWriteBuffer();
                    this.currentState = 4;
                    return true;
                }
                if (c == 38) {
                    this.currentState = 22;
                    return true;
                }
                if (c == 62) {
                    this.fatalError(16);
                    return false;
                }
                if (c == -1) {
                    this.endDocument();
                    return false;
                }
                this.appendAndGrowToWriteBuffer(c);
                return true;
            }
            case 4: {
                if (c == 63) {
                    this.checkXmlDeclaration = false;
                    this.currentState = 2;
                    return true;
                }
                if (c == 33) {
                    this.currentState = 5;
                    return true;
                }
                if (c == 47) {
                    this.currentState = 11;
                    return true;
                }
                if (this.isNameStartChar(c)) {
                    this.resetElementQName();
                    this.resetWriteBufferWith(c);
                    this.currentState = 10;
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 5: {
                if (c == 45) {
                    this.currentState = 6;
                    return true;
                }
                if (c == 91) {
                    this.currentState = 34;
                    this.cdataHeaderIndex = 1;
                    return true;
                }
                if (c == 68) {
                    this.currentState = 35;
                    this.doctypeHeaderIndex = 1;
                    return true;
                }
                this.fatalError(17);
                return false;
            }
            case 6: {
                if (c == 45) {
                    this.currentState = 7;
                    return true;
                }
                this.fatalError(17);
                return false;
            }
            case 7: {
                if (c == 45) {
                    this.currentState = 8;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(20);
                } else {
                    if (c == 13) {
                        this.newLine();
                    }
                    return true;
                }
            }
            case 8: {
                if (c == 45) {
                    this.currentState = 9;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(20);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.currentState = 7;
                return true;
            }
            case 9: {
                if (c == 62) {
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 10: {
                if (c == 32 || c == 9 || c == 10) {
                    this.endStartElementName();
                    this.currentState = 15;
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    this.endStartElementName();
                    this.currentState = 15;
                    return true;
                }
                if (c == 62) {
                    this.endStartElementName();
                    this.fireStartElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                if (c == 47) {
                    this.endStartElementName();
                    this.currentState = 14;
                    return true;
                }
                if (c == 58) {
                    this.appendToWriteBuffer(c);
                    this.endElementNamespace();
                    return true;
                }
                if (this.isNameChar(c)) {
                    this.appendToWriteBuffer(c);
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 11: {
                if (this.isNameStartChar(c)) {
                    this.resetWriteBufferWith(c);
                    this.currentState = 12;
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 12: {
                if (c == 32 || c == 9 || c == 10) {
                    this.endElementLocalName();
                    this.currentState = 13;
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    this.endElementLocalName();
                    this.currentState = 13;
                    return true;
                }
                if (c == 58) {
                    this.appendToWriteBuffer(c);
                    this.endElementNamespace();
                    return true;
                }
                if (c == 62) {
                    this.endElementLocalName();
                    this.fireEndElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                if (this.isNameChar(c)) {
                    this.appendToWriteBuffer(c);
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 13: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 62) {
                    this.fireEndElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 14: {
                if (c == 62) {
                    this.fireStartElement();
                    this.fireEndElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 15: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 62) {
                    this.fireStartElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                if (c == 47) {
                    this.currentState = 14;
                    return true;
                }
                if (this.isNameStartChar(c)) {
                    this.resetAttributeQName();
                    this.resetWriteBufferWith(c);
                    this.currentState = 16;
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 16: {
                if (c == 32 || c == 9 || c == 10) {
                    this.endAttributeLocalName();
                    this.currentState = 17;
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    this.endAttributeLocalName();
                    this.currentState = 17;
                    return true;
                }
                if (c == 58) {
                    this.appendToWriteBuffer(c);
                    this.endAttributeNamespace();
                    return true;
                }
                if (c == 61) {
                    this.endAttributeLocalName();
                    this.currentState = 18;
                    return true;
                }
                if (this.isNameChar(c)) {
                    this.appendToWriteBuffer(c);
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 17: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 61) {
                    this.currentState = 18;
                    return true;
                }
                this.fatalError(19);
                return false;
            }
            case 18: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 34 || c == 39) {
                    this.resetAttributeValue();
                    this.resetWriteBuffer();
                    this.currentState = 19;
                    this.closingValue = c;
                    return true;
                }
                this.fatalError(19);
                return false;
            }
            case 19: {
                if (c == this.closingValue) {
                    this.endAttValue();
                    this.currentState = 15;
                    return true;
                }
                if (c == 38) {
                    this.currentState = 20;
                    return true;
                }
                if (c == 62 || c == 60) {
                    this.fatalError(21);
                    return false;
                }
                if (c == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(c);
                return true;
            }
            case 20: {
                if (c == this.closingValue) {
                    this.appendAndGrowToWriteBuffer(38);
                    this.endAttValue();
                    this.currentState = 15;
                    return true;
                }
                if (c == 38) {
                    this.appendAndGrowToWriteBuffer(38);
                    return true;
                }
                if (c == 60 || c == 62) {
                    this.fatalError(21);
                    return false;
                }
                if (this.isNameStartChar(c)) {
                    this.resetRefBufferWith(c);
                    this.currentState = 21;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(38);
                this.appendAndGrowToWriteBuffer(c);
                this.currentState = 19;
                return true;
            }
            case 21: {
                if (c == this.closingValue) {
                    this.appendRefBufferToWriteBuffer();
                    this.endAttValue();
                    this.currentState = 15;
                    return true;
                }
                if (c == 38) {
                    this.appendRefBufferToWriteBuffer();
                    this.currentState = 20;
                    return true;
                }
                if (c == 59) {
                    this.appendRefValueToWriteBuffer();
                    this.currentState = 19;
                    return true;
                }
                if (c == 60 || c == 62) {
                    this.fatalError(21);
                    return false;
                }
                if (this.isNameChar(c)) {
                    this.appendToRefBuffer(c);
                    return true;
                }
                if (c == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendRefBufferToWriteBuffer();
                this.currentState = 19;
                return true;
            }
            case 22: {
                if (c == 60) {
                    this.appendAndGrowToWriteBuffer(38);
                    this.currentState = 4;
                    return true;
                }
                if (c == 38) {
                    this.appendAndGrowToWriteBuffer(38);
                    return true;
                }
                if (c == 62) {
                    this.fatalError(12);
                    return false;
                }
                if (this.isNameChar(c)) {
                    this.resetRefBufferWith(c);
                    this.currentState = 23;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(38);
                this.appendAndGrowToWriteBuffer(c);
                this.currentState = 3;
                return true;
            }
            case 23: {
                if (c == 60) {
                    this.appendRefBufferToWriteBuffer();
                    this.currentState = 4;
                    return true;
                }
                if (c == 38) {
                    this.appendRefBufferToWriteBuffer();
                    this.currentState = 22;
                    return true;
                }
                if (c == 59) {
                    this.appendRefValueToWriteBuffer();
                    this.currentState = 3;
                    return true;
                }
                if (c == 62) {
                    this.fatalError(12);
                    return false;
                }
                if (this.isNameChar(c)) {
                    this.appendToRefBuffer(c);
                    return true;
                }
                if (c == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendRefBufferToWriteBuffer();
                this.currentState = 3;
                return true;
            }
            case 24: {
                if (c == 32 || c == 9 || c == 10) {
                    this.currentState = this.endPITargetName();
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    this.currentState = this.endPITargetName();
                    return true;
                }
                if (c == 63) {
                    this.currentState = this.endPITargetName();
                    this.currentState = this.currentState == 29 ? 28 : 27;
                    return true;
                }
                if (this.isNameChar(c)) {
                    this.appendToWriteBuffer(c);
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 25: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 63) {
                    this.currentState = 27;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(18);
                    return false;
                }
                this.resetWriteBufferWith(c);
                this.currentState = 26;
                return true;
            }
            case 26: {
                if (c == -1) {
                    this.fatalError(18);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 63) {
                    this.currentState = 27;
                    return true;
                }
                this.appendToWriteBuffer(c);
                return true;
            }
            case 27: {
                if (c == 62) {
                    this.fireProcessingInstruction();
                    this.resetWriteBuffer();
                    this.currentState = 3;
                    return true;
                }
                this.appendToWriteBuffer(63);
                this.appendToWriteBuffer(c);
                this.currentState = 26;
                return true;
            }
            case 28: {
                if (c == 62) {
                    if (this.checkXmlDeclaration) {
                        this.checkXmlDeclaration();
                    }
                    this.resetWriteBuffer();
                    this.currentState = 3;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 29: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 63) {
                    this.currentState = 28;
                    return true;
                }
                if (this.isNameStartChar(c)) {
                    this.resetWriteBufferWith(c);
                    this.currentState = 30;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 30: {
                if (c == 32 || c == 9 || c == 10) {
                    this.endPIAttributeName();
                    this.currentState = 31;
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    this.endPIAttributeName();
                    this.currentState = 31;
                    return true;
                }
                if (c == 61) {
                    this.endPIAttributeName();
                    this.currentState = 32;
                    return true;
                }
                if (this.isNameChar(c)) {
                    this.appendToWriteBuffer(c);
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 31: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 61) {
                    this.currentState = 32;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 32: {
                if (c == 32 || c == 9 || c == 10) {
                    return true;
                }
                if (c == 13) {
                    this.newLine();
                    return true;
                }
                if (c == 34 || c == 39) {
                    this.resetAttributeValue();
                    this.resetWriteBuffer();
                    this.currentState = 33;
                    this.closingValue = c;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 33: {
                if (c == this.closingValue) {
                    this.endPIAttValue();
                    this.currentState = 29;
                    return true;
                }
                if (c == 62 || c == 60) {
                    this.fatalError(21);
                    return false;
                }
                if (c == -1) {
                    this.fatalError(20);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(c);
                return true;
            }
            case 34: {
                if (CDATA_HEADER.charAt(this.cdataHeaderIndex) == c) {
                    ++this.cdataHeaderIndex;
                    if (this.cdataHeaderIndex == CDATA_HEADER.length()) {
                        this.resetWriteBuffer();
                        this.startCDATA();
                        this.currentState = 36;
                        return true;
                    }
                    return true;
                }
                this.fatalError(57);
                return false;
            }
            case 35: {
                if (DOCTYPE_HEADER.charAt(this.doctypeHeaderIndex) == c) {
                    ++this.doctypeHeaderIndex;
                    if (this.doctypeHeaderIndex == DOCTYPE_HEADER.length()) {
                        this.openAngleBrackets = 0;
                        this.openSquareBrackets = 0;
                        this.currentState = 37;
                        return true;
                    }
                    return true;
                }
                this.fatalError(58);
                return false;
            }
            case 36: {
                if (c == 93) {
                    this.currentState = 38;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(57);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(c);
                return true;
            }
            case 38: {
                if (c == 93) {
                    this.currentState = 39;
                    return true;
                }
                if (c == -1) {
                    this.fatalError(57);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(93);
                this.appendAndGrowToWriteBuffer(c);
                this.currentState = 36;
                return true;
            }
            case 39: {
                if (c == 62) {
                    this.fireCharacters();
                    this.resetWriteBuffer();
                    this.endCDATA();
                    this.currentState = 3;
                    return true;
                }
                this.fatalError(57);
                return false;
            }
            case 37: {
                if (c == 62) {
                    if (this.openAngleBrackets > 0) {
                        --this.openAngleBrackets;
                        return true;
                    }
                    if (this.openSquareBrackets == 0) {
                        this.currentState = 3;
                        return true;
                    }
                    this.fatalError(58);
                    return false;
                }
                if (c == 60) {
                    ++this.openAngleBrackets;
                    return true;
                }
                if (c == 91) {
                    ++this.openSquareBrackets;
                    return true;
                }
                if (c == 93) {
                    --this.openSquareBrackets;
                    if (this.openSquareBrackets >= 0) {
                        return true;
                    }
                    this.fatalError(58);
                    return false;
                }
                if (c == -1) {
                    this.fatalError(58);
                    return false;
                }
                if (c == 13) {
                    this.newLine();
                }
                return true;
            }
        }
        this.fatalError(12);
        return false;
    }

    final boolean isNameStartChar(int c) {
        return this.isIn(c, 97, 122) || this.isIn(c, 65, 90) || c == 95 || this.isIn(c, 192, 214) || this.isIn(c, 216, 246) || this.isIn(c, 248, 767) || this.isIn(c, 880, 893) || this.isIn(c, 895, 8191) || this.isIn(c, 8204, 8205) || this.isIn(c, 8304, 8591) || this.isIn(c, 11264, 12271) || this.isIn(c, 12289, 55295) || this.isIn(c, 63744, 64975) || this.isIn(c, 65008, 65533) || this.isIn(c, 65536, 983039);
    }

    final boolean isNameChar(int c) {
        return this.isIn(c, 97, 122) || this.isIn(c, 65, 90) || this.isIn(c, 48, 57) || c == 95 || c == 45 || c == 46 || c == 58 || c == 183 || this.isIn(c, 192, 214) || this.isIn(c, 216, 246) || this.isIn(c, 248, 893) || this.isIn(c, 895, 8191) || this.isIn(c, 8204, 8205) || this.isIn(c, 8255, 8256) || this.isIn(c, 8304, 8591) || this.isIn(c, 11264, 12271) || this.isIn(c, 12289, 55295) || this.isIn(c, 63744, 64975) || this.isIn(c, 65008, 65533) || this.isIn(c, 65536, 983039);
    }

    final boolean isIn(int c, int min, int max) {
        return c >= min && c <= max;
    }

    public void setCharDecoder(CharDecoder charDecoder) {
        this.charDecoder = charDecoder;
    }

    public CharDecoder getCharDecoder() {
        return this.charDecoder;
    }

    void fatalError(int errorID) throws SAXException {
        this.fatalError(errorID, null);
    }

    void fatalError(int errorID, String parameter) throws SAXException {
        this.fatalError(EXmlMsg.getDefault().getString(errorID), parameter);
    }

    void warning(int errorID, String parameter) throws SAXException {
        this.warning(EXmlMsg.getDefault().getString(errorID), parameter);
    }

    public String getWriteBufferAsString() {
        return new String(this.writeBuffer, 0, this.writeBufferIndex);
    }

    public String getElementLocalName() {
        return this.elementLocalName;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    protected static String errorMsg(String errorMsg, String parameter) {
        return parameter != null ? String.valueOf(errorMsg) + ": " + parameter : errorMsg;
    }

    public boolean isValidating() {
        return false;
    }

    public boolean isNamespaceAware() {
        try {
            return this.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            return false;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            return false;
        }
    }

    public void setNamespaceAware(boolean awareness) {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", awareness);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        String feature = this.checkID(name, XmlOrgFeaturesPrefix, XmlOrgFeatureIDs);
        if (feature == null) {
            throw new SAXNotRecognizedException(name);
        }
        if (NamespacesFeature.equals(feature)) {
            return this.fNamespaces;
        }
        if (NamespacePrefixesFeature.equals(feature)) {
            return this.fNamespacesPrefixes;
        }
        if (StringInterningFeature.equals(feature)) {
            if (this.canDoStringInterning()) {
                return this.fStringInterning;
            }
            throw new SAXNotSupportedException(name);
        }
        if (XmlNSUris.equals(feature)) {
            return this.fXmlNSUris;
        }
        throw new SAXNotSupportedException(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        String feature = this.checkID(name, XmlOrgFeaturesPrefix, XmlOrgFeatureIDs);
        if (feature == null) {
            throw new SAXNotRecognizedException(name);
        }
        if (NamespacesFeature.equals(feature)) {
            this.fNamespaces = value;
            return;
        } else if (NamespacePrefixesFeature.equals(feature)) {
            this.fNamespacesPrefixes = value;
            return;
        } else if (StringInterningFeature.equals(feature)) {
            if (!this.canDoStringInterning()) throw new SAXNotSupportedException(name);
            this.fStringInterning = value;
            return;
        } else {
            if (!XmlNSUris.equals(feature)) throw new SAXNotSupportedException(name);
            this.fXmlNSUris = value;
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        String id = this.checkID(name, XmlOrgPropertiesPrefix, XmlOrgPropertyIDs);
        if (id != null) {
            return this.getRecognizedXmlOrgProperty(id);
        }
        throw new SAXNotRecognizedException(name);
    }

    protected Object getRecognizedXmlOrgProperty(String name) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        String id = this.checkID(name, XmlOrgPropertiesPrefix, XmlOrgPropertyIDs);
        if (id == null) {
            throw new SAXNotRecognizedException(name);
        }
        this.setRecognizedXmlOrgProperty(id, value);
    }

    protected void setRecognizedXmlOrgProperty(String name, Object value) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(name);
    }

    protected abstract boolean canDoStringInterning();

    String checkID(String name, String prefix, String[] list) {
        if (name == null) {
            return null;
        }
        if (!name.startsWith(prefix)) {
            return null;
        }
        String id = name.substring(prefix.length());
        int len = list.length;
        int i = 0;
        while (i < len) {
            if (id.startsWith(list[i])) {
                return id;
            }
            ++i;
        }
        return null;
    }

    final void popNamespaceDeclaration() throws SAXException {
        while (!this.currentNSDecl.isNamed(this.elementNamespace, this.elementLocalName)) {
            this.endPrefixMapping(this.currentNSDecl);
            this.currentNSDecl = this.currentNSDecl.parent;
            if (this.currentNSDecl != null) continue;
            this.fatalError(55, this.elementLocalName);
        }
        this.endPrefixMapping(this.currentNSDecl);
        this.currentNSDecl = this.currentNSDecl.parent;
    }

    final void pushNamespaceDeclaration() {
        this.currentNSDecl = new NSDeclaration(this.elementNamespace, this.elementLocalName, this.currentNSDecl);
    }

    final void fireEndElement() throws SAXException {
        this.endElement(this.elementQName, this.elementNamespace, this.elementLocalName);
        if (this.fNamespaces) {
            this.popNamespaceDeclaration();
        }
        --this.elementsDepth;
    }

    final void fireStartElement() throws SAXException {
        this.startElement(this.elementQName, this.elementNamespace, this.elementLocalName, this.attributes == null ? AttributesImpl.EmptyList : this.attributes);
        ++this.elementsDepth;
    }

    protected abstract void startCDATA() throws SAXException;

    protected abstract void endCDATA() throws SAXException;

    final void fireProcessingInstruction() throws SAXException {
        String data = this.writeBufferIndex != 0 ? new String(this.writeBuffer, 0, this.writeBufferIndex) : null;
        this.processingInstruction(this.elementQName, data);
    }

    final void fireCharacters() throws SAXException {
        if (this.elementsDepth > 0) {
            this.characters(this.writeBuffer, 0, this.writeBufferIndex);
        }
    }

    protected abstract void processingInstruction(String var1, String var2) throws SAXException;

    protected abstract void characters(char[] var1, int var2, int var3) throws SAXException;

    protected abstract void startElement(String var1, String var2, String var3, AttributesImpl var4) throws SAXException;

    protected abstract void endElement(String var1, String var2, String var3) throws SAXException;

    protected abstract void startDocument() throws SAXException;

    protected abstract void endDocument() throws SAXException;

    protected abstract void endPrefixMapping(NSDeclaration var1) throws SAXException;

    protected abstract void startPrefixMapping(String var1, String var2) throws SAXException;

    protected abstract void fatalError(String var1, String var2) throws SAXException;

    protected abstract void warning(String var1, String var2) throws SAXException;

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return this.source.getPublicId();
    }

    public String getSystemId() {
        return this.source.getSystemId();
    }
}

