/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public abstract class PlatformURLConnection
extends URLConnection {
    private boolean isInCache = false;
    private boolean isJar = false;
    private URL resolvedURL = null;
    private URL cachedURL = null;
    private URLConnection connection = null;
    private static Properties cacheIndex = new Properties();
    private static String cacheLocation;
    private static String indexName;
    private static String filePrefix;
    private static final int BUF_SIZE = 32768;
    private static final Object NOT_FOUND;
    private static final String CACHE_PROP = ".cache.properties";
    private static final String CACHE_LOCATION_PROP = "location";
    private static final String CACHE_INDEX_PROP = "index";
    private static final String CACHE_PREFIX_PROP = "prefix";
    private static final String CACHE_INDEX = ".index.properties";
    private static final String CACHE_DIR;
    private static final String OPTION_DEBUG = "org.eclipse.core.runtime/url/debug";
    private static final String OPTION_DEBUG_CONNECT = "org.eclipse.core.runtime/url/debug/connect";
    private static final String OPTION_DEBUG_CACHE_LOOKUP = "org.eclipse.core.runtime/url/debug/cachelookup";
    private static final String OPTION_DEBUG_CACHE_COPY = "org.eclipse.core.runtime/url/debug/cachecopy";
    public static final boolean DEBUG;
    public static final boolean DEBUG_CONNECT;
    public static final boolean DEBUG_CACHE_LOOKUP;
    public static final boolean DEBUG_CACHE_COPY;

    static {
        NOT_FOUND = new Object();
        CACHE_DIR = ".eclipse-platform" + File.separator;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            DEBUG_CACHE_COPY = false;
            DEBUG_CACHE_LOOKUP = false;
            DEBUG_CONNECT = false;
            DEBUG = false;
        } else {
            DebugOptions debugOptions = activator.getDebugOptions();
            if (debugOptions != null) {
                DEBUG = debugOptions.getBooleanOption(OPTION_DEBUG, false);
                DEBUG_CONNECT = debugOptions.getBooleanOption(OPTION_DEBUG_CONNECT, true);
                DEBUG_CACHE_LOOKUP = debugOptions.getBooleanOption(OPTION_DEBUG_CACHE_LOOKUP, true);
                DEBUG_CACHE_COPY = debugOptions.getBooleanOption(OPTION_DEBUG_CACHE_COPY, true);
            } else {
                DEBUG_CACHE_COPY = false;
                DEBUG_CACHE_LOOKUP = false;
                DEBUG_CONNECT = false;
                DEBUG = false;
            }
        }
    }

    protected PlatformURLConnection(URL uRL) {
        super(uRL);
    }

    protected boolean allowCaching() {
        return false;
    }

    public void connect() throws IOException {
        this.connect(false);
    }

    private synchronized void connect(boolean bl) throws IOException {
        if (this.connected) {
            return;
        }
        if (this.shouldCache(bl)) {
            try {
                URL uRL = this.getURLInCache();
                if (uRL != null) {
                    this.connection = uRL.openConnection();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.connection == null) {
            this.connection = this.resolvedURL.openConnection();
        }
        this.connected = true;
        if (DEBUG && DEBUG_CONNECT) {
            this.debug("Connected as " + this.connection.getURL());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyToCache() throws IOException {
        FileOutputStream fileOutputStream;
        block23: {
            String string;
            URL uRL;
            String string2;
            int n;
            String string3;
            if (this.isInCache | this.cachedURL == null) {
                return;
            }
            if (this.isJar) {
                string3 = this.url.getFile();
                n = string3.lastIndexOf("!/");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                string2 = string3;
            } else {
                string2 = this.url.getFile();
            }
            if (this.isJar) {
                string3 = this.resolvedURL.getFile();
                n = string3.lastIndexOf("!/");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                uRL = new URL(string3);
            } else {
                uRL = this.resolvedURL;
            }
            InputStream inputStream = null;
            if (this.isJar) {
                string3 = this.cachedURL.getFile();
                n = string3.indexOf(":");
                if (n != -1) {
                    string3 = string3.substring(n + 1);
                }
                if ((n = string3.lastIndexOf("!/")) != -1) {
                    string3 = string3.substring(0, n);
                }
                string = string3;
            } else {
                string = this.cachedURL.getFile();
            }
            File file = null;
            fileOutputStream = null;
            boolean bl = false;
            long l = 0L;
            try {
                try {
                    if (DEBUG && DEBUG_CACHE_COPY) {
                        if (this.isJar) {
                            this.debug("Caching jar as " + string);
                        } else {
                            this.debug("Caching as " + string);
                        }
                    }
                    inputStream = uRL.openStream();
                    byte[] byArray = new byte[32768];
                    int n2 = inputStream.read(byArray);
                    file = new File(string);
                    fileOutputStream = new FileOutputStream(file);
                    while (true) {
                        block24: {
                            if (n2 != -1) break block24;
                            inputStream.close();
                            inputStream = null;
                            fileOutputStream.flush();
                            fileOutputStream.getFD().sync();
                            fileOutputStream.close();
                            fileOutputStream = null;
                            cacheIndex.put(string2, string);
                            this.isInCache = true;
                            break;
                        }
                        l += (long)n2;
                        fileOutputStream.write(byArray, 0, n2);
                        n2 = inputStream.read(byArray);
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                    cacheIndex.put(string2, NOT_FOUND);
                    if (!DEBUG) throw iOException;
                    if (!DEBUG_CACHE_COPY) throw iOException;
                    this.debug("Failed to cache due to " + iOException);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (!bl && DEBUG && DEBUG_CACHE_COPY) {
                    this.debug(String.valueOf(l) + " bytes copied");
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            {
                Object var14_16 = null;
                if (!bl && DEBUG && DEBUG_CACHE_COPY) {
                    this.debug(String.valueOf(l) + " bytes copied");
                }
                if (inputStream == null) break block23;
            }
            inputStream.close();
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    protected void debug(String string) {
        System.out.println("URL " + this.getURL().toString() + "^" + Integer.toHexString(Thread.currentThread().hashCode()) + " " + string);
    }

    private static void debugStartup(String string) {
        System.out.println("URL " + string);
    }

    public URL[] getAuxillaryURLs() throws IOException {
        return null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.connection.getInputStream();
    }

    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    public URL getURLAsLocal() throws IOException {
        this.connect(true);
        URL uRL = this.connection.getURL();
        String string = uRL.getProtocol();
        if (!(string.equals("file") || string.equals("jar") || string.startsWith("bundle"))) {
            throw new IOException(NLS.bind((String)CommonMessages.url_noaccess, (Object)string));
        }
        return uRL;
    }

    private URL getURLInCache() throws IOException {
        String string;
        if (!this.allowCaching()) {
            return null;
        }
        if (this.isInCache) {
            return this.cachedURL;
        }
        if (cacheLocation == null | cacheIndex == null) {
            return null;
        }
        String string2 = "";
        String string3 = null;
        if (this.isJar) {
            string2 = this.url.getFile();
            int n = string2.lastIndexOf("!/");
            if (n != -1) {
                string3 = string2.substring(n + "!/".length());
                string2 = string2.substring(0, n);
            }
        } else {
            string2 = this.url.getFile();
        }
        if ((string = (String)cacheIndex.get(string2)) != null && string == NOT_FOUND) {
            throw new IOException();
        }
        if (string != null && !new File(string).exists()) {
            string = null;
            cacheIndex.remove(this.url.getFile());
        }
        if (string != null) {
            if (this.isJar) {
                if (DEBUG && DEBUG_CACHE_LOOKUP) {
                    this.debug("Jar located in cache as " + string);
                }
                string = "file:" + string + "!/" + string3;
                this.cachedURL = new URL("jar", null, -1, string);
            } else {
                if (DEBUG && DEBUG_CACHE_LOOKUP) {
                    this.debug("Located in cache as " + string);
                }
                this.cachedURL = new URL("file", null, -1, string);
            }
            this.isInCache = true;
        } else {
            int n = string2.lastIndexOf("/");
            string = string2.substring(n + 1);
            string = String.valueOf(cacheLocation) + filePrefix + Long.toString(new Date().getTime()) + "_" + string;
            string = string.replace(File.separatorChar, '/');
            if (this.isJar) {
                string = "file:" + string + "!/" + string3;
                this.cachedURL = new URL("jar", null, -1, string);
            } else {
                this.cachedURL = new URL("file", null, -1, string);
            }
            this.copyToCache();
        }
        return this.cachedURL;
    }

    protected URL resolve() throws IOException {
        throw new IOException();
    }

    protected String getId(String string) {
        String string2 = (String)this.parse(string)[0];
        return string2 == null ? string : string2;
    }

    protected String getVersion(String string) {
        Version version = (Version)this.parse(string)[1];
        return version == null ? "" : version.toString();
    }

    private Object[] parse(String string) {
        String string2 = null;
        Version version = null;
        int n = string.indexOf(95);
        while (n >= 0) {
            string2 = string.substring(0, n);
            try {
                version = Version.parseVersion((String)string.substring(n + 1));
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n = string.indexOf(95, n + 1);
            }
        }
        return new Object[]{string2, version};
    }

    void setResolvedURL(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException();
        }
        if (this.resolvedURL != null) {
            return;
        }
        int n = uRL.getFile().lastIndexOf("!/");
        boolean bl = this.isJar = -1 != n;
        if (this.isJar && !uRL.getProtocol().equals("jar")) {
            uRL = new URL("jar", "", -1, uRL.toExternalForm());
        }
        this.resolvedURL = uRL;
    }

    private boolean shouldCache(boolean bl) {
        String string = this.resolvedURL.getProtocol();
        String string2 = this.resolvedURL.getFile();
        if (string.equals("file")) {
            return false;
        }
        if (string.equals("jar") && string2.startsWith("file")) {
            return false;
        }
        if (bl) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void shutdown() {
        if (indexName == null) return;
        if (cacheLocation == null) return;
        Enumeration<Object> enumeration = cacheIndex.keys();
        while (true) {
            if (!enumeration.hasMoreElements()) {
                if (cacheIndex.size() != 0) break;
                return;
            }
            String string = (String)enumeration.nextElement();
            Object object = cacheIndex.get(string);
            if (object != NOT_FOUND) continue;
            cacheIndex.remove(string);
        }
        try {
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(String.valueOf(cacheLocation) + indexName);
            try {
                cacheIndex.store(fileOutputStream, null);
                fileOutputStream.flush();
                fileOutputStream.getFD().sync();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fileOutputStream.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                fileOutputStream.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void startup(String string, String string2, String string3, String string4) {
        String string5;
        FileInputStream fileInputStream;
        PlatformURLConnection.verifyLocation(string);
        String string6 = string.trim();
        if (!string6.endsWith(File.separator)) {
            string6 = String.valueOf(string6) + File.separator;
        }
        string6 = String.valueOf(string6) + CACHE_PROP;
        File file = new File(string6);
        Properties properties = null;
        if (file.exists()) {
            try {
                properties = new Properties();
                fileInputStream = new FileInputStream(file);
                try {
                    properties.load(fileInputStream);
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    fileInputStream.close();
                    throw throwable;
                }
                {
                    string5 = null;
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                properties = null;
            }
        }
        if (properties == null) {
            properties = new Properties();
            string5 = System.getProperty("user.home");
            if (!string5.endsWith(File.separator)) {
                string5 = String.valueOf(string5) + File.separator;
            }
            string5 = String.valueOf(string5) + CACHE_DIR;
            properties.put(CACHE_LOCATION_PROP, string5);
            string5 = Long.toString(new Date().getTime());
            properties.put(CACHE_PREFIX_PROP, string5);
            string5 = String.valueOf(string5) + CACHE_INDEX;
            properties.put(CACHE_INDEX_PROP, string5);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                try {
                    properties.store(fileOutputStream, null);
                    fileOutputStream.flush();
                    fileOutputStream.getFD().sync();
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    fileOutputStream.close();
                    throw throwable;
                }
                {
                    Object var10_15 = null;
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        filePrefix = (String)properties.get(CACHE_PREFIX_PROP);
        indexName = (String)properties.get(CACHE_INDEX_PROP);
        cacheLocation = (String)properties.get(CACHE_LOCATION_PROP);
        if (DEBUG) {
            PlatformURLConnection.debugStartup("Cache location: " + cacheLocation);
            PlatformURLConnection.debugStartup("Cache index: " + indexName);
            PlatformURLConnection.debugStartup("Cache file prefix: " + filePrefix);
        }
        if (!PlatformURLConnection.verifyLocation(cacheLocation)) {
            indexName = null;
            cacheLocation = null;
            if (!DEBUG) return;
            PlatformURLConnection.debugStartup("Failed to create cache directory structure. Caching suspended");
            return;
        }
        if (cacheLocation == null) return;
        if (indexName == null) return;
        try {
            fileInputStream = new FileInputStream(String.valueOf(cacheLocation) + indexName);
            try {
                cacheIndex.load(fileInputStream);
            }
            catch (Throwable throwable) {
                string5 = null;
                fileInputStream.close();
                throw throwable;
            }
            {
                string5 = null;
                fileInputStream.close();
                return;
            }
        }
        catch (IOException iOException) {
            if (!DEBUG) return;
            PlatformURLConnection.debugStartup("Failed to initialize cache");
        }
    }

    private static boolean verifyLocation(String string) {
        File file = new File(string);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }
}

