/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;

public class PreferenceNode
implements IPreferenceNode {
    private IPreferencePage page;
    private List subNodes;
    private String classname;
    private String id;
    private String label;
    private ImageDescriptor imageDescriptor;
    private Image image;

    public PreferenceNode(String string) {
        Assert.isNotNull(string);
        this.id = string;
    }

    public PreferenceNode(String string, String string2, ImageDescriptor imageDescriptor, String string3) {
        this(string);
        this.imageDescriptor = imageDescriptor;
        Assert.isNotNull(string2);
        this.label = string2;
        this.classname = string3;
    }

    public PreferenceNode(String string, IPreferencePage iPreferencePage) {
        this(string);
        Assert.isNotNull(iPreferencePage);
        this.page = iPreferencePage;
    }

    public void add(IPreferenceNode iPreferenceNode) {
        if (this.subNodes == null) {
            this.subNodes = new ArrayList();
        }
        this.subNodes.add(iPreferenceNode);
    }

    private Object createObject(String string) {
        Assert.isNotNull(string);
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                return clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
        return null;
    }

    public void createPage() {
        this.page = (IPreferencePage)this.createObject(this.classname);
        if (this.getLabelImage() != null) {
            this.page.setImageDescriptor(this.imageDescriptor);
        }
        this.page.setTitle(this.label);
    }

    public void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    public IPreferenceNode findSubNode(String string) {
        Assert.isNotNull(string);
        Assert.isTrue(string.length() > 0);
        if (this.subNodes == null) {
            return null;
        }
        int n = this.subNodes.size();
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode iPreferenceNode = (IPreferenceNode)this.subNodes.get(n2);
            if (string.equals(iPreferenceNode.getId())) {
                return iPreferenceNode;
            }
            ++n2;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    protected ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public Image getLabelImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    public String getLabelText() {
        if (this.page != null) {
            return this.page.getTitle();
        }
        return this.label;
    }

    public IPreferencePage getPage() {
        return this.page;
    }

    public IPreferenceNode[] getSubNodes() {
        if (this.subNodes == null) {
            return new IPreferenceNode[0];
        }
        return this.subNodes.toArray(new IPreferenceNode[this.subNodes.size()]);
    }

    public IPreferenceNode remove(String string) {
        IPreferenceNode iPreferenceNode = this.findSubNode(string);
        if (iPreferenceNode != null) {
            this.remove(iPreferenceNode);
        }
        return iPreferenceNode;
    }

    public boolean remove(IPreferenceNode iPreferenceNode) {
        if (this.subNodes == null) {
            return false;
        }
        return this.subNodes.remove(iPreferenceNode);
    }

    public void setPage(IPreferencePage iPreferencePage) {
        this.page = iPreferencePage;
    }
}

