/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.AbstractResourceManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public final class DeviceResourceManager
extends AbstractResourceManager {
    private Device device;
    private Image missingImage;

    public Device getDevice() {
        return this.device;
    }

    public DeviceResourceManager(Device device) {
        this.device = device;
    }

    protected Object allocate(DeviceResourceDescriptor deviceResourceDescriptor) throws DeviceResourceException {
        return deviceResourceDescriptor.createResource(this.device);
    }

    protected void deallocate(Object object, DeviceResourceDescriptor deviceResourceDescriptor) {
        deviceResourceDescriptor.destroyResource(object);
    }

    protected Image getDefaultImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    public void dispose() {
        super.dispose();
        if (this.missingImage != null) {
            this.missingImage.dispose();
            this.missingImage = null;
        }
    }
}

