/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.SubContributionItem;

public abstract class SubContributionManager
implements IContributionManager {
    private IContributionManager parentMgr;
    private Map mapItemToWrapper = new HashMap();
    private boolean visible = false;

    public SubContributionManager(IContributionManager iContributionManager) {
        this.parentMgr = iContributionManager;
    }

    public void add(IContributionItem iContributionItem) {
        iContributionItem.setParent(this);
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.add(subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    public void appendToGroup(String string, IContributionItem iContributionItem) {
        iContributionItem.setParent(this);
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.appendToGroup(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    public void disposeManager() {
        Iterator iterator = this.mapItemToWrapper.values().iterator();
        while (iterator.hasNext()) {
            IContributionItem iContributionItem = (IContributionItem)iterator.next();
            iContributionItem.dispose();
        }
        this.removeAll();
    }

    public IContributionItem find(String string) {
        IContributionItem iContributionItem = this.parentMgr.find(string);
        iContributionItem = this.unwrap(iContributionItem);
        return iContributionItem;
    }

    public IContributionItem[] getItems() {
        IContributionItem[] iContributionItemArray = new IContributionItem[this.mapItemToWrapper.size()];
        this.mapItemToWrapper.keySet().toArray(iContributionItemArray);
        return iContributionItemArray;
    }

    public IContributionManager getParent() {
        return this.parentMgr;
    }

    public IContributionManagerOverrides getOverrides() {
        return this.parentMgr.getOverrides();
    }

    public void insertAfter(String string, IContributionItem iContributionItem) {
        iContributionItem.setParent(this);
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.insertAfter(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    public void insertBefore(String string, IContributionItem iContributionItem) {
        iContributionItem.setParent(this);
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.insertBefore(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    public boolean isDirty() {
        return this.parentMgr.isDirty();
    }

    public boolean isEmpty() {
        return this.parentMgr.isEmpty();
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void itemAdded(IContributionItem iContributionItem, SubContributionItem subContributionItem) {
        this.mapItemToWrapper.put(iContributionItem, subContributionItem);
    }

    protected void itemRemoved(IContributionItem iContributionItem) {
        this.mapItemToWrapper.remove(iContributionItem);
    }

    public Enumeration items() {
        final Iterator iterator = this.mapItemToWrapper.values().iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public void markDirty() {
        this.parentMgr.markDirty();
    }

    public void prependToGroup(String string, IContributionItem iContributionItem) {
        iContributionItem.setParent(this);
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.prependToGroup(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    public IContributionItem remove(String string) {
        IContributionItem iContributionItem = this.parentMgr.remove(string);
        if (iContributionItem != null) {
            this.itemRemoved(iContributionItem);
        }
        return iContributionItem;
    }

    public IContributionItem remove(IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = (SubContributionItem)this.mapItemToWrapper.get(iContributionItem);
        if (subContributionItem == null) {
            return null;
        }
        IContributionItem iContributionItem2 = this.parentMgr.remove(subContributionItem);
        if (iContributionItem2 == null) {
            return null;
        }
        this.itemRemoved(iContributionItem);
        return iContributionItem;
    }

    public void removeAll() {
        Iterator iterator = this.mapItemToWrapper.values().iterator();
        while (iterator.hasNext()) {
            IContributionItem iContributionItem = (IContributionItem)iterator.next();
            this.parentMgr.remove(iContributionItem);
        }
        this.mapItemToWrapper.clear();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        if (this.mapItemToWrapper.size() > 0) {
            Iterator iterator = this.mapItemToWrapper.values().iterator();
            while (iterator.hasNext()) {
                IContributionItem iContributionItem = (IContributionItem)iterator.next();
                iContributionItem.setVisible(bl);
            }
            this.parentMgr.markDirty();
        }
    }

    protected SubContributionItem wrap(IContributionItem iContributionItem) {
        return new SubContributionItem(iContributionItem);
    }

    protected IContributionItem unwrap(IContributionItem iContributionItem) {
        if (iContributionItem instanceof SubContributionItem) {
            return ((SubContributionItem)iContributionItem).getInnerItem();
        }
        return iContributionItem;
    }
}

