/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.internal.registry.BufferedRandomInputStream;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.HashtableOfInt;
import org.eclipse.core.internal.registry.HashtableOfStringAndInt;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.RegistryIndexElement;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObjectFactory;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.osgi.util.NLS;

public class TableReader {
    static final int NULL = 0;
    static final int OBJECT = 1;
    static final int CACHE_VERSION = 5;
    static final String MAIN = ".mainData";
    BufferedRandomInputStream mainDataFile = null;
    DataInputStream mainInput = null;
    static final String EXTRA = ".extraData";
    BufferedRandomInputStream extraDataFile = null;
    DataInputStream extraInput = null;
    static final String TABLE = ".table";
    File tableFile;
    static final String CONTRIBUTIONS = ".contributions";
    File contributionsFile;
    static final String CONTRIBUTORS = ".contributors";
    File contributorsFile;
    static final String NAMESPACES = ".namespaces";
    File namespacesFile;
    static final String ORPHANS = ".orphans";
    File orphansFile;
    private static final byte fileError = 0;
    private static final boolean DEBUG = false;
    private boolean holdObjects = false;
    private ExtensionRegistry registry;
    static final float contributorsLoadFactor = 1.2f;

    void setMainDataFile(File file) throws IOException {
        this.mainDataFile = new BufferedRandomInputStream(file);
        this.mainInput = new DataInputStream(this.mainDataFile);
    }

    void setExtraDataFile(File file) throws IOException {
        this.extraDataFile = new BufferedRandomInputStream(file);
        this.extraInput = new DataInputStream(this.extraDataFile);
    }

    void setTableFile(File file) {
        this.tableFile = file;
    }

    void setContributionsFile(File file) {
        this.contributionsFile = file;
    }

    void setContributorsFile(File file) {
        this.contributorsFile = file;
    }

    void setNamespacesFile(File file) {
        this.namespacesFile = file;
    }

    void setOrphansFile(File file) {
        this.orphansFile = file;
    }

    public TableReader(ExtensionRegistry extensionRegistry) {
        this.registry = extensionRegistry;
    }

    public Object[] loadTables(long l) {
        FilterInputStream filterInputStream;
        block6: {
            filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.tableFile)));
                if (this.checkCacheValidity((DataInputStream)filterInputStream, l)) break block6;
                return null;
            }
            catch (IOException iOException) {
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheReadProblems, (Throwable)iOException));
                return null;
            }
        }
        Integer n = new Integer(((DataInputStream)filterInputStream).readInt());
        HashtableOfInt hashtableOfInt = new HashtableOfInt();
        hashtableOfInt.load((DataInputStream)filterInputStream);
        HashtableOfStringAndInt hashtableOfStringAndInt = new HashtableOfStringAndInt();
        hashtableOfStringAndInt.load((DataInputStream)filterInputStream);
        return new Object[]{hashtableOfInt, hashtableOfStringAndInt, n};
    }

    private boolean checkCacheValidity(DataInputStream dataInputStream, long l) {
        boolean bl;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        block5: {
            block4: {
                try {
                    int n = dataInputStream.readInt();
                    if (n == 5) break block4;
                    return false;
                }
                catch (IOException iOException) {
                    this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheInconsistent, (Throwable)iOException));
                    return false;
                }
            }
            long l8 = dataInputStream.readLong();
            long l9 = dataInputStream.readLong();
            l7 = dataInputStream.readLong();
            l6 = dataInputStream.readLong();
            l5 = dataInputStream.readLong();
            l4 = dataInputStream.readLong();
            l3 = dataInputStream.readLong();
            l2 = dataInputStream.readLong();
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            String string3 = dataInputStream.readUTF();
            boolean bl2 = l == 0L || l == l9;
            boolean bl3 = l8 == this.registry.computeState();
            boolean bl4 = string.equals(RegistryProperties.getProperty("osgi.os", ""));
            boolean bl5 = string2.equals(RegistryProperties.getProperty("osgi.ws", ""));
            boolean bl6 = string3.equals(RegistryProperties.getProperty("osgi.nl", ""));
            if (bl2 && bl3 && bl4 && bl5 && bl6) break block5;
            return false;
        }
        boolean bl7 = l7 == this.mainDataFile.length();
        boolean bl8 = l6 == this.extraDataFile.length();
        boolean bl9 = l5 == this.contributionsFile.length();
        boolean bl10 = l4 == this.contributorsFile.length();
        boolean bl11 = l3 == this.namespacesFile.length();
        boolean bl12 = bl = l2 == this.orphansFile.length();
        return bl7 && bl8 && bl9 && bl10 && bl11 && bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadConfigurationElement(int n) {
        try {
            BufferedRandomInputStream bufferedRandomInputStream = this.mainDataFile;
            synchronized (bufferedRandomInputStream) {
                this.goToInputFile(n);
                return this.basicLoadConfigurationElement(this.mainInput, null);
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.mainDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private ConfigurationElement basicLoadConfigurationElement(DataInputStream dataInputStream, String string) throws IOException {
        int n = dataInputStream.readInt();
        String string2 = this.readStringOrNull(dataInputStream);
        String string3 = this.readStringOrNull(dataInputStream);
        int n2 = dataInputStream.readInt();
        byte by = dataInputStream.readByte();
        int n3 = dataInputStream.readInt();
        String[] stringArray = this.readPropertiesAndValue(dataInputStream);
        int[] nArray = this.readArray(dataInputStream);
        if (string == null) {
            string = string2;
        }
        return this.getObjectFactory().createConfigurationElement(n, string, string3, stringArray, nArray, n3, n2, by, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadThirdLevelConfigurationElements(int n, RegistryObjectManager registryObjectManager) {
        try {
            BufferedRandomInputStream bufferedRandomInputStream = this.extraDataFile;
            synchronized (bufferedRandomInputStream) {
                this.goToExtraFile(n);
                return this.loadConfigurationElementAndChildren(null, this.extraInput, 3, Integer.MAX_VALUE, registryObjectManager, null);
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.extraDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private ConfigurationElement loadConfigurationElementAndChildren(DataInputStream dataInputStream, DataInputStream dataInputStream2, int n, int n2, RegistryObjectManager registryObjectManager, String string) throws IOException {
        DataInputStream dataInputStream3 = dataInputStream;
        if (n > 2) {
            dataInputStream3 = dataInputStream2;
        }
        ConfigurationElement configurationElement = this.basicLoadConfigurationElement(dataInputStream3, string);
        if (string == null) {
            string = configurationElement.getContributorId();
        }
        int[] nArray = configurationElement.getRawChildren();
        if (n + 1 > n2) {
            return configurationElement;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            ConfigurationElement configurationElement2 = this.loadConfigurationElementAndChildren(dataInputStream3, dataInputStream2, n + 1, n2, registryObjectManager, string);
            registryObjectManager.add(configurationElement2, this.holdObjects);
            ++n3;
        }
        return configurationElement;
    }

    private String[] readPropertiesAndValue(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return RegistryObjectManager.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readStringOrNull(dataInputStream);
            ++n2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadExtension(int n) {
        try {
            BufferedRandomInputStream bufferedRandomInputStream = this.mainDataFile;
            synchronized (bufferedRandomInputStream) {
                this.goToInputFile(n);
                return this.basicLoadExtension(this.mainInput);
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.mainDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private Extension basicLoadExtension(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String string = this.readStringOrNull(this.mainInput);
        String string2 = this.readStringOrNull(this.mainInput);
        int[] nArray = this.readArray(this.mainInput);
        int n2 = this.mainInput.readInt();
        return this.getObjectFactory().createExtension(n, string, string2, nArray, n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionPoint loadExtensionPointTree(int n, RegistryObjectManager registryObjectManager) {
        try {
            BufferedRandomInputStream bufferedRandomInputStream = this.mainDataFile;
            synchronized (bufferedRandomInputStream) {
                ExtensionPoint extensionPoint = (ExtensionPoint)this.loadExtensionPoint(n);
                int[] nArray = extensionPoint.getRawChildren();
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Extension extension = this.basicLoadExtension(this.mainInput);
                    registryObjectManager.add(extension, this.holdObjects);
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    int n4 = this.mainInput.readInt();
                    int n5 = 0;
                    while (n5 < n4) {
                        registryObjectManager.add(this.loadConfigurationElementAndChildren(this.mainInput, null, 1, 2, registryObjectManager, null), this.holdObjects);
                        ++n5;
                    }
                    ++n3;
                }
                return extensionPoint;
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.mainDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private Object loadExtensionPoint(int n) {
        try {
            this.goToInputFile(n);
            return this.basicLoadExtensionPoint();
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.mainDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private ExtensionPoint basicLoadExtensionPoint() throws IOException {
        int n = this.mainInput.readInt();
        int[] nArray = this.readArray(this.mainInput);
        int n2 = this.mainInput.readInt();
        return this.getObjectFactory().createExtensionPoint(n, nArray, n2, true);
    }

    private int[] readArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return RegistryObjectManager.EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = dataInputStream.readInt();
            ++n2;
        }
        return nArray;
    }

    private void goToInputFile(int n) throws IOException {
        this.mainDataFile.seek(n);
    }

    private void goToExtraFile(int n) throws IOException {
        this.extraDataFile.seek(n);
    }

    private String readStringOrNull(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        return dataInputStream.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] loadExtensionExtraData(int n) {
        try {
            BufferedRandomInputStream bufferedRandomInputStream = this.extraDataFile;
            synchronized (bufferedRandomInputStream) {
                this.goToExtraFile(n);
                return this.basicLoadExtensionExtraData();
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.extraDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private String[] basicLoadExtensionExtraData() throws IOException {
        return new String[]{this.readStringOrNull(this.extraInput), this.readStringOrNull(this.extraInput), this.readStringOrNull(this.extraInput)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] loadExtensionPointExtraData(int n) {
        try {
            BufferedRandomInputStream bufferedRandomInputStream = this.extraDataFile;
            synchronized (bufferedRandomInputStream) {
                this.goToExtraFile(n);
                return this.basicLoadExtensionPointExtraData();
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.extraDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return null;
        }
    }

    private String[] basicLoadExtensionPointExtraData() throws IOException {
        String[] stringArray = new String[]{this.readStringOrNull(this.extraInput), this.readStringOrNull(this.extraInput), this.readStringOrNull(this.extraInput), this.readStringOrNull(this.extraInput), this.readStringOrNull(this.extraInput)};
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyedHashSet loadContributions() {
        KeyedHashSet keyedHashSet;
        FilterInputStream filterInputStream = null;
        try {
            try {
                File file = this.contributionsFile;
                synchronized (file) {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.contributionsFile)));
                    int n = ((DataInputStream)filterInputStream).readInt();
                    KeyedHashSet keyedHashSet2 = new KeyedHashSet(n);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            keyedHashSet = keyedHashSet2;
                            break;
                        }
                        String string = this.readStringOrNull((DataInputStream)filterInputStream);
                        Contribution contribution = this.getObjectFactory().createContribution(string, true);
                        contribution.setRawChildren(this.readArray((DataInputStream)filterInputStream));
                        keyedHashSet2.add(contribution);
                        ++n2;
                    }
                }
                Object var8_11 = null;
                if (filterInputStream == null) return keyedHashSet;
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.contributionsFile);
                this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
                Object var8_12 = null;
                if (filterInputStream == null) return null;
                try {
                    filterInputStream.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (filterInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            filterInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        filterInputStream.close();
        return keyedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap loadContributors() {
        HashMap<String, RegistryContributor> hashMap;
        HashMap<String, RegistryContributor> hashMap2 = null;
        FilterInputStream filterInputStream = null;
        try {
            try {
                File file = this.contributorsFile;
                synchronized (file) {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.contributorsFile)));
                    int n = ((DataInputStream)filterInputStream).readInt();
                    hashMap2 = new HashMap<String, RegistryContributor>((int)((float)n * 1.2f));
                    int n2 = 0;
                    while (n2 < n) {
                        String string = this.readStringOrNull((DataInputStream)filterInputStream);
                        String string2 = this.readStringOrNull((DataInputStream)filterInputStream);
                        String string3 = this.readStringOrNull((DataInputStream)filterInputStream);
                        String string4 = this.readStringOrNull((DataInputStream)filterInputStream);
                        hashMap2.put(string, new RegistryContributor(string, string2, string3, string4));
                        ++n2;
                    }
                }
                hashMap = hashMap2;
                Object var10_13 = null;
                if (filterInputStream == null) return hashMap;
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.contributorsFile);
                this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
                Object var10_14 = null;
                if (filterInputStream == null) return null;
                try {
                    filterInputStream.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (filterInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            filterInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        filterInputStream.close();
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyedHashSet loadNamespaces() {
        KeyedHashSet keyedHashSet;
        FilterInputStream filterInputStream = null;
        try {
            try {
                File file = this.namespacesFile;
                synchronized (file) {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.namespacesFile)));
                    int n = ((DataInputStream)filterInputStream).readInt();
                    KeyedHashSet keyedHashSet2 = new KeyedHashSet(n);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            keyedHashSet = keyedHashSet2;
                            break;
                        }
                        String string = this.readStringOrNull((DataInputStream)filterInputStream);
                        RegistryIndexElement registryIndexElement = new RegistryIndexElement(string);
                        registryIndexElement.updateExtensionPoints(this.readArray((DataInputStream)filterInputStream), true);
                        registryIndexElement.updateExtensions(this.readArray((DataInputStream)filterInputStream), true);
                        keyedHashSet2.add(registryIndexElement);
                        ++n2;
                    }
                }
                Object var8_11 = null;
                if (filterInputStream == null) return keyedHashSet;
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.namespacesFile);
                this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
                Object var8_12 = null;
                if (filterInputStream == null) return null;
                try {
                    filterInputStream.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (filterInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            filterInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        filterInputStream.close();
        return keyedHashSet;
    }

    private void loadAllOrphans(RegistryObjectManager registryObjectManager) throws IOException {
        int n = registryObjectManager.getOrphanExtensions().size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.mainInput.readInt();
            int n4 = 0;
            while (n4 < n3) {
                this.loadFullExtension(registryObjectManager);
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                int n5 = this.mainInput.readInt();
                int n6 = 0;
                while (n6 < n5) {
                    registryObjectManager.add(this.loadConfigurationElementAndChildren(this.mainInput, this.extraInput, 1, Integer.MAX_VALUE, registryObjectManager, null), true);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public boolean readAllCache(RegistryObjectManager registryObjectManager) {
        try {
            int n = registryObjectManager.getExtensionPoints().size();
            int n2 = 0;
            while (n2 < n) {
                registryObjectManager.add(this.readAllExtensionPointTree(registryObjectManager), this.holdObjects);
                ++n2;
            }
            this.loadAllOrphans(registryObjectManager);
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)RegistryMessages.meta_regCacheIOExceptionReading, (Object)this.mainDataFile);
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, string, (Throwable)iOException));
            return false;
        }
        return true;
    }

    private ExtensionPoint readAllExtensionPointTree(RegistryObjectManager registryObjectManager) throws IOException {
        ExtensionPoint extensionPoint = this.loadFullExtensionPoint();
        int[] nArray = extensionPoint.getRawChildren();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.loadFullExtension(registryObjectManager);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3 = this.mainInput.readInt();
            int n4 = 0;
            while (n4 < n3) {
                registryObjectManager.add(this.loadConfigurationElementAndChildren(this.mainInput, this.extraInput, 1, Integer.MAX_VALUE, registryObjectManager, null), true);
                ++n4;
            }
            ++n2;
        }
        return extensionPoint;
    }

    private ExtensionPoint loadFullExtensionPoint() throws IOException {
        ExtensionPoint extensionPoint = this.basicLoadExtensionPoint();
        String[] stringArray = this.basicLoadExtensionPointExtraData();
        extensionPoint.setLabel(stringArray[0]);
        extensionPoint.setSchema(stringArray[1]);
        extensionPoint.setUniqueIdentifier(stringArray[2]);
        extensionPoint.setNamespace(stringArray[3]);
        extensionPoint.setContributorId(stringArray[4]);
        return extensionPoint;
    }

    private Extension loadFullExtension(RegistryObjectManager registryObjectManager) throws IOException {
        Extension extension = this.basicLoadExtension(this.mainInput);
        String[] stringArray = this.basicLoadExtensionExtraData();
        extension.setLabel(stringArray[0]);
        extension.setExtensionPointIdentifier(stringArray[1]);
        extension.setContributorId(stringArray[2]);
        registryObjectManager.add(extension, this.holdObjects);
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap loadOrphans() {
        HashMap<String, int[]> hashMap;
        FilterInputStream filterInputStream = null;
        try {
            try {
                File file = this.orphansFile;
                synchronized (file) {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.orphansFile)));
                    int n = ((DataInputStream)filterInputStream).readInt();
                    HashMap<String, int[]> hashMap2 = new HashMap<String, int[]>(n);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            hashMap = hashMap2;
                            break;
                        }
                        String string = ((DataInputStream)filterInputStream).readUTF();
                        int[] nArray = this.readArray((DataInputStream)filterInputStream);
                        hashMap2.put(string, nArray);
                        ++n2;
                    }
                }
                Object var8_9 = null;
                if (filterInputStream == null) return hashMap;
            }
            catch (IOException iOException) {
                Object var8_10 = null;
                if (filterInputStream == null) return null;
                try {
                    filterInputStream.close();
                    return null;
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (filterInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            filterInputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        filterInputStream.close();
        return hashMap;
    }

    public void setHoldObjects(boolean bl) {
        this.holdObjects = bl;
    }

    private void log(Status status) {
        this.registry.log((IStatus)status);
    }

    private RegistryObjectFactory getObjectFactory() {
        return this.registry.getElementFactory();
    }

    public static String getTestFileName() {
        return TABLE;
    }

    public void close() {
        try {
            if (this.mainInput != null) {
                this.mainInput.close();
            }
            if (this.extraInput != null) {
                this.extraInput.close();
            }
        }
        catch (IOException iOException) {
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheReadProblems, (Throwable)iOException));
        }
    }
}

