/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.IParameterTypeListener;
import org.eclipse.core.commands.ParameterTypeEvent;
import org.eclipse.core.commands.common.HandleObject;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.internal.commands.util.Util;

public final class ParameterType
extends HandleObject
implements Comparable {
    private transient AbstractParameterValueConverter parameterTypeConverter;
    private transient String type = null;
    static /* synthetic */ Class class$0;

    private static final boolean isInstanceOf(Object object, String string) {
        if (object == null) {
            return false;
        }
        return ParameterType.isSubtype(object.getClass(), string);
    }

    private static final boolean isSubtype(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && ParameterType.isSubtype(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (ParameterType.isSubtype(classArray[n], string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    ParameterType(String string) {
        super(string);
    }

    public final void addListener(IParameterTypeListener iParameterTypeListener) {
        this.addListenerObject(iParameterTypeListener);
    }

    public final int compareTo(Object object) {
        ParameterType parameterType = (ParameterType)object;
        int n = Util.compare(this.defined, parameterType.defined);
        if (n == 0) {
            n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)parameterType.id));
        }
        return n;
    }

    public final void define(String string, AbstractParameterValueConverter abstractParameterValueConverter) {
        String string2;
        boolean bl = !this.defined;
        this.defined = true;
        if (string == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            string2 = clazz.getName();
        } else {
            string2 = string;
        }
        this.type = string2;
        this.parameterTypeConverter = abstractParameterValueConverter;
        this.fireParameterTypeChanged(new ParameterTypeEvent(this, bl));
    }

    private final void fireParameterTypeChanged(ParameterTypeEvent parameterTypeEvent) {
        if (parameterTypeEvent == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (!this.isListenerAttached()) {
            return;
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IParameterTypeListener iParameterTypeListener = (IParameterTypeListener)objectArray[n];
            iParameterTypeListener.parameterTypeChanged(parameterTypeEvent);
            ++n;
        }
    }

    public final AbstractParameterValueConverter getValueConverter() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot use getValueConverter() with an undefined ParameterType");
        }
        return this.parameterTypeConverter;
    }

    public boolean isCompatible(Object object) throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot use isCompatible() with an undefined ParameterType");
        }
        return ParameterType.isInstanceOf(object, this.type);
    }

    public final void removeListener(IParameterTypeListener iParameterTypeListener) {
        this.removeListenerObject(iParameterTypeListener);
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ParameterType(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        boolean bl = this.defined;
        this.defined = false;
        this.type = null;
        this.parameterTypeConverter = null;
        this.fireParameterTypeChanged(new ParameterTypeEvent(this, bl));
    }
}

