/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        return 1;
    }

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        if (iContentDescription == null || !iContentDescription.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            return 1;
        }
        byte[] byArray = this.getByteOrderMark(inputStream);
        if (byArray != null) {
            iContentDescription.setProperty(IContentDescription.BYTE_ORDER_MARK, byArray);
        }
        return 1;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    byte[] getByteOrderMark(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 239) {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            if (n2 == 187 && n3 == 191) {
                return IContentDescription.BOM_UTF_8;
            }
        } else if (n == 254) {
            if (inputStream.read() == 255) {
                return IContentDescription.BOM_UTF_16BE;
            }
        } else if (n == 255 && inputStream.read() == 254) {
            return IContentDescription.BOM_UTF_16LE;
        }
        return null;
    }
}

