/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IConfiguredSiteChangedListener;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.UpdateUtils;

public class PatchCleaner {
    private IConfiguredSite csite;
    private SiteListener listener;

    public PatchCleaner(IConfiguredSite iConfiguredSite, IFeature iFeature) {
        this.csite = iConfiguredSite;
        this.listener = new SiteListener();
        iConfiguredSite.addConfiguredSiteChangedListener(this.listener);
    }

    public void dispose() {
        this.csite.removeConfiguredSiteChangedListener(this.listener);
    }

    private void cleanSavedConfigs(IFeature iFeature) {
        IInstallConfiguration iInstallConfiguration;
        if (iFeature.isPatch() && (iInstallConfiguration = UpdateUtils.getBackupConfigurationFor(iFeature)) != null) {
            this.remove(iInstallConfiguration);
        }
    }

    private void remove(IInstallConfiguration iInstallConfiguration) {
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            iLocalSite.removeFromPreservedConfigurations(iInstallConfiguration);
        }
        catch (CoreException coreException) {}
    }

    class SiteListener
    implements IConfiguredSiteChangedListener {
        SiteListener() {
        }

        public void featureInstalled(IFeature iFeature) {
        }

        public void featureRemoved(IFeature iFeature) {
            PatchCleaner.this.cleanSavedConfigs(iFeature);
        }

        public void featureConfigured(IFeature iFeature) {
        }

        public void featureUnconfigured(IFeature iFeature) {
            PatchCleaner.this.cleanSavedConfigs(iFeature);
        }
    }
}

