/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.application.CompatibilityWorkbenchWindowAdvisor;

public abstract class WorkbenchAdvisor {
    private IWorkbenchConfigurer workbenchConfigurer;
    private boolean introOpened;

    protected WorkbenchAdvisor() {
    }

    public final void internalBasicInitialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
        if (this.workbenchConfigurer != null) {
            throw new IllegalStateException();
        }
        this.workbenchConfigurer = iWorkbenchConfigurer;
        this.initialize(iWorkbenchConfigurer);
    }

    public void initialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
    }

    protected IWorkbenchConfigurer getWorkbenchConfigurer() {
        return this.workbenchConfigurer;
    }

    public void preStartup() {
    }

    public void postStartup() {
    }

    public boolean preShutdown() {
        return true;
    }

    public void postShutdown() {
    }

    public void eventLoopException(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        try {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.toString();
            }
            WorkbenchPlugin.log("Unhandled event loop exception", (IStatus)new Status(4, "org.eclipse.ui", 0, string, throwable));
            if (WorkbenchPlugin.DEBUG) {
                throwable.printStackTrace();
            }
        }
        catch (Throwable throwable2) {
            System.err.println("Error while logging event loop exception:");
            throwable.printStackTrace();
            System.err.println("Logging exception:");
            throwable2.printStackTrace();
        }
    }

    public void eventLoopIdle(Display display) {
        display.sleep();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return new CompatibilityWorkbenchWindowAdvisor(this, iWorkbenchWindowConfigurer);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) throws WorkbenchException {
    }

    public void openIntro(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public void postWindowCreate(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return true;
    }

    public void postWindowClose(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer, String string) {
        return false;
    }

    public IAdaptable getDefaultPageInput() {
        return null;
    }

    public abstract String getInitialWindowPerspectiveId();

    public String getMainPreferencePageId() {
        return null;
    }

    public void createWindowContents(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer, Shell shell) {
        ((WorkbenchWindowConfigurer)iWorkbenchWindowConfigurer).createDefaultContents(shell);
    }

    public boolean openWindows() {
        IStatus iStatus = this.getWorkbenchConfigurer().restoreState();
        if (!iStatus.isOK()) {
            if (iStatus.getCode() == 2) {
                return false;
            }
            if (iStatus.getCode() == 1) {
                this.getWorkbenchConfigurer().openFirstTimeWindow();
            }
        }
        return true;
    }

    public Control createEmptyWindowContents(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer, Composite composite) {
        return null;
    }
}

