/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.OptionalFeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;

public class InstallOperation
extends OptionalFeatureOperation
implements IInstallFeatureOperation {
    private IVerificationListener verifier;

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof InstallOperation)) {
            return false;
        }
        InstallOperation io = (InstallOperation)arg;
        return io.getFeature().getVersionedIdentifier().equals(this.getFeature().getVersionedIdentifier());
    }

    public int hashCode() {
        return super.getFeature().hashCode();
    }

    public InstallOperation(IConfiguredSite site, IFeature feature, IFeatureReference[] optionalFeatures, IFeature[] unconfiguredOptionalElements, IVerificationListener verifier) {
        super(site, feature);
        IFeature[] installed = UpdateUtils.getInstalledFeatures(feature);
        if (installed.length > 0) {
            this.oldFeature = installed[0];
        }
        this.unconfiguredOptionalFeatures = unconfiguredOptionalElements;
        this.optionalFeatures = optionalFeatures;
        this.verifier = verifier;
    }

    public IFeatureReference[] getOptionalFeatures() {
        return this.optionalFeatures;
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        boolean reinstall = false;
        if (this.oldFeature != null && this.feature.getVersionedIdentifier().equals(this.oldFeature.getVersionedIdentifier())) {
            reinstall = true;
        }
        this.setOptionalFeatures();
        if (this.optionalFeatures == null) {
            this.targetSite.install(this.feature, this.verifier, pm);
        } else {
            this.targetSite.install(this.feature, this.optionalFeatures, this.verifier, pm);
        }
        if (!reinstall && !this.isManagedOnly() && this.oldFeature != null) {
            IInstallConfiguration config;
            this.preserveOptionalState();
            boolean oldSuccess = InstallOperation.unconfigure(this.oldFeature, null);
            if (!oldSuccess && !UpdateUtils.isNestedChild(config = SiteManager.getLocalSite().getCurrentConfiguration(), this.oldFeature)) {
                String message = NLS.bind((String)Messages.OperationsManager_error_old, (Object[])new String[]{this.oldFeature.getLabel()});
                Status status = new Status(4, UpdateUtils.getPluginId(), 0, message, null);
                throw new CoreException((IStatus)status);
            }
        }
        return true;
    }
}

