/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.internal.scheduler.ScheduledPluginUninstall;
import org.eclipse.update.internal.scheduler.ScheduledSiteInitialize;

public class RootScreen
extends AbsScreen {
    private Button installButton;
    private Button updateButton;
    private Button manageButton;
    private Button widestButton;
    static /* synthetic */ Class class$0;

    public RootScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.init(UIMessages.SelectOption);
        ((GridLayout)this.screen.getLayout()).verticalSpacing = "unknown".equals(Platform.getOS()) ? 10 : 20;
        this.installButton = new Button(this.screen, 8);
        this.installButton.setText(UIMessages.InstallFeatures);
        this.installButton.addSelectionListener((SelectionListener)this);
        this.updateButton = new Button(this.screen, 8);
        this.updateButton.setText(UIMessages.UpdateAllFeatures);
        this.updateButton.addSelectionListener((SelectionListener)this);
        this.manageButton = new Button(this.screen, 8);
        this.manageButton.setText(UIMessages.ManageFeatures);
        this.manageButton.addSelectionListener((SelectionListener)this);
        this.screen.layout();
        this.environmentInitialize();
        this.widestButton = this.installButton.getBounds().width > this.updateButton.getBounds().width ? this.installButton : this.updateButton;
        if (this.widestButton.getBounds().width < this.manageButton.getBounds().width) {
            this.widestButton = this.manageButton;
        }
    }

    protected void environmentInitialize() {
        block14: {
            ScheduledPluginUninstall.uninstallFeatures();
            this.view.targetSite = ScheduledSiteInitialize.createTargetSite();
            if (ScheduledSiteInitialize.isRestartNeeded()) {
                MessageBox mb1 = new MessageBox(this.screen.getShell(), 194);
                mb1.setText(UIMessages.ConfirmRestart);
                mb1.setMessage(NLS.bind((String)UIMessages.RecommendToRestartForMigration, (Object[])this.view.RuntimeName));
                if (mb1.open() == 64) {
                    System.getProperties().put("eworkbench.returnCode", new Integer(1));
                    PlatformUI.getWorkbench().close();
                }
            }
            if (System.getProperty("sun.net.client.defaultConnectTimeout") == null) {
                System.setProperty("sun.net.client.defaultConnectTimeout", "6000");
            }
            try {
                Method mIsWindowMobile;
                Boolean bIsWindowMobile;
                Method mIsSmartPhone;
                Boolean bIsSmartPhone;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.swt.internal.Platform");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((bIsSmartPhone = (Boolean)(mIsSmartPhone = clazz.getDeclaredMethod("isSmartPhone", null)).invoke(null, null)).booleanValue()) {
                    this.view.isSmartPhone = true;
                    this.view.isSoftKeySupported = true;
                    break block14;
                }
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.swt.internal.Platform");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((bIsWindowMobile = (Boolean)(mIsWindowMobile = clazz2.getDeclaredMethod("isWindowMobile", null)).invoke(null, null)).booleanValue() && org.eclipse.swt.internal.Platform.MAJOR_VERSION >= 5) {
                    this.view.isSoftKeySupported = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void refresh() {
        Font newFont = null;
        FontData newFontData = null;
        int availableWidth = this.screen.getShell().getClientArea().width - this.widestButton.getBounds().x - 5;
        if (this.widestButton.getBounds().width > availableWidth && this.widestButton.getFont().getFontData().length > 0) {
            newFontData = this.widestButton.getFont().getFontData()[0];
            newFont = new Font((Device)Display.getCurrent(), newFontData);
            this.installButton.setFont(newFont);
            this.updateButton.setFont(newFont);
            this.manageButton.setFont(newFont);
            newFont = null;
            while (this.widestButton.computeSize((int)-1, (int)-1).x > availableWidth) {
                if (newFontData.getHeight() < 6) break;
                newFontData.setHeight(newFontData.getHeight() - 1);
                newFont = new Font((Device)Display.getCurrent(), newFontData);
                this.widestButton.setFont(newFont);
            }
            if (newFont != null) {
                this.installButton.setFont(newFont);
                this.updateButton.setFont(newFont);
                this.manageButton.setFont(newFont);
                this.screen.layout();
            }
        }
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.screen.setFocus();
        this.installButton.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.installButton) {
            this.view.refreshInstalledFeatures();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (e.widget == this.updateButton) {
            this.view.refreshInstalledFeatures();
            this.view.availableFeatures.removeAllElements();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(9, true);
        } else if (e.widget == this.manageButton) {
            this.view.refreshInstalledFeatures();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(10, true);
        }
    }
}

