/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.ApplicationRegistryReader;
import org.eclipse.ercp.eworkbench.IApplicationDescriptor;
import org.eclipse.ercp.eworkbench.IApplicationRegistry;
import org.eclipse.ui.PlatformUI;

public class ApplicationRegistry
implements IApplicationRegistry,
IExtensionChangeHandler {
    private List applications = new ArrayList(10);

    public ApplicationRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, null);
    }

    public void addApplication(ApplicationDescriptor desc) {
        if (desc == null) {
            return;
        }
        this.add(desc);
    }

    private void add(ApplicationDescriptor desc) {
        this.applications.add(desc);
        IConfigurationElement element = desc.getConfigElement();
        if (element != null) {
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(element.getDeclaringExtension(), (Object)desc, 2);
        }
    }

    public ApplicationDescriptor createApplication(String label) {
        if (!this.validateLabel(label)) {
            return null;
        }
        if (this.findApplicationWithLabel(label) != null) {
            return null;
        }
        String id = label.replace(' ', '_');
        id = id.trim();
        ApplicationDescriptor desc = new ApplicationDescriptor(id, label);
        this.add(desc);
        return desc;
    }

    public void deleteApplication(IApplicationDescriptor in) {
        ApplicationDescriptor desc = (ApplicationDescriptor)in;
        this.applications.remove(desc);
    }

    public IApplicationDescriptor findApplicationWithId(String id) {
        Iterator i = this.applications.iterator();
        while (i.hasNext()) {
            ApplicationDescriptor desc = (ApplicationDescriptor)i.next();
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public IApplicationDescriptor findApplicationWithLabel(String label) {
        Iterator i = this.applications.iterator();
        while (i.hasNext()) {
            ApplicationDescriptor desc = (ApplicationDescriptor)i.next();
            if (!desc.getLabel().equals(label)) continue;
            return desc;
        }
        return null;
    }

    public IApplicationDescriptor[] getApplications() {
        return this.applications.toArray(new IApplicationDescriptor[this.applications.size()]);
    }

    public void load() {
        ApplicationRegistryReader reader = new ApplicationRegistryReader(this);
        reader.readApplications(Platform.getExtensionRegistry());
    }

    public boolean validateLabel(String label) {
        return (label = label.trim()).length() > 0;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public void removeExtension(IExtension source, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ApplicationDescriptor) {
                this.deleteApplication((ApplicationDescriptor)objects[i]);
            }
            ++i;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension addedExtension) {
        IConfigurationElement[] addedElements = addedExtension.getConfigurationElements();
        int i = 0;
        while (i < addedElements.length) {
            ApplicationRegistryReader reader = new ApplicationRegistryReader(this);
            reader.readElement(addedElements[i]);
            ++i;
        }
    }
}

