/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.ApplicationRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class ApplicationRegistryReader
extends RegistryReader {
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_VIEWS = "views";
    public static final String ATT_LARGE = "large";
    public static final String ATT_NORMAL = "normal";
    public static final String ATT_STATUS = "status";
    private ApplicationRegistry registry;

    public ApplicationRegistryReader(ApplicationRegistry out) {
        this.registry = out;
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_APPLICATION)) {
            try {
                ApplicationDescriptor desc = new ApplicationDescriptor(element.getAttribute("id"), element);
                IConfigurationElement[] children = element.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().equals(TAG_VIEWS)) {
                        String view_id = children[i].getAttribute(ATT_NORMAL);
                        if (view_id != null) {
                            desc.setViewId(ATT_NORMAL, view_id);
                        } else {
                            WorkbenchPlugin.log((String)"Unable to find normal view in application descriptor.");
                        }
                        view_id = children[i].getAttribute(ATT_LARGE);
                        if (view_id != null) {
                            desc.setViewId(ATT_LARGE, view_id);
                        }
                        if ((view_id = children[i].getAttribute(ATT_STATUS)) != null) {
                            desc.setViewId(ATT_STATUS, view_id);
                        }
                    }
                    ++i;
                }
                this.registry.addApplication(desc);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log((String)"Unable to create application descriptor.", (IStatus)e.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readApplications(IExtensionRegistry in) {
        this.readRegistry(in, "org.eclipse.ercp.eworkbench", "applications");
    }
}

