/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.jaxp.implForCore;

import java.io.IOException;
import org.eclipse.ercp.xml.parser.AbstractSAXParserImpl;
import org.eclipse.ercp.xml.parser.AttributesImpl;
import org.eclipse.ercp.xml.parser.NSDeclaration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParserImpl
extends AbstractSAXParserImpl
implements XMLReader {
    private ContentHandler contentHandler = NullContentHandler;
    private ErrorHandler errorHandler = null;
    private LexicalHandler lexicalHandler;
    private static final ContentHandler NullContentHandler = new ContentHandler(){

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    };

    protected void fatalError(String errorMsg, String parameter) throws SAXException {
        SAXParseException e = new SAXParseException(SAXParserImpl.errorMsg(errorMsg, parameter), this);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(e);
        }
        throw e;
    }

    protected void warning(String errorMsg, String parameter) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException(SAXParserImpl.errorMsg(errorMsg, parameter), this));
        }
    }

    protected boolean canDoStringInterning() {
        return false;
    }

    protected void endPrefixMapping(NSDeclaration nsDecl) throws SAXException {
        String[][] declarations = nsDecl.getDeclarations();
        if (declarations == null) {
            return;
        }
        int len = declarations.length;
        int i = 0;
        while (i < len) {
            this.contentHandler.endPrefixMapping(declarations[i][0]);
            ++i;
        }
    }

    protected void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.currentNSDecl.addDeclaration(prefix, uri);
        this.contentHandler.startPrefixMapping(this.fStringInterning ? prefix.intern() : prefix, uri);
    }

    protected void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    protected void startElement(String qName, String namespace, String localName, AttributesImpl attributes) throws SAXException {
        this.contentHandler.startElement(this.currentNSDecl.getUriFor(namespace), this.fStringInterning ? localName.intern() : localName, this.fStringInterning ? qName.intern() : qName, attributes);
    }

    protected void endElement(String qName, String namespace, String localName) throws SAXException {
        this.contentHandler.endElement(this.currentNSDecl.getUriFor(namespace), this.fStringInterning ? localName.intern() : localName, this.fStringInterning ? qName.intern() : qName);
    }

    protected void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    protected void startDocument() throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
    }

    protected void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void parse(InputSource is, DefaultHandler dh) throws SAXException, IOException {
        this.setFeature("http://xml.org/sax/features/namespaces", this.isNamespaceAware());
        this.setContentHandler(dh);
        this.setErrorHandler(dh);
        this.setDTDHandler(dh);
        this.setEntityResolver(dh);
        this.parse(is);
    }

    public XMLReader getXMLReader() throws SAXException {
        return this;
    }

    public Parser getParser() throws SAXException {
        throw new SAXNotSupportedException("org.xml.sax.Parser");
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler != null ? contentHandler : NullContentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler == NullContentHandler ? null : this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    protected void setLexicalHandler(Object value) {
        this.lexicalHandler = (LexicalHandler)value;
    }

    protected Object getRecognizedXmlOrgProperty(String name) throws SAXNotSupportedException {
        if ("lexical-handler".equals(name)) {
            return this.lexicalHandler;
        }
        return super.getRecognizedXmlOrgProperty(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRecognizedXmlOrgProperty(String name, Object value) throws SAXNotSupportedException {
        if ("lexical-handler".equals(name)) {
            if (!(value instanceof LexicalHandler)) throw new SAXNotSupportedException(name);
            this.lexicalHandler = (LexicalHandler)value;
            return;
        } else {
            super.setRecognizedXmlOrgProperty(name, value);
        }
    }

    protected Object getLexicalHandler() {
        return this.lexicalHandler;
    }

    protected void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    protected void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }
}

