/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ResolverErrorImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class StateImpl
implements State {
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_NL = "osgi.nl";
    private static final String OSGI_ARCH = "osgi.arch";
    public static final String[] PROPS = new String[]{"osgi.os", "osgi.ws", "osgi.nl", "osgi.arch", "org.osgi.framework.system.packages", "osgi.resolverMode", "org.osgi.framework.executionenvironment", "osgi.resolveOptional", "osgi.genericAliases", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.language", "osgi.system.bundle"};
    private static final DisabledInfo[] EMPTY_DISABLEDINFOS = new DisabledInfo[0];
    private transient Resolver resolver;
    private transient StateDeltaImpl changes;
    private transient boolean resolving = false;
    private transient HashSet removalPendings = new HashSet();
    private boolean resolved = true;
    private long timeStamp = System.currentTimeMillis();
    private KeyedHashSet bundleDescriptions = new KeyedHashSet(false);
    private HashMap resolverErrors = new HashMap();
    private StateObjectFactory factory;
    private KeyedHashSet resolvedBundles = new KeyedHashSet();
    private HashMap disabledBundles = new HashMap();
    boolean fullyLoaded = false;
    private boolean dynamicCacheChanged = false;
    private StateReader reader;
    private Dictionary[] platformProperties = new Dictionary[]{new Hashtable(PROPS.length)};
    private long highestBundleId = -1L;
    private HashSet platformPropertyKeys = new HashSet(PROPS.length);
    private static long cumulativeTime;

    protected StateImpl() {
        this.addPlatformPropertyKeys(PROPS);
    }

    public boolean addBundle(BundleDescription description) {
        NativeCodeSpecification nativeCode;
        if (!this.basicAddBundle(description)) {
            return false;
        }
        String platformFilter = description.getPlatformFilter();
        if (platformFilter != null) {
            try {
                FilterImpl filter = (FilterImpl)FrameworkUtil.createFilter(platformFilter);
                this.addPlatformPropertyKeys(filter.getAttributes());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        if ((nativeCode = description.getNativeCodeSpecification()) != null) {
            NativeCodeDescription[] suppliers = nativeCode.getPossibleSuppliers();
            int i = 0;
            while (i < suppliers.length) {
                FilterImpl filter = (FilterImpl)suppliers[i].getFilter();
                if (filter != null) {
                    this.addPlatformPropertyKeys(filter.getAttributes());
                }
                ++i;
            }
        }
        this.resolved = false;
        this.getDelta().recordBundleAdded((BundleDescriptionImpl)description);
        if (this.getSystemBundle().equals(description.getSymbolicName())) {
            this.resetSystemExports();
        }
        if (this.resolver != null) {
            this.resolver.bundleAdded(description);
        }
        this.updateTimeStamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateBundle(BundleDescription newDescription) {
        BundleDescriptionImpl existing = (BundleDescriptionImpl)this.bundleDescriptions.get((BundleDescriptionImpl)newDescription);
        if (existing == null) {
            return false;
        }
        if (!this.bundleDescriptions.remove(existing)) {
            return false;
        }
        this.resolvedBundles.remove(existing);
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList infos = (ArrayList)this.disabledBundles.remove(existing);
            if (infos != null) {
                ArrayList<DisabledInfo> newInfos = new ArrayList<DisabledInfo>(infos.size());
                Iterator iInfos = infos.iterator();
                while (true) {
                    if (!iInfos.hasNext()) {
                        this.disabledBundles.put(newDescription, newInfos);
                        break;
                    }
                    DisabledInfo info = (DisabledInfo)iInfos.next();
                    newInfos.add(new DisabledInfo(info.getPolicyName(), info.getMessage(), newDescription));
                }
            }
        }
        existing.setStateBit(4, true);
        if (!this.basicAddBundle(newDescription)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleUpdated((BundleDescriptionImpl)newDescription);
        if (this.getSystemBundle().equals(newDescription.getSymbolicName())) {
            this.resetSystemExports();
        }
        if (this.resolver != null) {
            boolean pending = existing.getDependents().length > 0;
            this.resolver.bundleUpdated(newDescription, existing, pending);
            if (pending) {
                this.getDelta().recordBundleRemovalPending(existing);
                this.removalPendings.add(existing);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    Object var5_6;
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(existing);
                        this.resolveBundle(existing, false, null, null, null, null, null);
                        var5_6 = null;
                        this.resolving = false;
                    }
                    catch (Throwable throwable) {
                        var5_6 = null;
                        this.resolving = false;
                        throw throwable;
                    }
                }
            }
        }
        this.updateTimeStamp();
        return true;
    }

    public BundleDescription removeBundle(long bundleId) {
        BundleDescription toRemove = this.getBundle(bundleId);
        if (toRemove == null || !this.removeBundle(toRemove)) {
            return null;
        }
        return toRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeBundle(BundleDescription toRemove) {
        if (!this.bundleDescriptions.remove((KeyedElement)((Object)toRemove))) {
            return false;
        }
        this.resolvedBundles.remove((KeyedElement)((Object)toRemove));
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            this.disabledBundles.remove(toRemove);
        }
        this.resolved = false;
        this.getDelta().recordBundleRemoved((BundleDescriptionImpl)toRemove);
        ((BundleDescriptionImpl)toRemove).setStateBit(4, true);
        if (this.resolver != null) {
            boolean pending = toRemove.getDependents().length > 0;
            this.resolver.bundleRemoved(toRemove, pending);
            if (pending) {
                this.getDelta().recordBundleRemovalPending((BundleDescriptionImpl)toRemove);
                this.removalPendings.add(toRemove);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(toRemove);
                        this.resolveBundle(toRemove, false, null, null, null, null, null);
                        Object var4_7 = null;
                        this.resolving = false;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        this.resolving = false;
                        throw throwable;
                    }
                }
            }
        }
        this.updateTimeStamp();
        return true;
    }

    public StateDelta getChanges() {
        return this.getDelta();
    }

    private StateDeltaImpl getDelta() {
        if (this.changes == null) {
            this.changes = new StateDeltaImpl(this);
        }
        return this.changes;
    }

    public BundleDescription[] getBundles(String symbolicName) {
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = this.getSystemBundle();
        }
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            if (!symbolicName.equals(bundle.getSymbolicName())) continue;
            bundles.add(bundle);
        }
        return bundles.toArray(new BundleDescription[bundles.size()]);
    }

    public BundleDescription[] getBundles() {
        return (BundleDescription[])this.bundleDescriptions.elements(new BundleDescription[this.bundleDescriptions.size()]);
    }

    public BundleDescription getBundle(long id) {
        BundleDescription result = (BundleDescription)((Object)this.bundleDescriptions.getByKey(new Long(id)));
        if (result != null) {
            return result;
        }
        Iterator iter = this.removalPendings.iterator();
        while (iter.hasNext()) {
            BundleDescription removedBundle = (BundleDescription)iter.next();
            if (removedBundle.getBundleId() != id) continue;
            return removedBundle;
        }
        return null;
    }

    public BundleDescription getBundle(String name, Version version) {
        BundleDescription[] allBundles = this.getBundles(name);
        if (allBundles.length == 1) {
            return version == null || allBundles[0].getVersion().equals(version) ? allBundles[0] : null;
        }
        if (allBundles.length == 0) {
            return null;
        }
        BaseDescription unresolvedFound = null;
        BaseDescription resolvedFound = null;
        int i = 0;
        while (i < allBundles.length) {
            BundleDescription current = allBundles[i];
            BaseDescription base = current.isResolved() ? resolvedFound : unresolvedFound;
            if (version == null || current.getVersion().equals(version)) {
                if (base != null && (base.getVersion().compareTo(current.getVersion()) <= 0 || base.getBundleId() > current.getBundleId())) {
                    if (base == resolvedFound) {
                        resolvedFound = current;
                    } else {
                        unresolvedFound = current;
                    }
                } else if (current.isResolved()) {
                    resolvedFound = current;
                } else {
                    unresolvedFound = current;
                }
            }
            ++i;
        }
        if (resolvedFound != null) {
            return resolvedFound;
        }
        return unresolvedFound;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isResolved() {
        return this.resolved || this.isEmpty();
    }

    public void resolveConstraint(VersionConstraint constraint, BaseDescription supplier) {
        ((VersionConstraintImpl)constraint).setSupplier(supplier);
    }

    public void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        this.resolveBundle(bundle, status, hosts, selectedExports, null, resolvedRequires, resolvedImports);
    }

    public synchronized void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, ExportPackageDescription[] substitutedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        BundleDescriptionImpl modifiable = (BundleDescriptionImpl)bundle;
        this.getDelta().recordBundleResolved(modifiable, status);
        modifiable.setLazyLoaded(false);
        modifiable.setStateBit(1, status);
        if (status) {
            this.resolverErrors.remove(modifiable);
            this.resolvedBundles.add(modifiable);
        } else {
            this.resolvedBundles.remove(modifiable);
            modifiable.removeDependencies();
        }
        if (selectedExports == null || resolvedRequires == null || resolvedImports == null) {
            this.unresolveConstraints(modifiable);
        } else {
            this.resolveConstraints(modifiable, hosts, selectedExports, substitutedExports, resolvedRequires, resolvedImports);
        }
    }

    public synchronized void removeBundleComplete(BundleDescription bundle) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.getDelta().recordBundleRemovalComplete((BundleDescriptionImpl)bundle);
        this.removalPendings.remove(bundle);
    }

    private void resolveConstraints(BundleDescriptionImpl bundle, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, ExportPackageDescription[] substitutedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        HostSpecificationImpl hostSpec = (HostSpecificationImpl)bundle.getHost();
        if (hostSpec != null && hosts != null) {
            hostSpec.setHosts(hosts);
            int i = 0;
            while (i < hosts.length) {
                ((BundleDescriptionImpl)hosts[i]).addDependency(bundle, true);
                this.checkHostForSubstitutedExports((BundleDescriptionImpl)hosts[i], bundle);
                ++i;
            }
        }
        bundle.setSelectedExports(selectedExports);
        bundle.setResolvedRequires(resolvedRequires);
        bundle.setResolvedImports(resolvedImports);
        bundle.setSubstitutedExports(substitutedExports);
        bundle.addDependencies(hosts, true);
        bundle.addDependencies(resolvedRequires, true);
        bundle.addDependencies(resolvedImports, true);
        GenericSpecification[] genericRequires = bundle.getGenericRequires();
        if (genericRequires.length > 0) {
            ArrayList<GenericDescription> genericSuppliers = new ArrayList<GenericDescription>(genericRequires.length);
            int i = 0;
            while (i < genericRequires.length) {
                GenericDescription[] suppliers = genericRequires[i].getSuppliers();
                if (suppliers != null) {
                    int j = 0;
                    while (j < suppliers.length) {
                        genericSuppliers.add(suppliers[j]);
                        ++j;
                    }
                }
                ++i;
            }
            bundle.addDependencies(genericSuppliers.toArray(new BaseDescription[genericSuppliers.size()]), true);
        }
    }

    private void checkHostForSubstitutedExports(BundleDescriptionImpl host, BundleDescriptionImpl fragment) {
    }

    private void unresolveConstraints(BundleDescriptionImpl bundle) {
        HostSpecificationImpl host = (HostSpecificationImpl)bundle.getHost();
        if (host != null) {
            host.setHosts(null);
        }
        bundle.setSelectedExports(null);
        bundle.setResolvedImports(null);
        bundle.setResolvedRequires(null);
        bundle.setSubstitutedExports(null);
        GenericSpecification[] genericRequires = bundle.getGenericRequires();
        if (genericRequires.length > 0) {
            int i = 0;
            while (i < genericRequires.length) {
                ((GenericSpecificationImpl)genericRequires[i]).setSupplers(null);
                ++i;
            }
        }
        bundle.removeDependencies();
    }

    private synchronized StateDelta resolve(boolean incremental, BundleDescription[] reResolve) {
        BundleDescription[] removed;
        long start;
        block12: {
            this.resolving = true;
            if (this.resolver == null) {
                throw new IllegalStateException("no resolver set");
            }
            this.fullyLoad();
            start = 0L;
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                start = System.currentTimeMillis();
            }
            if (!incremental) {
                this.resolved = false;
                reResolve = this.getBundles();
                if (this.removalPendings.size() > 0) {
                    removed = this.getRemovalPendings();
                    reResolve = this.mergeBundles(reResolve, removed);
                }
                this.flush(reResolve);
            }
            if (!this.resolved || reResolve != null) break block12;
            StateDeltaImpl stateDeltaImpl = new StateDeltaImpl(this);
            Object var9_7 = null;
            this.resolving = false;
            return stateDeltaImpl;
        }
        try {
            if (this.removalPendings.size() > 0) {
                removed = this.getRemovalPendings();
                reResolve = this.mergeBundles(reResolve, removed);
            }
            Dictionary[] tmpPlatformProperties = new Headers[this.platformProperties.length];
            int i = 0;
            while (i < this.platformProperties.length) {
                tmpPlatformProperties[i] = new Headers(this.platformProperties[i].size());
                Enumeration keys = this.platformProperties[i].keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    ((Headers)tmpPlatformProperties[i]).put(key, this.platformProperties[i].get(key));
                }
                ++i;
            }
            this.resolver.resolve(reResolve, tmpPlatformProperties);
            this.resolved = this.removalPendings.size() == 0;
            StateDeltaImpl savedChanges = this.changes == null ? new StateDeltaImpl(this) : this.changes;
            this.changes = new StateDeltaImpl(this);
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                long time = System.currentTimeMillis() - start;
                Debug.println("Time spent resolving: " + time);
                FrameworkDebugOptions.getDefault().setOption("org.eclipse.core.runtime.adaptor/resolver/timing/value", Long.toString(cumulativeTime += time));
            }
            if (savedChanges.getChanges().length > 0) {
                this.updateTimeStamp();
            }
            StateDeltaImpl stateDeltaImpl = savedChanges;
            Object var9_8 = null;
            this.resolving = false;
            return stateDeltaImpl;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.resolving = false;
            throw throwable;
        }
    }

    private BundleDescription[] mergeBundles(BundleDescription[] reResolve, BundleDescription[] removed) {
        if (reResolve == null) {
            return removed;
        }
        if (reResolve.length == 0) {
            return reResolve;
        }
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>(reResolve.length + removed.length);
        int i = 0;
        while (i < reResolve.length) {
            result.add(reResolve[i]);
            ++i;
        }
        i = 0;
        while (i < removed.length) {
            boolean found = false;
            int j = 0;
            while (j < reResolve.length) {
                if (removed[i] == reResolve[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                result.add(removed[i]);
            }
            ++i;
        }
        return result.toArray(new BundleDescription[result.size()]);
    }

    private void flush(BundleDescription[] bundles) {
        this.resolver.flush();
        this.resolved = false;
        this.resolverErrors.clear();
        if (this.resolvedBundles.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < bundles.length) {
            this.resolveBundle(bundles[i], false, null, null, null, null, null);
            ++i;
        }
        this.resolvedBundles.clear();
    }

    public StateDelta resolve() {
        return this.resolve(true, null);
    }

    public StateDelta resolve(boolean incremental) {
        return this.resolve(incremental, null);
    }

    public StateDelta resolve(BundleDescription[] reResolve) {
        return this.resolve(true, reResolve);
    }

    public void setOverrides(Object value) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getResolvedBundles() {
        return (BundleDescription[])this.resolvedBundles.elements(new BundleDescription[this.resolvedBundles.size()]);
    }

    public boolean isEmpty() {
        return this.bundleDescriptions.isEmpty();
    }

    void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    boolean basicAddBundle(BundleDescription description) {
        StateImpl origState = (StateImpl)description.getContainingState();
        if (origState != null && origState != this) {
            if (origState.removalPendings.contains(description)) {
                throw new IllegalStateException(NLS.bind(StateMsg.BUNDLE_PENDING_REMOVE_STATE, description.toString()));
            }
            if (origState.getBundle(description.getBundleId()) == description) {
                throw new IllegalStateException(NLS.bind(StateMsg.BUNDLE_IN_OTHER_STATE, description.toString()));
            }
        }
        ((BundleDescriptionImpl)description).setContainingState(this);
        ((BundleDescriptionImpl)description).setStateBit(4, false);
        if (this.bundleDescriptions.add((BundleDescriptionImpl)description)) {
            if (description.getBundleId() > this.getHighestBundleId()) {
                this.highestBundleId = description.getBundleId();
            }
            return true;
        }
        return false;
    }

    void addResolvedBundle(BundleDescriptionImpl resolvedBundle) {
        this.resolvedBundles.add(resolvedBundle);
    }

    public ExportPackageDescription[] getExportedPackages() {
        int i;
        ExportPackageDescription[] bundlePackages;
        BundleDescription bundle;
        this.fullyLoad();
        ArrayList<ExportPackageDescription> allExportedPackages = new ArrayList<ExportPackageDescription>();
        Iterator iter = this.resolvedBundles.iterator();
        while (iter.hasNext()) {
            bundle = (BundleDescription)iter.next();
            bundlePackages = bundle.getSelectedExports();
            if (bundlePackages == null) continue;
            i = 0;
            while (i < bundlePackages.length) {
                allExportedPackages.add(bundlePackages[i]);
                ++i;
            }
        }
        iter = this.removalPendings.iterator();
        while (iter.hasNext()) {
            bundle = (BundleDescription)iter.next();
            bundlePackages = bundle.getSelectedExports();
            if (bundlePackages == null) continue;
            i = 0;
            while (i < bundlePackages.length) {
                allExportedPackages.add(bundlePackages[i]);
                ++i;
            }
        }
        return allExportedPackages.toArray(new ExportPackageDescription[allExportedPackages.size()]);
    }

    BundleDescription[] getFragments(BundleDescription host) {
        ArrayList<BundleDescription> fragments = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        block0: while (iter.hasNext()) {
            BundleDescription[] hosts;
            BundleDescription bundle = (BundleDescription)iter.next();
            HostSpecification hostSpec = bundle.getHost();
            if (hostSpec == null || (hosts = hostSpec.getHosts()) == null) continue;
            int i = 0;
            while (i < hosts.length) {
                if (hosts[i] == host) {
                    fragments.add(bundle);
                    continue block0;
                }
                ++i;
            }
        }
        return fragments.toArray(new BundleDescription[fragments.size()]);
    }

    public void setTimeStamp(long newTimeStamp) {
        this.timeStamp = newTimeStamp;
    }

    private void updateTimeStamp() {
        if (this.getTimeStamp() == Long.MAX_VALUE) {
            this.setTimeStamp(0L);
        }
        this.setTimeStamp(this.getTimeStamp() + 1L);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    void setFactory(StateObjectFactory factory) {
        this.factory = factory;
    }

    public BundleDescription getBundleByLocation(String location) {
        Iterator i = this.bundleDescriptions.iterator();
        while (i.hasNext()) {
            BundleDescription current = (BundleDescription)i.next();
            if (!location.equals(current.getLocation())) continue;
            return current;
        }
        return null;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver newResolver) {
        if (this.resolver == newResolver) {
            return;
        }
        if (this.resolver != null) {
            Resolver oldResolver = this.resolver;
            this.resolver = null;
            oldResolver.setState(null);
        }
        this.resolver = newResolver;
        if (this.resolver == null) {
            return;
        }
        this.resolver.setState(this);
    }

    public boolean setPlatformProperties(Dictionary platformProperties) {
        return this.setPlatformProperties(new Dictionary[]{platformProperties});
    }

    public boolean setPlatformProperties(Dictionary[] platformProperties) {
        return this.setPlatformProperties(platformProperties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean setPlatformProperties(Dictionary[] platformProperties, boolean resetSystemExports) {
        Object keys;
        if (platformProperties.length == 0) {
            throw new IllegalArgumentException();
        }
        Dictionary[] newPlatformProperties = new Dictionary[platformProperties.length];
        int i = 0;
        while (i < platformProperties.length) {
            newPlatformProperties[i] = new Hashtable(platformProperties[i].size());
            Dictionary dictionary = platformProperties[i];
            synchronized (dictionary) {
                keys = platformProperties[i].keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object value = platformProperties[i].get(key);
                    newPlatformProperties[i].put(key, value);
                }
            }
            if (newPlatformProperties[i].get("org.osgi.framework.os.name") == null && newPlatformProperties[i].get(OSGI_OS) != null) {
                newPlatformProperties[i].put("org.osgi.framework.os.name", newPlatformProperties[i].get(OSGI_OS));
            }
            if (newPlatformProperties[i].get("org.osgi.framework.processor") == null && newPlatformProperties[i].get(OSGI_ARCH) != null) {
                newPlatformProperties[i].put("org.osgi.framework.processor", newPlatformProperties[i].get(OSGI_ARCH));
            }
            if (newPlatformProperties[i].get("org.osgi.framework.language") == null && newPlatformProperties[i].get(OSGI_NL) instanceof String) {
                String osgiNL = (String)newPlatformProperties[i].get(OSGI_NL);
                int idx = osgiNL.indexOf(95);
                if (idx >= 0) {
                    osgiNL = osgiNL.substring(0, idx);
                }
                newPlatformProperties[i].put("org.osgi.framework.language", osgiNL);
            }
            ++i;
        }
        boolean result = false;
        boolean performResetSystemExports = false;
        if (this.platformProperties.length != newPlatformProperties.length) {
            result = true;
            performResetSystemExports = true;
        } else {
            keys = this.getPlatformPropertyKeys();
            int i2 = 0;
            while (i2 < newPlatformProperties.length && !result) {
                result |= this.changedProps(this.platformProperties[i2], newPlatformProperties[i2], (String[])keys);
                if (resetSystemExports) {
                    performResetSystemExports |= this.checkProp(this.platformProperties[i2].get("org.osgi.framework.system.packages"), newPlatformProperties[i2].get("org.osgi.framework.system.packages"));
                    performResetSystemExports |= this.checkProp(this.platformProperties[i2].get("system.bundle"), newPlatformProperties[i2].get("system.bundle"));
                }
                ++i2;
            }
        }
        this.platformProperties = newPlatformProperties;
        if (performResetSystemExports) {
            this.resetSystemExports();
        }
        return result;
    }

    private void resetSystemExports() {
        BundleDescription[] systemBundles = this.getBundles("system.bundle");
        if (systemBundles.length > 0) {
            BundleDescriptionImpl systemBundle = (BundleDescriptionImpl)systemBundles[0];
            ExportPackageDescription[] exports = systemBundle.getExportPackages();
            ArrayList<ExportPackageDescription> newExports = new ArrayList<ExportPackageDescription>(exports.length);
            int i = 0;
            while (i < exports.length) {
                if ((Integer)exports[i].getDirective("x-equinox-ee") < 0) {
                    newExports.add(exports[i]);
                }
                ++i;
            }
            this.addSystemExports(newExports);
            systemBundle.setExportPackages(newExports.toArray(new ExportPackageDescription[newExports.size()]));
        }
    }

    private void addSystemExports(ArrayList exports) {
        int i = 0;
        while (i < this.platformProperties.length) {
            try {
                ManifestElement[] elements = ManifestElement.parseHeader("Export-Package", (String)this.platformProperties[i].get("org.osgi.framework.system.packages"));
                if (elements != null) {
                    ExportPackageDescription[] systemExports = StateBuilder.createExportPackages(elements, null, null, 2, false);
                    Integer profInx = new Integer(i);
                    int j = 0;
                    while (j < systemExports.length) {
                        ((ExportPackageDescriptionImpl)systemExports[j]).setDirective("x-equinox-ee", profInx);
                        exports.add(systemExports[j]);
                        ++j;
                    }
                }
            }
            catch (BundleException bundleException) {}
            ++i;
        }
    }

    public Dictionary[] getPlatformProperties() {
        return this.platformProperties;
    }

    private boolean checkProp(Object origObj, Object newObj) {
        if (origObj == null && newObj != null || origObj != null && newObj == null) {
            return true;
        }
        if (origObj == null) {
            return false;
        }
        if (origObj.getClass() != newObj.getClass()) {
            return true;
        }
        if (origObj instanceof String[]) {
            String[] origProps = (String[])origObj;
            String[] newProps = (String[])newObj;
            if (origProps.length != newProps.length) {
                return true;
            }
            int i = 0;
            while (i < origProps.length) {
                if (!origProps[i].equals(newProps[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return !origObj.equals(newObj);
    }

    private boolean changedProps(Dictionary origProps, Dictionary newProps, String[] keys) {
        int i = 0;
        while (i < keys.length) {
            Object newProp;
            Object origProp = origProps.get(keys[i]);
            if (this.checkProp(origProp, newProp = newProps.get(keys[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getSystemBundle() {
        String symbolicName = null;
        if (this.platformProperties != null && this.platformProperties.length > 0) {
            symbolicName = (String)this.platformProperties[0].get("osgi.system.bundle");
        }
        return symbolicName != null ? symbolicName : Constants.getInternalSymbolicName();
    }

    public BundleDescription[] getRemovalPendings() {
        return this.removalPendings.toArray(new BundleDescription[this.removalPendings.size()]);
    }

    public synchronized ExportPackageDescription linkDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        if (this.resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        BundleDescriptionImpl importer = (BundleDescriptionImpl)importingBundle;
        if (importer.getDynamicStamp(requestedPackage) == this.getTimeStamp()) {
            return null;
        }
        try {
            this.resolving = true;
            this.fullyLoad();
            ExportPackageDescriptionImpl result = (ExportPackageDescriptionImpl)this.resolver.resolveDynamicImport(importingBundle, requestedPackage);
            if (result == null) {
                importer.setDynamicStamp(requestedPackage, new Long(this.getTimeStamp()));
            } else {
                importer.setDynamicStamp(requestedPackage, null);
                importer.addDynamicResolvedImport(result);
            }
            this.setDynamicCacheChanged(true);
            ExportPackageDescriptionImpl exportPackageDescriptionImpl = result;
            Object var5_6 = null;
            this.resolving = false;
            return exportPackageDescriptionImpl;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.resolving = false;
            throw throwable;
        }
    }

    void setReader(StateReader reader) {
        this.reader = reader;
    }

    StateReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyLoad() {
        if (this.reader == null) {
            return;
        }
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            if (this.fullyLoaded) {
                return;
            }
            if (this.reader.isLazyLoaded()) {
                this.reader.fullyLoad();
            }
            this.fullyLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadLazyData(long expireTime) {
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            if (this.reader.getAccessedFlag()) {
                this.reader.setAccessedFlag(false);
                return;
            }
            this.fullyLoaded = false;
            BundleDescription[] bundles = this.getBundles();
            int i = 0;
            while (i < bundles.length) {
                ((BundleDescriptionImpl)bundles[i]).unload();
                ++i;
            }
        }
    }

    public ExportPackageDescription[] getSystemPackages() {
        ArrayList<ExportPackageDescription> result = new ArrayList<ExportPackageDescription>();
        BundleDescription[] systemBundles = this.getBundles("system.bundle");
        if (systemBundles.length > 0) {
            BundleDescriptionImpl systemBundle = (BundleDescriptionImpl)systemBundles[0];
            ExportPackageDescription[] exports = systemBundle.getExportPackages();
            int i = 0;
            while (i < exports.length) {
                if ((Integer)exports[i].getDirective("x-equinox-ee") >= 0) {
                    result.add(exports[i]);
                }
                ++i;
            }
        }
        return result.toArray(new ExportPackageDescription[result.size()]);
    }

    boolean inStrictMode() {
        return "strict".equals(this.getPlatformProperties()[0].get("osgi.resolverMode"));
    }

    public synchronized ResolverError[] getResolverErrors(BundleDescription bundle) {
        if (bundle.isResolved()) {
            return new ResolverError[0];
        }
        ArrayList result = (ArrayList)this.resolverErrors.get(bundle);
        return result == null ? new ResolverError[]{} : result.toArray(new ResolverError[result.size()]);
    }

    public synchronized void addResolverError(BundleDescription bundle, int type, String data, VersionConstraint unsatisfied) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        ArrayList<ResolverErrorImpl> errors = (ArrayList<ResolverErrorImpl>)this.resolverErrors.get(bundle);
        if (errors == null) {
            errors = new ArrayList<ResolverErrorImpl>(1);
            this.resolverErrors.put(bundle, errors);
        }
        errors.add(new ResolverErrorImpl((BundleDescriptionImpl)bundle, type, data, unsatisfied));
    }

    public synchronized void removeResolverErrors(BundleDescription bundle) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.resolverErrors.remove(bundle);
    }

    public boolean dynamicCacheChanged() {
        return this.dynamicCacheChanged;
    }

    void setDynamicCacheChanged(boolean dynamicCacheChanged) {
        this.dynamicCacheChanged = dynamicCacheChanged;
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPlatformPropertyKeys(String[] keys) {
        HashSet hashSet = this.platformPropertyKeys;
        synchronized (hashSet) {
            int i = 0;
            while (i < keys.length) {
                if (!this.platformPropertyKeys.contains(keys[i])) {
                    this.platformPropertyKeys.add(keys[i]);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPlatformPropertyKeys() {
        HashSet hashSet = this.platformPropertyKeys;
        synchronized (hashSet) {
            return this.platformPropertyKeys.toArray(new String[this.platformPropertyKeys.size()]);
        }
    }

    public long getHighestBundleId() {
        return this.highestBundleId;
    }

    public void setNativePathsInvalid(NativeCodeDescription nativeCodeDescription, boolean hasInvalidNativePaths) {
        ((NativeCodeDescriptionImpl)nativeCodeDescription).setInvalidNativePaths(hasInvalidNativePaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getDisabledBundles() {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            return this.disabledBundles.keySet().toArray(new BundleDescription[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisabledInfo(DisabledInfo disabledInfo) {
        if (this.getBundle(disabledInfo.getBundle().getBundleId()) != disabledInfo.getBundle()) {
            throw new IllegalArgumentException(NLS.bind(StateMsg.BUNDLE_NOT_IN_STATE, disabledInfo.getBundle()));
        }
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList<DisabledInfo> currentInfos = (ArrayList<DisabledInfo>)this.disabledBundles.get(disabledInfo.getBundle());
            if (currentInfos == null) {
                currentInfos = new ArrayList<DisabledInfo>(1);
                currentInfos.add(disabledInfo);
                this.disabledBundles.put(disabledInfo.getBundle(), currentInfos);
            } else {
                Iterator it = currentInfos.iterator();
                while (it.hasNext()) {
                    DisabledInfo currentInfo = (DisabledInfo)it.next();
                    if (!disabledInfo.getPolicyName().equals(currentInfo.getPolicyName())) continue;
                    currentInfos.remove(currentInfo);
                    break;
                }
                currentInfos.add(disabledInfo);
            }
        }
        this.updateTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisabledInfo(DisabledInfo disabledInfo) {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList currentInfos = (ArrayList)this.disabledBundles.get(disabledInfo.getBundle());
            if (currentInfos != null && currentInfos.contains(disabledInfo)) {
                currentInfos.remove(disabledInfo);
                if (currentInfos.isEmpty()) {
                    this.disabledBundles.remove(disabledInfo.getBundle());
                }
            }
        }
        this.updateTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledInfo getDisabledInfo(BundleDescription bundle, String policyName) {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList currentInfos;
            block5: {
                currentInfos = (ArrayList)this.disabledBundles.get(bundle);
                if (currentInfos != null) break block5;
                return null;
            }
            Iterator it = currentInfos.iterator();
            while (it.hasNext()) {
                DisabledInfo currentInfo = (DisabledInfo)it.next();
                if (!currentInfo.getPolicyName().equals(policyName)) continue;
                return currentInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledInfo[] getDisabledInfos(BundleDescription bundle) {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList currentInfos = (ArrayList)this.disabledBundles.get(bundle);
            return currentInfos == null ? EMPTY_DISABLEDINFOS : currentInfos.toArray(new DisabledInfo[currentInfos.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisabledInfo[] getDisabledInfos() {
        ArrayList results = new ArrayList();
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            Iterator allDisabledInfos = this.disabledBundles.values().iterator();
            while (allDisabledInfos.hasNext()) {
                results.addAll((Collection)allDisabledInfos.next());
            }
        }
        return results.toArray(new DisabledInfo[results.size()]);
    }
}

