/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.operation.AccumulatingProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public class ModalContext {
    private static boolean debug = false;
    private static int modalLevel = 0;
    private static boolean runInSeparateThread = true;

    /*
     * Unable to fully structure code
     */
    public static boolean canProgressMonitorBeUsed(IProgressMonitor var0, IProgressMonitor var1_1) {
        if (var0 != var1_1) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((var0 = ((ProgressMonitorWrapper)var0).getWrappedProgressMonitor()) != var1_1) continue;
            return true;
lbl5:
            // 2 sources

            ** while (var0 instanceof ProgressMonitorWrapper)
        }
lbl6:
        // 1 sources

        return false;
    }

    public static void checkCanceled(IProgressMonitor iProgressMonitor) throws InterruptedException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static ModalContextThread getCurrentModalContextThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ModalContextThread) {
            return (ModalContextThread)thread;
        }
        return null;
    }

    public static int getModalLevel() {
        return modalLevel;
    }

    public static boolean isModalContextThread(Thread thread) {
        return thread instanceof ModalContextThread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(IRunnableWithProgress iRunnableWithProgress, boolean bl, IProgressMonitor iProgressMonitor, Display display) throws InvocationTargetException, InterruptedException {
        Assert.isTrue(iRunnableWithProgress != null && iProgressMonitor != null);
        ++modalLevel;
        try {
            if (iProgressMonitor != null) {
                iProgressMonitor.setCanceled(false);
            }
            if (!bl || !runInSeparateThread) {
                ModalContext.runInCurrentThread(iRunnableWithProgress, iProgressMonitor);
            } else {
                ModalContextThread modalContextThread = ModalContext.getCurrentModalContextThread();
                if (modalContextThread != null) {
                    Assert.isTrue(ModalContext.canProgressMonitorBeUsed(iProgressMonitor, modalContextThread.progressMonitor));
                    ModalContext.runInCurrentThread(iRunnableWithProgress, iProgressMonitor);
                } else {
                    modalContextThread = new ModalContextThread(iRunnableWithProgress, iProgressMonitor, display);
                    if (iRunnableWithProgress instanceof IThreadListener) {
                        ((IThreadListener)((Object)iRunnableWithProgress)).threadChange(modalContextThread);
                    }
                    modalContextThread.start();
                    modalContextThread.block();
                    Throwable throwable = modalContextThread.throwable;
                    if (throwable != null) {
                        if (debug && !(throwable instanceof InterruptedException) && !(throwable instanceof OperationCanceledException)) {
                            System.err.println("Exception in modal context operation:");
                            throwable.printStackTrace();
                            System.err.println("Called from:");
                            new InvocationTargetException(null).printStackTrace();
                        }
                        if (throwable instanceof InvocationTargetException) {
                            throw (InvocationTargetException)throwable;
                        }
                        if (throwable instanceof InterruptedException) {
                            throw (InterruptedException)throwable;
                        }
                        if (!(throwable instanceof OperationCanceledException)) throw new InvocationTargetException(throwable);
                        throw new InterruptedException(throwable.getMessage());
                    }
                }
            }
            Object var6_8 = null;
            --modalLevel;
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            --modalLevel;
            throw throwable;
        }
    }

    private static void runInCurrentThread(IRunnableWithProgress iRunnableWithProgress, IProgressMonitor iProgressMonitor) throws InterruptedException, InvocationTargetException {
        try {
            if (iRunnableWithProgress != null) {
                iRunnableWithProgress.run(iProgressMonitor);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (RuntimeException runtimeException) {
            throw new InvocationTargetException(runtimeException);
        }
        catch (Error error) {
            throw new InvocationTargetException(error);
        }
    }

    public static void setDebugMode(boolean bl) {
        debug = bl;
    }

    private static class ModalContextThread
    extends Thread {
        private IRunnableWithProgress runnable;
        private Throwable throwable;
        private IProgressMonitor progressMonitor;
        private Display display;
        private volatile boolean continueEventDispatching = true;
        private Thread callingThread;

        private ModalContextThread(IRunnableWithProgress iRunnableWithProgress, IProgressMonitor iProgressMonitor, Display display) {
            super("ModalContext");
            Assert.isTrue(iProgressMonitor != null && display != null);
            this.runnable = iRunnableWithProgress;
            this.progressMonitor = new AccumulatingProgressMonitor(iProgressMonitor, display);
            this.display = display;
            this.callingThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (this.runnable != null) {
                        this.runnable.run(this.progressMonitor);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.throwable = invocationTargetException;
                }
                catch (InterruptedException interruptedException) {
                    this.throwable = interruptedException;
                }
                catch (RuntimeException runtimeException) {
                    this.throwable = runtimeException;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Error error) {
                    this.throwable = error;
                }
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                if (this.runnable instanceof IThreadListener) {
                    ((IThreadListener)((Object)this.runnable)).threadChange(this.callingThread);
                }
                this.display.syncExec(new Runnable(this){
                    final /* synthetic */ ModalContextThread this$1;
                    {
                        this.this$1 = modalContextThread;
                    }

                    public void run() {
                    }
                });
                this.continueEventDispatching = false;
                this.display.asyncExec(null);
                throw throwable;
            }
            {
                Object var2_8 = null;
            }
            if (this.runnable instanceof IThreadListener) {
                ((IThreadListener)((Object)this.runnable)).threadChange(this.callingThread);
            }
            this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            this.continueEventDispatching = false;
            this.display.asyncExec(null);
        }

        public void block() {
            if (this.display == Display.getCurrent()) {
                while (this.continueEventDispatching) {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
            } else {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    this.throwable = interruptedException;
                }
            }
        }
    }
}

