/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteReconciler
extends ModelObject {
    public SiteReconciler(LocalSite localSite) {
    }

    URL resolveSiteEntry(IPlatformConfiguration.ISiteEntry iSiteEntry) throws CoreException {
        URL uRL = null;
        try {
            uRL = FileLocator.resolve((URL)iSiteEntry.getURL());
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteLocal_UnableToResolve, (Object[])new String[]{iSiteEntry.getURL().toExternalForm()}), iOException);
        }
        return uRL;
    }

    public static void checkConfiguredFeaturesOld(IConfiguredSite iConfiguredSite) throws CoreException {
        ConfiguredSite configuredSite = (ConfiguredSite)iConfiguredSite;
        IFeatureReference[] iFeatureReferenceArray = configuredSite.getConfiguredFeatures();
        ConfigurationPolicy configurationPolicy = configuredSite.getConfigurationPolicy();
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare features within :" + iConfiguredSite.getSite().getURL());
        }
        int n = 0;
        while (n < iFeatureReferenceArray.length - 1) {
            IFeatureReference iFeatureReference = iFeatureReferenceArray[n];
            int n2 = n + 1;
            while (n2 < iFeatureReferenceArray.length) {
                int n3 = SiteReconciler.compare(iFeatureReference, iFeatureReferenceArray[n2]);
                if (n3 != 0) {
                    if (n3 == 1) {
                        configurationPolicy.unconfigure(iFeatureReferenceArray[n2], true, false, null);
                    }
                    if (n3 == 2) {
                        configurationPolicy.unconfigure(iFeatureReference, true, false, null);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private static int compare(IFeatureReference iFeatureReference, IFeatureReference iFeatureReference2) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare: " + iFeatureReference + " && " + iFeatureReference2);
        }
        if (iFeatureReference == null) {
            return 0;
        }
        IFeature iFeature = null;
        IFeature iFeature2 = null;
        try {
            iFeature = iFeatureReference.getFeature(null);
            iFeature2 = iFeatureReference2.getFeature(null);
        }
        catch (CoreException coreException) {
            UpdateCore.warn(null, coreException);
            return 0;
        }
        if (iFeature == null || iFeature2 == null) {
            return 0;
        }
        VersionedIdentifier versionedIdentifier = iFeature.getVersionedIdentifier();
        VersionedIdentifier versionedIdentifier2 = iFeature2.getVersionedIdentifier();
        if (versionedIdentifier == null || versionedIdentifier2 == null) {
            return 0;
        }
        if (versionedIdentifier.getIdentifier() != null && versionedIdentifier.getIdentifier().equals(versionedIdentifier2.getIdentifier())) {
            PluginVersionIdentifier pluginVersionIdentifier = versionedIdentifier.getVersion();
            PluginVersionIdentifier pluginVersionIdentifier2 = versionedIdentifier2.getVersion();
            if (pluginVersionIdentifier != null) {
                if (pluginVersionIdentifier.isGreaterThan(pluginVersionIdentifier2)) {
                    return 1;
                }
                return 2;
            }
            return 2;
        }
        return 0;
    }

    public static void checkConfiguredFeatures(IConfiguredSite iConfiguredSite) {
        Object object;
        IFeature iFeature;
        Object object2;
        Object object3;
        Object object4;
        ConfiguredSite configuredSite = (ConfiguredSite)iConfiguredSite;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Validate configuration of site " + configuredSite.getSite().getURL());
        }
        IFeatureReference[] iFeatureReferenceArray = configuredSite.getConfiguredFeatures();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            try {
                object4 = iFeatureReferenceArray[n].getFeature(null);
                arrayList.add(object4);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("   configured feature " + object4.getVersionedIdentifier().toString());
                }
            }
            catch (CoreException coreException) {
                UpdateCore.warn("", coreException);
            }
            ++n;
        }
        ArrayList arrayList2 = SiteReconciler.computeTopFeatures(arrayList);
        object4 = SiteReconciler.getNonEfixFeatures(arrayList2);
        ArrayList arrayList3 = SiteReconciler.expandFeatures((ArrayList)object4, iConfiguredSite);
        if (arrayList2.size() != ((ArrayList)object4).size() && !(object3 = SiteReconciler.getPatchesAsFeature(arrayList)).isEmpty()) {
            object2 = SiteReconciler.getPatchesToEnable((Map)object3, arrayList3);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                iFeature = (IFeature)iterator.next();
                object = new ArrayList();
                SiteReconciler.expandEfixFeature(iFeature, (ArrayList)object, iConfiguredSite);
                arrayList3.addAll(object);
            }
        }
        object3 = SiteReconciler.diff(arrayList, arrayList3);
        object2 = configuredSite.getConfigurationPolicy();
        int n2 = 0;
        while (n2 < ((ArrayList)object3).size()) {
            iFeature = (IFeature)((ArrayList)object3).get(n2);
            object = configuredSite.getSite().getFeatureReference(iFeature);
            try {
                ((ConfigurationPolicy)((Object)object2)).unconfigure((IFeatureReference)object, true, false, null);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("Unconfiguring \"extra\" feature " + iFeature.getVersionedIdentifier().toString());
                }
            }
            catch (CoreException coreException) {
                UpdateCore.warn("", coreException);
            }
            ++n2;
        }
    }

    private static ArrayList computeTopFeatures(ArrayList arrayList) {
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray;
        HashMap<VersionedIdentifier, IIncludedFeatureReference[]> hashMap = new HashMap<VersionedIdentifier, IIncludedFeatureReference[]>(arrayList.size());
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            iIncludedFeatureReferenceArray = (IIncludedFeatureReference[])object.next();
            hashMap.put(iIncludedFeatureReferenceArray.getVersionedIdentifier(), iIncludedFeatureReferenceArray);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                iIncludedFeatureReferenceArray = ((IFeature)object.next()).getIncludedFeatureReferences();
                int n = 0;
                while (n < iIncludedFeatureReferenceArray.length) {
                    block9: {
                        try {
                            hashMap.remove(iIncludedFeatureReferenceArray[n].getVersionedIdentifier());
                        }
                        catch (CoreException coreException) {
                            if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) break block9;
                            UpdateCore.warn("", coreException);
                        }
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                UpdateCore.warn("", coreException);
            }
        }
        object = new ArrayList();
        ((ArrayList)object).addAll(hashMap.values());
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Computed top-level features");
            int n = 0;
            while (n < hashMap.size()) {
                UpdateCore.debug("   " + ((IFeature)((ArrayList)object).get(n)).getVersionedIdentifier().toString());
                ++n;
            }
        }
        return object;
    }

    private static ArrayList expandFeatures(ArrayList arrayList, IConfiguredSite iConfiguredSite) {
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            SiteReconciler.expandFeature((IFeature)arrayList.get(n), arrayList2, iConfiguredSite);
            ++n;
        }
        return arrayList2;
    }

    private static void expandFeature(IFeature iFeature, ArrayList arrayList, IConfiguredSite iConfiguredSite) {
        if (!arrayList.contains(iFeature)) {
            arrayList.add(iFeature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + iFeature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = null;
        try {
            iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        }
        catch (CoreException coreException) {
            UpdateCore.warn("", coreException);
            return;
        }
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            IFeature iFeature2;
            block8: {
                iFeature2 = null;
                try {
                    iFeature2 = iIncludedFeatureReferenceArray[n].getFeature(null);
                }
                catch (CoreException coreException) {
                    if (UpdateManagerUtils.isOptional(iIncludedFeatureReferenceArray[n])) break block8;
                    UpdateCore.warn("", coreException);
                }
            }
            if (iFeature2 != null) {
                SiteReconciler.expandFeature(iFeature2, arrayList, iConfiguredSite);
            }
            ++n;
        }
    }

    private static ArrayList diff(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<IFeature> arrayList3 = new ArrayList<IFeature>();
        int n = 0;
        while (n < arrayList.size()) {
            IFeature iFeature = (IFeature)arrayList.get(n);
            if (!arrayList2.contains(iFeature)) {
                arrayList3.add(iFeature);
            }
            ++n;
        }
        return arrayList3;
    }

    private static Map getPatchesAsFeature(ArrayList arrayList) {
        HashMap hashMap = new HashMap();
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ArrayList<VersionedIdentifier> arrayList2 = new ArrayList<VersionedIdentifier>();
                IFeature iFeature = (IFeature)iterator.next();
                int n = 0;
                while (n < iFeature.getImports().length) {
                    if (iFeature.getImports()[n].isPatch()) {
                        VersionedIdentifier versionedIdentifier = iFeature.getImports()[n].getVersionedIdentifier();
                        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                            UpdateCore.debug("Found patch " + iFeature + " for feature identifier " + versionedIdentifier);
                        }
                        arrayList2.add(versionedIdentifier);
                    }
                    ++n;
                }
                if (arrayList2.isEmpty()) continue;
                hashMap.put(iFeature, arrayList2);
            }
        }
        return hashMap;
    }

    private static List getPatchesToEnable(Map map, ArrayList arrayList) {
        Object object;
        ArrayList<VersionedIdentifier> arrayList2 = new ArrayList<VersionedIdentifier>();
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (IFeature)iterator.next();
            arrayList2.add(object.getVersionedIdentifier());
        }
        object = new ArrayList();
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            IFeature iFeature = (IFeature)iterator.next();
            List list = (List)map.get(iFeature);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext() && !bl) {
                VersionedIdentifier versionedIdentifier = (VersionedIdentifier)iterator2.next();
                if (!arrayList2.contains(versionedIdentifier)) continue;
                bl = true;
            }
            if (!bl) {
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("The Patch " + iFeature + " does not patch any enabled features: it will be disabled");
                continue;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("The patch " + iFeature + " will be enabled.");
            }
            object.add(iFeature);
        }
        return object;
    }

    private static ArrayList getNonEfixFeatures(ArrayList arrayList) {
        Map map = SiteReconciler.getPatchesAsFeature(arrayList);
        Set set = map.keySet();
        if (set == null || set.isEmpty()) {
            return arrayList;
        }
        Iterator iterator = arrayList.iterator();
        ArrayList<IFeature> arrayList2 = new ArrayList<IFeature>();
        while (iterator.hasNext()) {
            IFeature iFeature = (IFeature)iterator.next();
            if (set.contains(iFeature)) continue;
            arrayList2.add(iFeature);
        }
        return arrayList2;
    }

    private static void expandEfixFeature(IFeature iFeature, ArrayList arrayList, IConfiguredSite iConfiguredSite) {
        if (!arrayList.contains(iFeature)) {
            arrayList.add(iFeature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + iFeature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = null;
        try {
            iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        }
        catch (CoreException coreException) {
            UpdateCore.warn("", coreException);
            return;
        }
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            IFeature iFeature2;
            block8: {
                iFeature2 = null;
                try {
                    iFeature2 = iIncludedFeatureReferenceArray[n].getFeature(null);
                }
                catch (CoreException coreException) {
                    if (iIncludedFeatureReferenceArray[n].isOptional()) break block8;
                    UpdateCore.warn("", coreException);
                }
            }
            if (iFeature2 != null && !UpdateCore.isPatch(iFeature2)) {
                SiteReconciler.expandEfixFeature(iFeature2, arrayList, iConfiguredSite);
            }
            ++n;
        }
    }
}

