/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;

public class SignedContentFile
implements SignedContent {
    private final SignedContentImpl signedContent;
    private HashMap entryExceptions = null;

    public SignedContentFile(SignedContentImpl signedContentImpl) {
        try {
            signedContentImpl.content.close();
        }
        catch (IOException iOException) {}
        this.signedContent = signedContentImpl;
    }

    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        this.signedContent.checkValidity(signerInfo);
    }

    public synchronized SignedContentEntry[] getSignedEntries() {
        SignedContentEntry[] signedContentEntryArray = this.signedContent.getSignedEntries();
        if (this.signedContent == null) {
            return null;
        }
        SignedContentEntry[] signedContentEntryArray2 = new SignedContentEntry[signedContentEntryArray.length];
        Map map = this.getEntryExceptions(true);
        int n = 0;
        while (n < signedContentEntryArray.length) {
            try {
                signedContentEntryArray[n].verify();
            }
            catch (Throwable throwable) {
                map.put(signedContentEntryArray[n].getName(), throwable);
            }
            signedContentEntryArray2[n] = new SignedContentFileEntry(signedContentEntryArray[n]);
            ++n;
        }
        try {
            this.signedContent.content.close();
        }
        catch (IOException iOException) {}
        return signedContentEntryArray2;
    }

    public synchronized SignedContentEntry getSignedEntry(String string) {
        SignedContentEntry signedContentEntry;
        if (this.getEntryExceptions(false) == null) {
            this.getSignedEntries();
        }
        return (signedContentEntry = this.signedContent.getSignedEntry(string)) == null ? null : new SignedContentFileEntry(signedContentEntry);
    }

    public SignerInfo[] getSignerInfos() {
        return this.signedContent.getSignerInfos();
    }

    public Date getSigningTime(SignerInfo signerInfo) {
        return this.signedContent.getSigningTime(signerInfo);
    }

    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        return this.signedContent.getTSASignerInfo(signerInfo);
    }

    public boolean isSigned() {
        return this.signedContent.isSigned();
    }

    synchronized Map getEntryExceptions(boolean bl) {
        if (bl && this.entryExceptions == null) {
            this.entryExceptions = new HashMap(5);
        }
        return this.entryExceptions;
    }

    public class SignedContentFileEntry
    implements SignedContentEntry {
        private final SignedContentEntry entry;

        public SignedContentFileEntry(SignedContentEntry signedContentEntry) {
            this.entry = signedContentEntry;
        }

        public String getName() {
            return this.entry.getName();
        }

        public SignerInfo[] getSignerInfos() {
            return this.entry.getSignerInfos();
        }

        public boolean isSigned() {
            return this.entry.isSigned();
        }

        public void verify() throws IOException, InvalidContentException {
            Throwable throwable;
            Map map = SignedContentFile.this.getEntryExceptions(false);
            Throwable throwable2 = throwable = map == null ? null : (Throwable)map.get(this.entry.getName());
            if (throwable == null) {
                return;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof InvalidContentException) {
                throw (InvalidContentException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        }
    }
}

