/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IVariableResolver;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class EvaluationContext
implements IEvaluationContext {
    private IEvaluationContext fParent;
    private Object fDefaultVariable;
    private Map fVariables;
    private IVariableResolver[] fVariableResolvers;
    private Boolean fAllowPluginActivation;

    public EvaluationContext(IEvaluationContext iEvaluationContext, Object object) {
        Assert.isNotNull((Object)object);
        this.fParent = iEvaluationContext;
        this.fDefaultVariable = object;
    }

    public EvaluationContext(IEvaluationContext iEvaluationContext, Object object, IVariableResolver[] iVariableResolverArray) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)iVariableResolverArray);
        this.fParent = iEvaluationContext;
        this.fDefaultVariable = object;
        this.fVariableResolvers = iVariableResolverArray;
    }

    public IEvaluationContext getParent() {
        return this.fParent;
    }

    public IEvaluationContext getRoot() {
        if (this.fParent == null) {
            return this;
        }
        return this.fParent.getRoot();
    }

    public Object getDefaultVariable() {
        return this.fDefaultVariable;
    }

    public void setAllowPluginActivation(boolean bl) {
        this.fAllowPluginActivation = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getAllowPluginActivation() {
        if (this.fAllowPluginActivation == null) {
            if (this.fParent != null) {
                return this.fParent.getAllowPluginActivation();
            }
            return false;
        }
        return this.fAllowPluginActivation;
    }

    public void addVariable(String string, Object object) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)object);
        if (this.fVariables == null) {
            this.fVariables = new HashMap();
        }
        this.fVariables.put(string, object);
    }

    public Object removeVariable(String string) {
        Assert.isNotNull((Object)string);
        if (this.fVariables == null) {
            return null;
        }
        return this.fVariables.remove(string);
    }

    public Object getVariable(String string) {
        Assert.isNotNull((Object)string);
        Object var2_2 = null;
        if (this.fVariables != null) {
            var2_2 = this.fVariables.get(string);
        }
        if (var2_2 != null) {
            return var2_2;
        }
        if (this.fParent != null) {
            return this.fParent.getVariable(string);
        }
        return null;
    }

    public Object resolveVariable(String string, Object[] objectArray) throws CoreException {
        if (this.fVariableResolvers != null && this.fVariableResolvers.length > 0) {
            int n = 0;
            while (n < this.fVariableResolvers.length) {
                IVariableResolver iVariableResolver = this.fVariableResolvers[n];
                Object object = iVariableResolver.resolve(string, objectArray);
                if (object != null) {
                    return object;
                }
                ++n;
            }
        }
        if (this.fParent != null) {
            return this.fParent.resolveVariable(string, objectArray);
        }
        return null;
    }
}

