/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collection;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandPersistence;

public final class CommandService
implements ICommandService {
    private final CommandManager commandManager;

    public CommandService(CommandManager commandManager) {
        if (commandManager == null) {
            throw new NullPointerException("Cannot create a command service with a null manager");
        }
        this.commandManager = commandManager;
    }

    public final void addExecutionListener(IExecutionListener iExecutionListener) {
        this.commandManager.addExecutionListener(iExecutionListener);
    }

    public final Category getCategory(String string) {
        return this.commandManager.getCategory(string);
    }

    public final Command getCommand(String string) {
        return this.commandManager.getCommand(string);
    }

    public final Collection getDefinedCategoryIds() {
        return this.commandManager.getDefinedCategoryIds();
    }

    public final Collection getDefinedCommandIds() {
        return this.commandManager.getDefinedCommandIds();
    }

    public final void readRegistry() {
        CommandPersistence.read(this.commandManager);
    }

    public final void removeExecutionListener(IExecutionListener iExecutionListener) {
        this.commandManager.removeExecutionListener(iExecutionListener);
    }
}

