/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.osgi.service.condpermadmin.Condition;

public class FrameworkSecurityManager
extends SecurityManager {
    ThreadLocal localCheckContext = new ThreadLocal();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager$CheckPermissionAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class clazz2 = clazz;
        Class clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager$CheckContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz2 = clazz3;
        clazz2.getName();
    }

    boolean addConditionsForDomain(Condition[][] conditionArray) {
        CheckContext checkContext = (CheckContext)this.localCheckContext.get();
        if (checkContext == null) {
            return false;
        }
        Vector<Condition[][]> vector = (Vector<Condition[][]>)checkContext.depthCondSets.get(checkContext.getDepth());
        if (vector == null) {
            vector = new Vector<Condition[][]>(2);
            checkContext.depthCondSets.set(checkContext.getDepth(), vector);
        }
        vector.add(conditionArray);
        return true;
    }

    public void checkPermission(Permission permission, Object object) {
        AccessController.doPrivileged(new CheckPermissionAction(this, permission, object));
    }

    public AccessControlContext getContextToBeChecked() {
        CheckContext checkContext = (CheckContext)this.localCheckContext.get();
        if (checkContext != null && checkContext.accs != null && !checkContext.accs.isEmpty()) {
            return (AccessControlContext)checkContext.accs.get(checkContext.accs.size() - 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void internalCheckPermission(Permission permission, Object object) {
        CheckContext checkContext;
        block7: {
            AccessControlContext accessControlContext = (AccessControlContext)object;
            checkContext = (CheckContext)this.localCheckContext.get();
            if (checkContext == null) {
                checkContext = new CheckContext();
                this.localCheckContext.set(checkContext);
            }
            checkContext.depthCondSets.add(null);
            checkContext.accs.add(accessControlContext);
            try {
                accessControlContext.checkPermission(permission);
                Vector vector = (Vector)checkContext.depthCondSets.get(checkContext.getDepth());
                if (vector == null) break block7;
                Hashtable hashtable = new Hashtable(2);
                Condition[][] conditionArray = (Condition[][])vector.remove(0);
                int n = 0;
                while (true) {
                    if (n >= conditionArray.length) {
                        throw new SecurityException("Conditions not satisfied");
                    }
                    if (this.recursiveCheck(vector, conditionArray[n], null, hashtable, checkContext)) {
                        Object var9_9 = null;
                        checkContext.depthCondSets.remove(checkContext.getDepth());
                        break;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                checkContext.depthCondSets.remove(checkContext.getDepth());
                checkContext.accs.remove(checkContext.accs.size() - 1);
                throw throwable;
            }
            checkContext.accs.remove(checkContext.accs.size() - 1);
            return;
        }
        Object var9_11 = null;
        checkContext.depthCondSets.remove(checkContext.getDepth());
        checkContext.accs.remove(checkContext.accs.size() - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recursiveCheck(Vector vector, Condition[] conditionArray, Hashtable hashtable, Hashtable hashtable2, CheckContext checkContext) {
        Object object;
        Serializable serializable;
        block20: {
            if (hashtable == null) {
                hashtable = new Hashtable(2);
            } else {
                Hashtable hashtable3 = new Hashtable(2);
                serializable = hashtable.keys();
                while (true) {
                    if (!serializable.hasMoreElements()) {
                        hashtable = hashtable3;
                        break;
                    }
                    object = serializable.nextElement();
                    hashtable3.put(object, ((Vector)hashtable.get(object)).clone());
                }
            }
            int n = 0;
            while (true) {
                if (n >= conditionArray.length) {
                    if (vector.size() > 0) {
                        break;
                    }
                    break block20;
                }
                if (conditionArray[n] != null) {
                    serializable = (Vector)hashtable.get(conditionArray[n].getClass());
                    if (serializable == null) {
                        serializable = new Vector();
                        hashtable.put(conditionArray[n].getClass(), (Vector<Condition>)serializable);
                    }
                    serializable.add(conditionArray[n]);
                }
                ++n;
            }
            Condition[][] conditionArray2 = (Condition[][])vector.get(0);
            serializable = (Vector)vector.clone();
            serializable.remove(0);
            int n2 = 0;
            while (true) {
                if (n2 >= conditionArray2.length) {
                    return false;
                }
                if (this.recursiveCheck((Vector)serializable, conditionArray2[n2], hashtable, hashtable2, checkContext)) {
                    return true;
                }
                ++n2;
            }
        }
        Enumeration enumeration = hashtable.keys();
        while (true) {
            Object var11_15;
            Condition[] conditionArray3;
            block21: {
                if (!enumeration.hasMoreElements()) {
                    return true;
                }
                serializable = (Class)enumeration.nextElement();
                object = (Vector)hashtable.get(serializable);
                if (((Vector)object).size() == 0) continue;
                conditionArray3 = ((Vector)object).toArray(new Condition[((Vector)object).size()]);
                Hashtable hashtable4 = (Hashtable)hashtable2.get(serializable);
                if (hashtable4 == null) {
                    hashtable4 = new Hashtable(2);
                    hashtable2.put(serializable, hashtable4);
                }
                if (checkContext.CondClassSet == null) {
                    checkContext.CondClassSet = new ArrayList(2);
                }
                if (checkContext.CondClassSet.contains(conditionArray3[0].getClass())) {
                    return false;
                }
                checkContext.CondClassSet.add(conditionArray3[0].getClass());
                try {
                    if (conditionArray3[0].isSatisfied(conditionArray3, hashtable4)) break block21;
                    var11_15 = null;
                    checkContext.CondClassSet.remove(conditionArray3[0].getClass());
                    return false;
                }
                catch (Throwable throwable) {
                    var11_15 = null;
                    checkContext.CondClassSet.remove(conditionArray3[0].getClass());
                    throw throwable;
                }
            }
            var11_15 = null;
            checkContext.CondClassSet.remove(conditionArray3[0].getClass());
        }
    }

    public void checkPermission(Permission permission) {
        this.checkPermission(permission, this.getSecurityContext());
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    static class CheckContext {
        ArrayList depthCondSets = new ArrayList(2);
        ArrayList accs = new ArrayList(2);
        ArrayList CondClassSet;

        CheckContext() {
        }

        public int getDepth() {
            return this.depthCondSets.size() - 1;
        }
    }

    static class CheckPermissionAction
    implements PrivilegedAction {
        Permission perm;
        Object context;
        FrameworkSecurityManager fsm;

        CheckPermissionAction(FrameworkSecurityManager frameworkSecurityManager, Permission permission, Object object) {
            this.fsm = frameworkSecurityManager;
            this.perm = permission;
            this.context = object;
        }

        public Object run() {
            this.fsm.internalCheckPermission(this.perm, this.context);
            return null;
        }
    }
}

