/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.VersionSupplier;

public class VersionHashMap
extends MappedList
implements Comparator {
    private ResolverImpl resolver;

    public VersionHashMap(ResolverImpl resolverImpl) {
        this.resolver = resolverImpl;
    }

    protected void sort(Object[] objectArray) {
        Arrays.sort(objectArray, this);
    }

    public void put(VersionSupplier[] versionSupplierArray) {
        int n = 0;
        while (n < versionSupplierArray.length) {
            this.put(versionSupplierArray[n].getName(), versionSupplierArray[n]);
            ++n;
        }
    }

    public boolean contains(VersionSupplier versionSupplier) {
        return this.contains(versionSupplier, false) != null;
    }

    private VersionSupplier contains(VersionSupplier versionSupplier, boolean bl) {
        Object[] objectArray = (Object[])this.internal.get(versionSupplier.getName());
        if (objectArray == null) {
            return null;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == versionSupplier) {
                if (bl) {
                    if (objectArray.length == 1) {
                        this.internal.remove(versionSupplier.getName());
                        return versionSupplier;
                    }
                    Object[] objectArray2 = new Object[objectArray.length - 1];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n);
                    if (n + 1 < objectArray.length) {
                        System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
                    }
                    this.internal.put(versionSupplier.getName(), objectArray2);
                }
                return versionSupplier;
            }
            ++n;
        }
        return null;
    }

    public Object remove(VersionSupplier versionSupplier) {
        return this.contains(versionSupplier, true);
    }

    public void remove(VersionSupplier[] versionSupplierArray) {
        int n = 0;
        while (n < versionSupplierArray.length) {
            this.remove(versionSupplierArray[n]);
            ++n;
        }
    }

    void reorder() {
        Iterator iterator = this.internal.values().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (objectArray.length <= 1) continue;
            this.sort(objectArray);
        }
    }

    public int compare(Object object, Object object2) {
        if (!(object instanceof VersionSupplier) || !(object2 instanceof VersionSupplier)) {
            throw new IllegalArgumentException();
        }
        VersionSupplier versionSupplier = (VersionSupplier)object;
        VersionSupplier versionSupplier2 = (VersionSupplier)object2;
        if (this.resolver.getSelectionPolicy() != null) {
            return this.resolver.getSelectionPolicy().compare(versionSupplier.getBaseDescription(), versionSupplier2.getBaseDescription());
        }
        String string = this.resolver.getSystemBundle();
        if (string.equals(versionSupplier.getBundle().getSymbolicName()) && !string.equals(versionSupplier2.getBundle().getSymbolicName())) {
            return -1;
        }
        if (!string.equals(versionSupplier.getBundle().getSymbolicName()) && string.equals(versionSupplier2.getBundle().getSymbolicName())) {
            return 1;
        }
        if (versionSupplier.getBundle().isResolved() != versionSupplier2.getBundle().isResolved()) {
            return versionSupplier.getBundle().isResolved() ? -1 : 1;
        }
        int n = -versionSupplier.getVersion().compareTo(versionSupplier2.getVersion());
        if (n != 0) {
            return n;
        }
        return versionSupplier.getBundle().getBundleId() <= versionSupplier2.getBundle().getBundleId() ? -1 : 1;
    }
}

