/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.security.JarVerifier;

public class FeaturePackagedContentProvider
extends FeatureContentProvider {
    private ContentReference localManifest = null;
    private ContentReference[] localFeatureFiles = new ContentReference[0];
    private IVerifier jarVerifier = null;
    public static final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.endsWith(".jar");
        }
    };

    public FeaturePackagedContentProvider(URL uRL) {
        super(uRL);
    }

    public IVerifier getVerifier() throws CoreException {
        if (this.jarVerifier == null || this.jarVerifier.getParent() == null) {
            this.jarVerifier = new JarVerifier();
            return this.jarVerifier;
        }
        return this.jarVerifier;
    }

    public ContentReference getFeatureManifestReference(InstallMonitor installMonitor) throws CoreException {
        if (this.localManifest != null) {
            return this.localManifest;
        }
        ContentReference[] contentReferenceArray = this.getFeatureEntryArchiveReferences(installMonitor);
        JarContentReference jarContentReference = null;
        try {
            jarContentReference = (JarContentReference)this.asLocalReference(contentReferenceArray[0], null);
            this.localFeatureFiles = jarContentReference.unpack(this.getWorkingDirectory(), null, installMonitor);
        }
        catch (IOException iOException) {
            throw this.errorRetrieving("feature.xml", jarContentReference, iOException);
        }
        int n = 0;
        while (n < this.localFeatureFiles.length) {
            if (this.localFeatureFiles[n].getIdentifier().equals("feature.xml")) {
                this.localManifest = this.localFeatureFiles[n];
                return this.localManifest;
            }
            ++n;
        }
        Object[] objectArray = new String[]{"feature.xml", this.getURL().toExternalForm()};
        throw Utilities.newCoreException(NLS.bind((String)Messages.FeaturePackagedContentProvider_NoManifestFile, (Object[])objectArray), new Exception());
    }

    public ContentReference[] getArchiveReferences(InstallMonitor installMonitor) throws CoreException {
        IPluginEntry[] iPluginEntryArray = this.getFeature().getPluginEntries();
        INonPluginEntry[] iNonPluginEntryArray = this.getFeature().getNonPluginEntries();
        ArrayList<ContentReference> arrayList = new ArrayList<ContentReference>();
        ContentReference[] contentReferenceArray = new ContentReference[]{};
        arrayList.addAll(Arrays.asList(this.getFeatureEntryArchiveReferences(installMonitor)));
        int n = 0;
        while (n < iPluginEntryArray.length) {
            arrayList.addAll(Arrays.asList(this.getPluginEntryArchiveReferences(iPluginEntryArray[n], installMonitor)));
            ++n;
        }
        n = 0;
        while (n < iNonPluginEntryArray.length) {
            arrayList.addAll(Arrays.asList(this.getNonPluginEntryArchiveReferences(iNonPluginEntryArray[n], installMonitor)));
            ++n;
        }
        if (arrayList.size() > 0) {
            contentReferenceArray = new ContentReference[arrayList.size()];
            arrayList.toArray(contentReferenceArray);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getFeatureEntryArchiveReferences(InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = new ContentReference[1];
        ContentReference contentReference = null;
        String string = null;
        try {
            string = this.getFeature() != null ? this.getFeature().getVersionedIdentifier().toString() : "";
            contentReference = new JarContentReference(string, this.getURL());
            contentReference = this.asLocalReference(contentReference, installMonitor);
            contentReferenceArray[0] = contentReference;
        }
        catch (IOException iOException) {
            throw this.errorRetrieving(string, contentReference, iOException);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getPluginEntryArchiveReferences(IPluginEntry iPluginEntry, InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = new ContentReference[1];
        String string = this.getPathID(iPluginEntry);
        ISite iSite = this.getFeature() == null ? null : this.getFeature().getSite();
        ISiteContentProvider iSiteContentProvider = iSite == null ? null : iSite.getSiteContentProvider();
        URL uRL = iSiteContentProvider == null ? null : iSiteContentProvider.getArchiveReference(string);
        try {
            contentReferenceArray[0] = this.asLocalReference(new JarContentReference(string, uRL), installMonitor);
        }
        catch (IOException iOException) {
            throw this.errorRetrieving(string, contentReferenceArray[0], iOException);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getNonPluginEntryArchiveReferences(INonPluginEntry iNonPluginEntry, InstallMonitor installMonitor) throws CoreException {
        String string = "features/" + (this.getFeature() != null ? this.getFeature().getVersionedIdentifier().toString() : "");
        string = String.valueOf(string) + "/" + iNonPluginEntry.getIdentifier();
        ContentReference[] contentReferenceArray = new ContentReference[1];
        ContentReference contentReference = null;
        try {
            ISite iSite = this.getFeature() == null ? null : this.getFeature().getSite();
            ISiteContentProvider iSiteContentProvider = iSite == null ? null : iSite.getSiteContentProvider();
            URL uRL = iSiteContentProvider == null ? null : iSiteContentProvider.getArchiveReference(string);
            contentReference = new ContentReference(iNonPluginEntry.getIdentifier(), uRL);
            contentReferenceArray[0] = contentReference = this.asLocalReference(contentReference, installMonitor);
        }
        catch (IOException iOException) {
            throw this.errorRetrieving(string, contentReference, iOException);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getFeatureEntryContentReferences(InstallMonitor installMonitor) throws CoreException {
        return this.localFeatureFiles;
    }

    public ContentReference[] getPluginEntryContentReferences(IPluginEntry iPluginEntry, InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = this.getPluginEntryArchiveReferences(iPluginEntry, installMonitor);
        ContentReference[] contentReferenceArray2 = new ContentReference[]{};
        try {
            if (contentReferenceArray[0] instanceof JarContentReference) {
                JarContentReference jarContentReference = (JarContentReference)this.asLocalReference(contentReferenceArray[0], installMonitor);
                contentReferenceArray2 = jarContentReference.peek(null, installMonitor);
            } else {
                List list = this.getFiles(contentReferenceArray[0].asFile());
                contentReferenceArray2 = new ContentReference[list.size()];
                int n = 0;
                while (n < contentReferenceArray2.length) {
                    File file = (File)list.get(n);
                    contentReferenceArray2[n] = new ContentReference(null, file.toURL());
                    ++n;
                }
            }
            this.validatePermissions(contentReferenceArray2);
        }
        catch (IOException iOException) {
            throw this.errorRetrieving(iPluginEntry.getVersionedIdentifier().toString(), contentReferenceArray[0], iOException);
        }
        return contentReferenceArray2;
    }

    private List getFiles(File file) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            throw new IOException(NLS.bind((String)Messages.FeaturePackagedContentProvider_InvalidDirectory, (Object[])new String[]{file.getPath()}));
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    arrayList.addAll(this.getFiles(fileArray[n]));
                } else {
                    arrayList.add(fileArray[n]);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private CoreException errorRetrieving(String string, ContentReference contentReference, Exception exception) {
        Object[] objectArray = new String[]{string};
        return Utilities.newCoreException(NLS.bind((String)Messages.FeaturePackagedContentProvider_ErrorRetrieving, (Object[])objectArray), exception);
    }
}

