/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class DuplicateConflictsValidator {
    public static ArrayList computeDuplicateConflicts(IInstallFeatureOperation iInstallFeatureOperation, IInstallConfiguration iInstallConfiguration, IConfiguredSite iConfiguredSite, IFeatureReference[] iFeatureReferenceArray) {
        Hashtable hashtable = new Hashtable();
        try {
            DuplicateConflictsValidator.computePresentState(hashtable, iInstallConfiguration);
            DuplicateConflictsValidator.computeNewFeature(iInstallFeatureOperation.getFeature(), iConfiguredSite, hashtable, iFeatureReferenceArray);
            return DuplicateConflictsValidator.computeConflicts(hashtable);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static ArrayList computeDuplicateConflicts(IInstallFeatureOperation[] iInstallFeatureOperationArray, IInstallConfiguration iInstallConfiguration) {
        Hashtable hashtable = new Hashtable();
        DuplicateConflictsValidator.computePresentState(hashtable, iInstallConfiguration);
        DuplicateConflictsValidator.computeNewFeatures(iInstallFeatureOperationArray, hashtable);
        return DuplicateConflictsValidator.computeConflicts(hashtable);
    }

    private static ArrayList computeConflicts(Hashtable hashtable) {
        ArrayList<ArrayList> arrayList = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ArrayList arrayList2;
            ArrayList arrayList3 = (ArrayList)enumeration.nextElement();
            if (arrayList3.size() == 1 || (arrayList2 = DuplicateConflictsValidator.checkForConflict(arrayList3)) == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ArrayList>();
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private static ArrayList checkForConflict(ArrayList arrayList) {
        IdEntry idEntry = null;
        int n = 0;
        while (n < arrayList.size()) {
            IdEntry idEntry2 = (IdEntry)arrayList.get(n);
            if (idEntry == null) {
                idEntry = idEntry2;
            } else if (!idEntry2.sameLevel(idEntry)) {
                return arrayList;
            }
            ++n;
        }
        return null;
    }

    private static void computePresentState(Hashtable hashtable, IInstallConfiguration iInstallConfiguration) {
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getConfiguredFeatures();
            int n2 = 0;
            while (n2 < iFeatureReferenceArray.length) {
                try {
                    DuplicateConflictsValidator.addEntry(iFeatureReferenceArray[n2].getFeature(null), iConfiguredSite, hashtable);
                }
                catch (CoreException coreException) {}
                ++n2;
            }
            ++n;
        }
    }

    private static void computeNewFeatures(IInstallFeatureOperation[] iInstallFeatureOperationArray, Hashtable hashtable) {
        int n = 0;
        while (n < iInstallFeatureOperationArray.length) {
            IInstallFeatureOperation iInstallFeatureOperation = iInstallFeatureOperationArray[n];
            IConfiguredSite iConfiguredSite = iInstallFeatureOperation.getTargetSite();
            IFeature iFeature = iInstallFeatureOperation.getFeature();
            try {
                DuplicateConflictsValidator.computeNewFeature(iFeature, iConfiguredSite, hashtable, null);
            }
            catch (CoreException coreException) {}
            ++n;
        }
    }

    private static void computeNewFeature(IFeature iFeature, IConfiguredSite iConfiguredSite, Hashtable hashtable, IFeatureReference[] iFeatureReferenceArray) throws CoreException {
        DuplicateConflictsValidator.addEntry(iFeature, iConfiguredSite, hashtable);
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
            boolean bl = true;
            if (iIncludedFeatureReference.isOptional() && iFeatureReferenceArray != null) {
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < iFeatureReferenceArray.length) {
                    IFeatureReference iFeatureReference = iFeatureReferenceArray[n2];
                    if (iFeatureReference.equals(iIncludedFeatureReference)) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
                bl = bl2;
            }
            if (bl) {
                DuplicateConflictsValidator.computeNewFeature(iIncludedFeatureReference.getFeature(null), iConfiguredSite, hashtable, iFeatureReferenceArray);
            }
            ++n;
        }
    }

    private static void addEntry(IFeature iFeature, IConfiguredSite iConfiguredSite, Hashtable hashtable) {
        String string = iFeature.getVersionedIdentifier().getIdentifier();
        ArrayList<IdEntry> arrayList = (ArrayList<IdEntry>)hashtable.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IdEntry>();
            hashtable.put(string, arrayList);
        }
        IdEntry idEntry = new IdEntry(iFeature, iConfiguredSite);
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            IdEntry idEntry2 = (IdEntry)arrayList.get(n);
            IConfiguredSite iConfiguredSite2 = idEntry2.getConfiguredSite();
            if (iConfiguredSite2.equals(idEntry.getConfiguredSite())) {
                if (idEntry.isInstallCandidate()) {
                    arrayList.set(n, idEntry);
                    arrayList.remove(idEntry2);
                }
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(idEntry);
        }
    }

    public static class IdEntry {
        IConfiguredSite csite;
        IFeature feature;

        public IdEntry(IFeature iFeature, IConfiguredSite iConfiguredSite) {
            this.feature = iFeature;
            this.csite = iConfiguredSite;
            if (iConfiguredSite == null) {
                System.out.println("csite null");
            }
        }

        public boolean isInstallCandidate() {
            return this.csite != null;
        }

        public IFeature getFeature() {
            return this.feature;
        }

        public String getIdentifier() {
            return this.feature.getVersionedIdentifier().getIdentifier();
        }

        public IConfiguredSite getConfiguredSite() {
            if (this.csite != null) {
                return this.csite;
            }
            return this.feature.getSite().getCurrentConfiguredSite();
        }

        public boolean sameLevel(IdEntry idEntry) {
            VersionedIdentifier versionedIdentifier = this.feature.getVersionedIdentifier();
            VersionedIdentifier versionedIdentifier2 = idEntry.getFeature().getVersionedIdentifier();
            return versionedIdentifier.equals(versionedIdentifier2);
        }

        public String toString() {
            IConfiguredSite iConfiguredSite = this.getConfiguredSite();
            String string = this.feature.getVersionedIdentifier().getVersion().toString();
            String string2 = iConfiguredSite.getSite().getURL().getFile();
            return NLS.bind((String)Messages.DuplicateConflictsDialog_conflict, (Object[])new String[]{string, string2});
        }
    }
}

