/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.FullFeatureParser;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.branding.AboutInfo;
import org.eclipse.update.internal.configurator.branding.IBundleGroupConstants;
import org.eclipse.update.internal.configurator.branding.IProductConstants;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureEntry
implements IPlatformConfiguration.IFeatureEntry,
IConfigurationConstants,
IBundleGroup,
IBundleGroupConstants,
IProductConstants {
    private String id;
    private String version;
    private String pluginVersion;
    private String application;
    private URL[] root;
    private boolean primary;
    private String pluginIdentifier;
    private String url;
    private String description;
    private String licenseURL;
    private ArrayList plugins;
    private AboutInfo branding;
    private SiteEntry site;
    private ResourceBundle resourceBundle;
    private boolean fullyParsed;

    public FeatureEntry(String string, String string2, String string3, String string4, boolean bl, String string5, URL[] uRLArray) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.id = string;
        this.version = string2;
        this.pluginVersion = string4;
        this.pluginIdentifier = string3;
        this.primary = bl;
        this.application = string5;
        this.root = uRLArray == null ? new URL[]{} : uRLArray;
    }

    public FeatureEntry(String string, String string2, String string3, boolean bl, String string4, URL[] uRLArray) {
        this(string, string2, string, string3, bl, string4, uRLArray);
    }

    public void setSite(SiteEntry siteEntry) {
        this.site = siteEntry;
    }

    public SiteEntry getSite() {
        return this.site;
    }

    public void addPlugin(PluginEntry pluginEntry) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        this.plugins.add(pluginEntry);
    }

    public PluginEntry[] getPluginEntries() {
        if (this.plugins == null) {
            this.fullParse();
        }
        return this.plugins.toArray(new PluginEntry[this.plugins.size()]);
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public String getFeatureIdentifier() {
        return this.id;
    }

    public String getFeatureVersion() {
        return this.version;
    }

    public String getFeaturePluginVersion() {
        return this.pluginVersion != null && this.pluginVersion.length() > 0 ? this.pluginVersion : null;
    }

    public String getFeaturePluginIdentifier() {
        return this.pluginIdentifier != null && this.pluginIdentifier.length() > 0 ? this.pluginIdentifier : this.id;
    }

    public String getFeatureApplication() {
        return this.application;
    }

    public URL[] getFeatureRootURLs() {
        return this.root;
    }

    public boolean canBePrimary() {
        return this.primary;
    }

    public Element toXML(Document document) {
        URL uRL = this.getSite().getConfig().getInstallURL();
        Element element = document.createElement("feature");
        if (this.id != null) {
            element.setAttribute("id", this.id);
        }
        if (this.primary) {
            element.setAttribute("primary", "true");
        }
        if (this.version != null) {
            element.setAttribute("version", this.version);
        }
        if (this.pluginVersion != null && !this.pluginVersion.equals(this.version) && this.pluginVersion.length() > 0) {
            element.setAttribute("plugin-version", this.pluginVersion);
        }
        if (this.pluginIdentifier != null && !this.pluginIdentifier.equals(this.id) && this.pluginIdentifier.length() > 0) {
            element.setAttribute("plugin-identifier", this.pluginIdentifier);
        }
        if (this.application != null) {
            element.setAttribute("application", this.application);
        }
        if (this.url != null) {
            element.setAttribute("url", Utils.makeRelative(uRL, this.url));
        }
        URL[] uRLArray = this.getFeatureRootURLs();
        int n = 0;
        while (n < uRLArray.length) {
            String string = Utils.makeRelative(uRL, uRLArray[n]).toExternalForm();
            if (string.trim().length() > 0) {
                Element element2 = document.createElement("root");
                element2.appendChild(document.createTextNode(string));
                element.appendChild(element2);
            }
            ++n;
        }
        return element;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Bundle[] getBundles() {
        if (this.plugins == null) {
            this.fullParse();
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(this.plugins.size());
        int n = 0;
        while (n < this.plugins.size()) {
            PluginEntry pluginEntry = (PluginEntry)this.plugins.get(n);
            Bundle bundle = Utils.getBundle(pluginEntry.getPluginIdentifier());
            if (bundle != null) {
                arrayList.add(bundle);
            }
            ++n;
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    public String getDescription() {
        if (this.description == null) {
            this.fullParse();
        }
        return this.description;
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getName() {
        if (this.branding == null) {
            this.branding = AboutInfo.readFeatureInfo(this.id, this.version, this.getFeaturePluginIdentifier());
        }
        return this.branding.getProductName();
    }

    public String getProperty(String string) {
        if (string == null) {
            return null;
        }
        if (this.branding == null) {
            this.branding = AboutInfo.readFeatureInfo(this.id, this.version, this.getFeaturePluginIdentifier());
        }
        if (string.equals("featureImage")) {
            return this.branding.getFeatureImageURL() == null ? null : this.branding.getFeatureImageURL().toExternalForm();
        }
        if (string.equals("tipsAndTricksHref")) {
            return this.branding.getTipsAndTricksHref();
        }
        if (string.equals("welcomePage")) {
            return this.branding.getWelcomePageURL() == null ? null : this.branding.getWelcomePageURL().toExternalForm();
        }
        if (string.equals("welcomePerspective")) {
            return this.branding.getWelcomePerspectiveId();
        }
        if (string.equals("appName")) {
            return this.branding.getAppName();
        }
        if (string.equals("aboutText")) {
            return this.branding.getAboutText();
        }
        if (string.equals("aboutImage")) {
            return this.branding.getAboutImageURL() == null ? null : this.branding.getAboutImageURL().toExternalForm();
        }
        if (string.equals("windowImage")) {
            return this.branding.getWindowImageURL() == null ? null : this.branding.getWindowImageURL().toExternalForm();
        }
        if (string.equals("windowImages")) {
            URL[] uRLArray = this.branding.getWindowImagesURLs();
            if (uRLArray == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < uRLArray.length) {
                stringBuffer.append(uRLArray[n].toExternalForm());
                if (n != uRLArray.length - 1) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        if (string.equals("licenseHref")) {
            return this.getLicenseURL();
        }
        return null;
    }

    public String getProviderName() {
        if (this.branding == null) {
            this.branding = AboutInfo.readFeatureInfo(this.id, this.version, this.getFeaturePluginIdentifier());
        }
        return this.branding.getProviderName();
    }

    public String getVersion() {
        return this.version;
    }

    public String getApplication() {
        return this.application;
    }

    public String getId() {
        return this.id;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle != null) {
            return this.resourceBundle;
        }
        if (this.site == null) {
            return null;
        }
        ResourceBundle resourceBundle = null;
        try {
            URL uRL = new URL(this.site.getResolvedURL(), this.getURL());
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
            resourceBundle = ResourceBundle.getBundle("feature", Utils.getDefaultLocale(), uRLClassLoader);
        }
        catch (MissingResourceException missingResourceException) {
            Utils.log(missingResourceException.getLocalizedMessage());
        }
        catch (MalformedURLException malformedURLException) {
            Utils.log(malformedURLException.getLocalizedMessage());
        }
        return resourceBundle;
    }

    public void setLicenseURL(String string) {
        this.licenseURL = string;
    }

    public String getLicenseURL() {
        if (this.licenseURL == null) {
            this.fullParse();
        }
        if (this.licenseURL == null) {
            return null;
        }
        String string = Utils.getResourceString(this.getResourceBundle(), this.licenseURL);
        if (string.startsWith("http://")) {
            return string;
        }
        try {
            return new URL(this.getSite().getResolvedURL(), String.valueOf(this.getURL()) + string).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private void fullParse() {
        if (this.fullyParsed) {
            return;
        }
        this.fullyParsed = true;
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        FullFeatureParser fullFeatureParser = new FullFeatureParser(this);
        fullFeatureParser.parse();
    }

    public Bundle getDefiningBundle() {
        return Utils.getBundle(this.getFeaturePluginIdentifier());
    }

    public boolean hasBranding() {
        String string = this.getFeaturePluginIdentifier();
        return string != null && Utils.getBundle(string) != null;
    }
}

