/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.p3ml.OS;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable;
    static boolean eventsRegistered = false;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        int index = parent.internal_getColumnCount();
        parent.addColumn(this, index);
        this.parent = parent;
        this.createWidget(index);
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        int numColumns = parent.internal_getColumnCount();
        if (index < 0) {
            TableColumn.error(6);
        }
        if (index > numColumns) {
            TableColumn.error(6);
        }
        parent.addColumn(this, index);
        this.parent = parent;
        this.createWidget(index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            TableColumn.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            TableColumn.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            TableColumn.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.getStyle() & 0x4000) != 0) {
            return 16384;
        }
        if ((this.getStyle() & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.getStyle() & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    private int getAlignmentStyle(int style) {
        int nativeStyle = 0;
        if ((style & 0x4000) == 16384) {
            nativeStyle = 1;
        } else if ((style & 0x1000000) == 0x1000000) {
            nativeStyle = 2;
        } else if ((style & 0x20000) == 131072) {
            nativeStyle = 4;
        }
        return nativeStyle;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return 0;
        }
        return com.ibm.ugl.eswt.expanded.OS.TableColumn_GetWidth(this.internal_handle);
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = com.ibm.ugl.eswt.expanded.OS.TableColumn_New(this.parent.internal_handle, index, this.getAlignmentStyle(this.internal_style));
        this.resizable = true;
        if (!eventsRegistered) {
            Display d = this.getDisplay();
            OS.Display_RegisterCallback(d.internal_handle, 19, "org/eclipse/swt/widgets/TableColumn", "tableColumnCallback");
            eventsRegistered = true;
        }
    }

    public void pack() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.TableColumn_Pack(this.internal_handle);
    }

    void internalClear() {
        this.parent = null;
        this.image = null;
        this.releaseHandle();
    }

    void remove() {
        super.releaseWidget();
        this.internalClear();
    }

    void releaseHandle() {
        this.internal_handle = 0;
        this.display = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent.destroyColumn(this);
        this.internalClear();
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            TableColumn.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            TableColumn.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.internal_style &= 0xFEFDBFFF;
        this.internal_style |= alignment & 0x1024000;
        com.ibm.ugl.eswt.expanded.OS.TableColumn_SetAlignment(this.internal_handle, this.getAlignmentStyle(this.internal_style));
    }

    public void setImage(Image image) {
        int index;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            TableColumn.error(5);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
        int imageHandle = image == null ? 0 : image.internal_handle;
        com.ibm.ugl.eswt.expanded.OS.TableColumn_SetImage(this.internal_handle, imageHandle);
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
        com.ibm.ugl.eswt.expanded.OS.TableColumn_SetResizable(this.internal_handle, resizable);
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            TableColumn.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        com.ibm.ugl.eswt.expanded.OS.TableColumn_SetText(this.internal_handle, string);
    }

    public void setWidth(int width) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        com.ibm.ugl.eswt.expanded.OS.TableColumn_SetWidth(this.internal_handle, width);
    }

    private void tableColumnCallback(int colIndex, int detail, int type) {
        Event event = new Event();
        if (this.getParent().isList()) {
            return;
        }
        event.item = colIndex != -1 ? this.getParent().columns[colIndex] : null;
        switch (type) {
            case 1: {
                this.sendEvent(13, event);
                break;
            }
            case 2: {
                this.sendEvent(14, event);
                break;
            }
            case 3: {
                this.sendEvent(10, event);
                break;
            }
            case 4: {
                this.sendEvent(11, event);
            }
        }
    }
}

