/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.Assert;

public class PreferenceManager {
    public static final int PRE_ORDER = 0;
    public static final int POST_ORDER = 1;
    PreferenceNode root = new PreferenceNode("");
    String separator = ".";

    protected IPreferenceNode getRoot() {
        return this.root;
    }

    public void addToRoot(IPreferenceNode iPreferenceNode) {
        Assert.isNotNull(iPreferenceNode);
        this.root.add(iPreferenceNode);
    }

    public boolean addTo(String string, IPreferenceNode iPreferenceNode) {
        IPreferenceNode iPreferenceNode2 = this.find(string);
        if (iPreferenceNode2 == null) {
            return false;
        }
        iPreferenceNode2.add(iPreferenceNode);
        return true;
    }

    public boolean remove(IPreferenceNode iPreferenceNode) {
        Assert.isNotNull(iPreferenceNode);
        return this.root.remove(iPreferenceNode);
    }

    public void removeAll() {
        this.root = new PreferenceNode("");
    }

    protected void buildSequence(IPreferenceNode iPreferenceNode, List list, int n) {
        if (n == 0) {
            list.add(iPreferenceNode);
        }
        IPreferenceNode[] iPreferenceNodeArray = iPreferenceNode.getSubNodes();
        int n2 = 0;
        while (n2 < iPreferenceNodeArray.length) {
            this.buildSequence(iPreferenceNodeArray[n2], list, n);
            ++n2;
        }
        if (n == 1) {
            list.add(iPreferenceNode);
        }
    }

    public List getElements(int n) {
        Assert.isTrue(n == 0 || n == 1, "invalid traversal order");
        ArrayList arrayList = new ArrayList();
        IPreferenceNode[] iPreferenceNodeArray = this.getRoot().getSubNodes();
        int n2 = 0;
        while (n2 < iPreferenceNodeArray.length) {
            this.buildSequence(iPreferenceNodeArray[n2], arrayList, n);
            ++n2;
        }
        return arrayList;
    }

    public List getRootElements() {
        ArrayList<IPreferenceNode> arrayList = new ArrayList<IPreferenceNode>();
        IPreferenceNode[] iPreferenceNodeArray = this.getRoot().getSubNodes();
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            arrayList.add(iPreferenceNodeArray[n]);
            ++n;
        }
        return arrayList;
    }

    public IPreferenceNode find(String string) {
        return this.find(string, this.root);
    }

    protected IPreferenceNode find(String string, IPreferenceNode iPreferenceNode) {
        Assert.isNotNull(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.separator);
        IPreferenceNode iPreferenceNode2 = iPreferenceNode;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((iPreferenceNode2 = iPreferenceNode2.findSubNode(string2)) != null) continue;
            return null;
        }
        if (iPreferenceNode2 == iPreferenceNode) {
            return null;
        }
        return iPreferenceNode2;
    }
}

