/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.FeatureStatus;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationValidator;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.osgi.framework.Bundle;

public class OperationValidator
implements IOperationValidator {
    public IStatus validatePlatformConfigValid() {
        ArrayList arrayList = new ArrayList(1);
        OperationValidator.checkPlatformWasModified(arrayList);
        if (arrayList.size() > 0) {
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessage, arrayList, 4);
        }
        return null;
    }

    public IStatus validatePendingInstall(IFeature iFeature, IFeature iFeature2) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.checkPlatformWasModified(arrayList2);
        OperationValidator.validateInstall(iFeature, iFeature2, arrayList2);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingUnconfig(IFeature iFeature) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.checkPlatformWasModified(arrayList2);
        OperationValidator.validateUnconfigure(iFeature, arrayList2);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingConfig(IFeature iFeature) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.checkPlatformWasModified(arrayList2);
        OperationValidator.validateConfigure(iFeature, arrayList2);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingReplaceVersion(IFeature iFeature, IFeature iFeature2) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.checkPlatformWasModified(arrayList2);
        OperationValidator.validateReplaceVersion(iFeature, iFeature2, arrayList2);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingRevert(IInstallConfiguration iInstallConfiguration) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.checkPlatformWasModified(arrayList2);
        OperationValidator.validateRevert(iInstallConfiguration, arrayList2);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingChanges(IInstallFeatureOperation[] iInstallFeatureOperationArray) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        OperationValidator.checkPlatformWasModified(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.validatePendingConfigChanges(iInstallFeatureOperationArray, arrayList2, arrayList);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingChanges(IConfigFeatureOperation[] iConfigFeatureOperationArray) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        OperationValidator.checkPlatformWasModified(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.validatePendingConfigChanges(iConfigFeatureOperationArray, arrayList2, arrayList);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public IStatus validatePendingChanges(IUnconfigFeatureOperation[] iUnconfigFeatureOperationArray) {
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        OperationValidator.checkPlatformWasModified(arrayList);
        ArrayList arrayList2 = new ArrayList();
        OperationValidator.validatePendingUnconfigChanges(iUnconfigFeatureOperationArray, arrayList2, arrayList);
        return OperationValidator.createCombinedReportStatus(arrayList, arrayList2);
    }

    public RequiredFeaturesResult getRequiredFeatures(IInstallFeatureOperation[] iInstallFeatureOperationArray) {
        RequiredFeaturesResult requiredFeaturesResult = new RequiredFeaturesResult();
        ArrayList arrayList = new ArrayList();
        OperationValidator.validateInitialState(arrayList);
        OperationValidator.checkPlatformWasModified(arrayList);
        ArrayList arrayList2 = new ArrayList();
        Set set = OperationValidator.validatePendingConfigChanges(iInstallFeatureOperationArray, arrayList2, arrayList);
        requiredFeaturesResult.setRequiredFeatures(set);
        requiredFeaturesResult.setStatus(OperationValidator.createCombinedReportStatus(arrayList, arrayList2));
        return requiredFeaturesResult;
    }

    public IStatus validateCurrentState() {
        ArrayList arrayList = new ArrayList();
        OperationValidator.checkPlatformWasModified(arrayList);
        OperationValidator.validateInitialState(arrayList);
        if (arrayList.size() > 0) {
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessage, arrayList, 4);
        }
        return null;
    }

    private static void validateInitialState(ArrayList arrayList) {
        try {
            ArrayList arrayList2 = OperationValidator.computeFeatures();
            OperationValidator.checkConstraints(arrayList2, arrayList);
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
    }

    private static void validateUnconfigure(IFeature iFeature, ArrayList arrayList) {
        try {
            OperationValidator.checkSiteReadOnly(iFeature, arrayList);
            ArrayList arrayList2 = OperationValidator.computeFeatures();
            arrayList2 = OperationValidator.computeFeaturesAfterOperation(arrayList2, null, iFeature);
            OperationValidator.checkConstraints(arrayList2, arrayList);
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
    }

    private static void validateConfigure(IFeature iFeature, ArrayList arrayList) {
        try {
            OperationValidator.checkSiteReadOnly(iFeature, arrayList);
            ArrayList arrayList2 = OperationValidator.computeFeatures();
            OperationValidator.checkOptionalChildConfiguring(iFeature, arrayList);
            OperationValidator.checkForCycles(iFeature, null, arrayList2);
            arrayList2 = OperationValidator.computeFeaturesAfterOperation(arrayList2, iFeature, null);
            OperationValidator.checkConstraints(arrayList2, arrayList);
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
    }

    private static void validateReplaceVersion(IFeature iFeature, IFeature iFeature2, ArrayList arrayList) {
        try {
            OperationValidator.checkSiteReadOnly(iFeature, arrayList);
            ArrayList arrayList2 = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(iFeature, null, arrayList2);
            arrayList2 = OperationValidator.computeFeaturesAfterOperation(arrayList2, iFeature2, iFeature);
            OperationValidator.checkConstraints(arrayList2, arrayList);
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
    }

    private static void validateInstall(IFeature iFeature, IFeature iFeature2, ArrayList arrayList) {
        try {
            OperationValidator.checkSiteReadOnly(iFeature, arrayList);
            ArrayList arrayList2 = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(iFeature2, null, arrayList2);
            arrayList2 = OperationValidator.computeFeaturesAfterOperation(arrayList2, iFeature2, iFeature);
            OperationValidator.checkConstraints(arrayList2, arrayList);
            OperationValidator.checkLicense(iFeature2, arrayList);
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
    }

    private static void validateRevert(IInstallConfiguration iInstallConfiguration, ArrayList arrayList) {
        try {
            ArrayList arrayList2 = OperationValidator.computeFeaturesAfterRevert(iInstallConfiguration);
            OperationValidator.checkConstraints(arrayList2, arrayList);
            OperationValidator.checkRevertConstraints(arrayList2, arrayList);
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
    }

    private static Set validatePendingUnconfigChanges(IFeatureOperation[] iFeatureOperationArray, ArrayList arrayList, ArrayList arrayList2) {
        try {
            IFeature iFeature;
            IFeature iFeature2;
            IFeatureOperation iFeatureOperation;
            ArrayList arrayList3;
            ArrayList arrayList4 = arrayList3 = OperationValidator.computeFeatures();
            ArrayList arrayList5 = new ArrayList();
            int n = 0;
            while (n < iFeatureOperationArray.length) {
                iFeatureOperation = iFeatureOperationArray[n];
                iFeature2 = null;
                iFeature = iFeatureOperation.getFeature();
                arrayList3 = OperationValidator.computeFeaturesAfterOperation(arrayList3, iFeature2, iFeature);
                ++n;
            }
            OperationValidator.checkConstraints(arrayList3, arrayList5);
            if (arrayList5.size() == 0) {
                return Collections.EMPTY_SET;
            }
            arrayList3 = arrayList4;
            n = 0;
            while (n < iFeatureOperationArray.length) {
                iFeatureOperation = iFeatureOperationArray[n];
                iFeature2 = null;
                iFeature = iFeatureOperation.getFeature();
                arrayList3 = OperationValidator.computeFeaturesAfterOperation(arrayList3, iFeature2, iFeature);
                Set set = OperationValidator.checkConstraints(arrayList3, arrayList);
                if (arrayList.size() > 0 && !OperationValidator.isBetterStatus(arrayList2, arrayList)) {
                    return set;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
        return Collections.EMPTY_SET;
    }

    private static Set validatePendingConfigChanges(IFeatureOperation[] iFeatureOperationArray, ArrayList arrayList, ArrayList arrayList2) {
        try {
            IFeature iFeature;
            IFeature iFeature2;
            Object object;
            ArrayList arrayList3;
            ArrayList arrayList4 = arrayList3 = OperationValidator.computeFeatures();
            int n = 0;
            ArrayList arrayList5 = new ArrayList();
            int n2 = 0;
            while (n2 < iFeatureOperationArray.length) {
                object = iFeatureOperationArray[n2];
                iFeature2 = object.getFeature();
                iFeature = object.getOldFeature();
                OperationValidator.checkLicense(iFeature2, arrayList);
                if (iFeatureOperationArray.length > 1 && iFeature2.isExclusive()) {
                    ++n;
                    arrayList.add(OperationValidator.createStatus(iFeature2, 4, Messages.ActivityConstraints_exclusive));
                } else {
                    OperationValidator.checkForCycles(iFeature2, null, arrayList3);
                    arrayList3 = OperationValidator.computeFeaturesAfterOperation(arrayList3, iFeature2, iFeature);
                }
                ++n2;
            }
            if (n > 0) {
                return Collections.EMPTY_SET;
            }
            n2 = 0;
            while (n2 < iFeatureOperationArray.length) {
                object = iFeatureOperationArray[n2].getFeature();
                OperationValidator.checkOptionalChildConfiguring((IFeature)object, arrayList3, arrayList);
                if (arrayList.size() > 0) {
                    return Collections.EMPTY_SET;
                }
                ++n2;
            }
            OperationValidator.checkConstraints(arrayList3, arrayList5);
            if (arrayList5.size() == 0) {
                return Collections.EMPTY_SET;
            }
            arrayList3 = arrayList4;
            n2 = 0;
            while (n2 < iFeatureOperationArray.length) {
                object = iFeatureOperationArray[n2];
                iFeature2 = object.getFeature();
                iFeature = object.getOldFeature();
                arrayList3 = OperationValidator.computeFeaturesAfterOperation(arrayList3, iFeature2, iFeature);
                Set set = OperationValidator.checkConstraints(arrayList3, arrayList);
                if (arrayList.size() > 0 && !OperationValidator.isBetterStatus(arrayList2, arrayList)) {
                    return set;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            arrayList.add(coreException.getStatus());
        }
        return Collections.EMPTY_SET;
    }

    private static void checkPlatformWasModified(ArrayList arrayList) {
        try {
            IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
            long l = iPlatformConfiguration.getChangeStamp();
            if (iPlatformConfiguration instanceof PlatformConfiguration) {
                l = ((PlatformConfiguration)iPlatformConfiguration).getConfiguration().lastModified();
            }
            URL uRL = iPlatformConfiguration.getConfigurationLocation();
            long l2 = l;
            if ("file".equals(uRL.getProtocol())) {
                l2 = new File(uRL.getFile()).lastModified();
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                l2 = uRLConnection.getLastModified();
            }
            if (l != l2) {
                arrayList.add(OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_platformModified));
            }
        }
        catch (IOException iOException) {}
    }

    private static void checkSiteReadOnly(IFeature iFeature, ArrayList arrayList) {
        if (iFeature == null) {
            return;
        }
        IConfiguredSite iConfiguredSite = iFeature.getSite().getCurrentConfiguredSite();
        if (iConfiguredSite != null && !iConfiguredSite.isUpdatable()) {
            arrayList.add(OperationValidator.createStatus(iFeature, 0, NLS.bind((String)Messages.ActivityConstraints_readOnly, (Object[])new String[]{iConfiguredSite.getSite().getURL().toExternalForm()})));
        }
    }

    private static ArrayList computeFeatures() throws CoreException {
        return OperationValidator.computeFeatures(true);
    }

    private static ArrayList computeFeatures(boolean bl) throws CoreException {
        ArrayList<IFeature> arrayList = new ArrayList<IFeature>();
        ILocalSite iLocalSite = SiteManager.getLocalSite();
        IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            IFeatureReference[] iFeatureReferenceArray = bl ? iConfiguredSite.getConfiguredFeatures() : iConfiguredSite.getSite().getFeatureReferences();
            int n2 = 0;
            while (n2 < iFeatureReferenceArray.length) {
                IFeatureReference iFeatureReference = iFeatureReferenceArray[n2];
                IFeature iFeature = iFeatureReference.getFeature(null);
                arrayList.add(iFeature);
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public static ArrayList computeFeatureSubtree(IFeature iFeature, IFeature iFeature2, ArrayList arrayList, boolean bl, ArrayList arrayList2, ArrayList arrayList3) throws CoreException {
        if (iFeature == null) {
            return arrayList;
        }
        if (iFeature2 == null) {
            iFeature2 = iFeature;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (arrayList3 == null) {
            arrayList3 = new ArrayList<IFeature>();
        }
        if (arrayList3.contains(iFeature2)) {
            IStatus iStatus = OperationValidator.createStatus(iFeature, 8, Messages.ActivityConstraints_cycle);
            throw new CoreException(iStatus);
        }
        arrayList3.add(iFeature2);
        if (!arrayList.contains(iFeature2)) {
            arrayList.add(iFeature2);
        }
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature2.getIncludedFeatureReferences();
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            block9: {
                try {
                    IFeature iFeature3 = UpdateUtils.getIncludedFeature(iFeature2, iIncludedFeatureReferenceArray[n]);
                    arrayList = OperationValidator.computeFeatureSubtree(iFeature, iFeature3, arrayList, bl, null, arrayList3);
                }
                catch (CoreException coreException) {
                    if (iIncludedFeatureReferenceArray[n].isOptional() || bl) break block9;
                    throw coreException;
                }
            }
            ++n;
        }
        arrayList3.remove(iFeature2);
        return arrayList;
    }

    private static void checkLicense(IFeature iFeature, ArrayList arrayList) {
        String string;
        IURLEntry iURLEntry = iFeature.getLicense();
        if (iURLEntry != null && (string = iURLEntry.getAnnotation()) != null && string.trim().length() > 0) {
            return;
        }
        arrayList.add(OperationValidator.createStatus(iFeature, 0, Messages.ActivityConstraints_noLicense));
    }

    private static ArrayList computeFeaturesAfterOperation(ArrayList arrayList, IFeature iFeature, IFeature iFeature2) throws CoreException {
        ArrayList arrayList2 = OperationValidator.computeFeatureSubtree(iFeature, null, null, false, arrayList, null);
        ArrayList arrayList3 = OperationValidator.computeFeatureSubtree(iFeature2, null, null, true, null, null);
        if (iFeature2 != null) {
            OperationValidator.contributePatchesFor(arrayList3, arrayList, arrayList3);
        }
        if (iFeature2 != null) {
            arrayList.removeAll(arrayList3);
        }
        if (iFeature != null) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static void contributePatchesFor(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws CoreException {
        int n = 0;
        while (n < arrayList.size()) {
            IFeature iFeature = (IFeature)arrayList.get(n);
            OperationValidator.contributePatchesFor(iFeature, arrayList2, arrayList3);
            ++n;
        }
    }

    private static void contributePatchesFor(IFeature iFeature, ArrayList arrayList, ArrayList arrayList2) throws CoreException {
        int n = 0;
        while (n < arrayList.size()) {
            IFeature iFeature2 = (IFeature)arrayList.get(n);
            if (UpdateUtils.isPatch(iFeature, iFeature2)) {
                ArrayList arrayList3 = OperationValidator.computeFeatureSubtree(iFeature2, null, null, true, null, null);
                arrayList2.addAll(arrayList3);
            }
            ++n;
        }
    }

    private static ArrayList computeFeaturesAfterRevert(IInstallConfiguration iInstallConfiguration) throws CoreException {
        ArrayList<IFeature> arrayList = new ArrayList<IFeature>();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getConfiguredFeatures();
            int n2 = 0;
            while (n2 < iFeatureReferenceArray.length) {
                arrayList.add(iFeatureReferenceArray[n2].getFeature(null));
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static ArrayList computePluginsForFeatures(ArrayList arrayList) throws CoreException {
        if (arrayList == null) {
            return new ArrayList();
        }
        HashMap<VersionedIdentifier, IPluginEntry> hashMap = new HashMap<VersionedIdentifier, IPluginEntry>();
        int n = 0;
        while (n < arrayList.size()) {
            IFeature iFeature = (IFeature)arrayList.get(n);
            IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
            int n2 = 0;
            while (n2 < iPluginEntryArray.length) {
                IPluginEntry iPluginEntry = iPluginEntryArray[n2];
                hashMap.put(iPluginEntry.getVersionedIdentifier(), iPluginEntry);
                ++n2;
            }
            ++n;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(hashMap.values());
        return arrayList2;
    }

    private static void checkForCycles(IFeature iFeature, ArrayList arrayList, ArrayList arrayList2) throws CoreException {
        if (iFeature == null) {
            return;
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<IFeature>();
        }
        if (arrayList.contains(iFeature)) {
            String string = NLS.bind((String)Messages.ActivityConstraints_cycle, (Object[])new String[]{iFeature.getLabel(), iFeature.getVersionedIdentifier().toString()});
            IStatus iStatus = OperationValidator.createStatus(iFeature, 8, string);
            throw new CoreException(iStatus);
        }
        arrayList.add(iFeature);
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            block7: {
                try {
                    IFeature iFeature2 = UpdateUtils.getIncludedFeature(iFeature, iIncludedFeatureReferenceArray[n]);
                    OperationValidator.checkForCycles(iFeature2, arrayList, arrayList2);
                }
                catch (CoreException coreException) {
                    if (iIncludedFeatureReferenceArray[n].isOptional()) break block7;
                    throw coreException;
                }
            }
            ++n;
        }
        arrayList.remove(iFeature);
    }

    private static Set checkConstraints(ArrayList arrayList, ArrayList arrayList2) throws CoreException {
        if (arrayList == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList arrayList3 = OperationValidator.computePluginsForFeatures(arrayList);
        OperationValidator.checkEnvironment(arrayList, arrayList2);
        OperationValidator.checkPlatformFeature(arrayList, arrayList3, arrayList2);
        OperationValidator.checkPrimaryFeature(arrayList, arrayList3, arrayList2);
        return OperationValidator.checkPrereqs(arrayList, arrayList3, arrayList2);
    }

    private static void checkEnvironment(ArrayList arrayList, ArrayList arrayList2) {
        String string = Platform.getOS().toLowerCase();
        String string2 = Platform.getWS().toLowerCase();
        String string3 = Platform.getOSArch().toLowerCase();
        int n = 0;
        while (n < arrayList.size()) {
            IStatus iStatus;
            IFeature iFeature = (IFeature)arrayList.get(n);
            String string4 = iFeature.getOS();
            ArrayList arrayList3 = OperationValidator.createList(string4 != null ? string4.toLowerCase() : null);
            String string5 = iFeature.getWS();
            ArrayList arrayList4 = OperationValidator.createList(string5 != null ? string5.toLowerCase() : null);
            String string6 = iFeature.getOSArch();
            ArrayList arrayList5 = OperationValidator.createList(string6 != null ? string6.toLowerCase() : null);
            if (arrayList3.size() > 0 && !arrayList3.contains(string)) {
                iStatus = OperationValidator.createStatus(iFeature, 32, Messages.ActivityConstraints_os);
                if (!arrayList2.contains(iStatus)) {
                    arrayList2.add(iStatus);
                }
            } else if (arrayList4.size() > 0 && !arrayList4.contains(string2)) {
                iStatus = OperationValidator.createStatus(iFeature, 32, Messages.ActivityConstraints_ws);
                if (!arrayList2.contains(iStatus)) {
                    arrayList2.add(iStatus);
                }
            } else if (arrayList5.size() > 0 && !arrayList5.contains(string3) && !arrayList2.contains(iStatus = OperationValidator.createStatus(iFeature, 32, Messages.ActivityConstraints_arch))) {
                arrayList2.add(iStatus);
            }
            ++n;
        }
    }

    private static void checkPlatformFeature(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        IStatus iStatus;
        IProduct iProduct = Platform.getProduct();
        if (iProduct == null) {
            return;
        }
        Bundle bundle = iProduct.getDefiningBundle();
        boolean bl = false;
        int n = 0;
        while (n < arrayList2.size()) {
            IPluginEntry iPluginEntry = (IPluginEntry)arrayList2.get(n);
            if (bundle.getSymbolicName().equals(iPluginEntry.getVersionedIdentifier().getIdentifier())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && !arrayList3.contains(iStatus = OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_platform))) {
            arrayList3.add(iStatus);
        }
    }

    private static void checkPrimaryFeature(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        String string = ConfiguratorUtils.getCurrentPlatformConfiguration().getPrimaryFeatureIdentifier();
        if (string != null) {
            int n = 0;
            while (n < arrayList.size()) {
                IFeature iFeature = (IFeature)arrayList.get(n);
                if (string.equals(iFeature.getVersionedIdentifier().getIdentifier())) {
                    return;
                }
                ++n;
            }
            IStatus iStatus = OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_primary);
            if (!arrayList3.contains(iStatus)) {
                arrayList3.add(iStatus);
            }
        } else {
            IProduct iProduct = Platform.getProduct();
            if (iProduct == null) {
                return;
            }
            Bundle bundle = iProduct.getDefiningBundle();
            int n = 0;
            while (n < arrayList2.size()) {
                IPluginEntry iPluginEntry = (IPluginEntry)arrayList2.get(n);
                if (bundle.getSymbolicName().equals(iPluginEntry.getVersionedIdentifier().getIdentifier())) {
                    return;
                }
                ++n;
            }
            IStatus iStatus = OperationValidator.createStatus(null, 0, Messages.ActivityConstraints_primary);
            if (!arrayList3.contains(iStatus)) {
                arrayList3.add(iStatus);
            }
        }
    }

    private static Set checkPrereqs(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        HashSet<InternalImport> hashSet = new HashSet<InternalImport>();
        int n = 0;
        while (n < arrayList.size()) {
            IFeature iFeature = (IFeature)arrayList.get(n);
            IImport[] iImportArray = iFeature.getImports();
            int n2 = 0;
            while (n2 < iImportArray.length) {
                Object object;
                IImport iImport = iImportArray[n2];
                VersionedIdentifier versionedIdentifier = iImport.getVersionedIdentifier();
                String string = versionedIdentifier.getIdentifier();
                PluginVersionIdentifier pluginVersionIdentifier = versionedIdentifier.getVersion();
                boolean bl = iImport.getKind() == 1;
                boolean bl2 = pluginVersionIdentifier.getMajorComponent() == 0 && pluginVersionIdentifier.getMinorComponent() == 0 && pluginVersionIdentifier.getServiceComponent() == 0;
                int n3 = iImport.getRule();
                if (n3 == 0) {
                    n3 = 3;
                }
                boolean bl3 = false;
                ArrayList arrayList4 = bl ? arrayList : arrayList2;
                int n4 = 0;
                while (n4 < arrayList4.size()) {
                    block25: {
                        VersionedIdentifier versionedIdentifier2;
                        block26: {
                            block24: {
                                if (!bl) break block24;
                                object = (IFeature)arrayList4.get(n4);
                                if (iFeature.equals(object)) break block25;
                                versionedIdentifier2 = object.getVersionedIdentifier();
                                break block26;
                            }
                            object = (IPluginEntry)arrayList4.get(n4);
                            versionedIdentifier2 = object.getVersionedIdentifier();
                        }
                        object = versionedIdentifier2.getVersion();
                        if (string.equals(versionedIdentifier2.getIdentifier())) {
                            if (bl2) {
                                bl3 = true;
                            } else if (n3 == 1 && object.isPerfect(pluginVersionIdentifier)) {
                                bl3 = true;
                            } else if (n3 == 2 && object.isEquivalentTo(pluginVersionIdentifier)) {
                                bl3 = true;
                            } else if (n3 == 3 && object.isCompatibleWith(pluginVersionIdentifier)) {
                                bl3 = true;
                            } else if (n3 == 4 && object.isGreaterOrEqualTo(pluginVersionIdentifier)) {
                                bl3 = true;
                            }
                        }
                        if (bl3) break;
                    }
                    ++n4;
                }
                if (!bl3) {
                    String string2 = bl ? Messages.ActivityConstaints_prereq_feature : Messages.ActivityConstaints_prereq_plugin;
                    int n5 = bl ? 1 : 2;
                    object = NLS.bind((String)Messages.ActivityConstraints_prereq, (Object[])new String[]{string2, string});
                    if (!bl2) {
                        if (n3 == 1) {
                            object = NLS.bind((String)Messages.ActivityConstraints_prereqPerfect, (Object[])new String[]{string2, string, pluginVersionIdentifier.toString()});
                        } else if (n3 == 2) {
                            object = NLS.bind((String)Messages.ActivityConstraints_prereqEquivalent, (Object[])new String[]{string2, string, pluginVersionIdentifier.toString()});
                        } else if (n3 == 3) {
                            object = NLS.bind((String)Messages.ActivityConstraints_prereqCompatible, (Object[])new String[]{string2, string, pluginVersionIdentifier.toString()});
                        } else if (n3 == 4) {
                            object = NLS.bind((String)Messages.ActivityConstraints_prereqGreaterOrEqual, (Object[])new String[]{string2, string, pluginVersionIdentifier.toString()});
                        }
                    }
                    IStatus iStatus = OperationValidator.createStatus(iFeature, n5, (String)object);
                    hashSet.add(new InternalImport(iImport));
                    if (!arrayList3.contains(iStatus)) {
                        arrayList3.add(iStatus);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return hashSet;
    }

    private static void checkRevertConstraints(ArrayList arrayList, ArrayList arrayList2) {
        int n = 0;
        while (n < arrayList.size()) {
            IFeature iFeature = (IFeature)arrayList.get(n);
            try {
                OperationValidator.computeFeatureSubtree(iFeature, null, null, false, null, null);
            }
            catch (CoreException coreException) {
                arrayList2.add(coreException.getStatus());
            }
            ++n;
        }
    }

    private static void checkOptionalChildConfiguring(IFeature iFeature, ArrayList arrayList) throws CoreException {
        ILocalSite iLocalSite = SiteManager.getLocalSite();
        IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        boolean bl = false;
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            ISiteFeatureReference[] iSiteFeatureReferenceArray = iConfiguredSite.getSite().getFeatureReferences();
            int n2 = 0;
            while (n2 < iSiteFeatureReferenceArray.length) {
                ISiteFeatureReference iSiteFeatureReference = iSiteFeatureReferenceArray[n2];
                IFeature iFeature2 = null;
                iFeature2 = iSiteFeatureReference.getFeature(null);
                if (OperationValidator.isParent(iFeature2, iFeature, true)) {
                    bl = true;
                    if (iConfiguredSite.isConfigured(iFeature2)) {
                        return;
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            String string = Messages.ActivityConstraints_optionalChild;
            arrayList.add(OperationValidator.createStatus(iFeature, 16, string));
        }
    }

    private static void checkOptionalChildConfiguring(IFeature iFeature, ArrayList arrayList, ArrayList arrayList2) throws CoreException {
        boolean bl = false;
        ILocalSite iLocalSite = SiteManager.getLocalSite();
        IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            ISiteFeatureReference[] iSiteFeatureReferenceArray = iConfiguredSite.getSite().getFeatureReferences();
            int n2 = 0;
            while (n2 < iSiteFeatureReferenceArray.length) {
                ISiteFeatureReference iSiteFeatureReference = iSiteFeatureReferenceArray[n2];
                IFeature iFeature2 = iSiteFeatureReference.getFeature(null);
                boolean bl2 = OperationValidator.isParent(iFeature2, iFeature, false);
                if (bl2) {
                    bl = true;
                    int n3 = 0;
                    while (n3 < arrayList.size()) {
                        IFeature iFeature3 = (IFeature)arrayList.get(n3);
                        if (iFeature3.equals(iFeature2)) {
                            return;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            String string = Messages.ActivityConstraints_optionalChild;
            arrayList2.add(OperationValidator.createStatus(iFeature, 16, string));
        }
    }

    private static boolean isParent(IFeature iFeature, IFeature iFeature2, boolean bl) throws CoreException {
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            PluginVersionIdentifier pluginVersionIdentifier;
            PluginVersionIdentifier pluginVersionIdentifier2;
            IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
            VersionedIdentifier versionedIdentifier = iFeature2.getVersionedIdentifier();
            VersionedIdentifier versionedIdentifier2 = iIncludedFeatureReference.getVersionedIdentifier();
            if (versionedIdentifier.getIdentifier().equals(versionedIdentifier2.getIdentifier()) && (pluginVersionIdentifier2 = versionedIdentifier.getVersion()).equals((Object)(pluginVersionIdentifier = versionedIdentifier2.getVersion()))) {
                return !bl || iIncludedFeatureReference.isOptional();
            }
            ++n;
        }
        return false;
    }

    private static IStatus createMultiStatus(String string, ArrayList arrayList, int n) {
        IStatus[] iStatusArray = arrayList.toArray(new IStatus[arrayList.size()]);
        return new MultiStatus(UpdateCore.getPlugin().getBundle().getSymbolicName(), n, iStatusArray, string, null);
    }

    private static IStatus createStatus(IFeature iFeature, int n, String string) {
        String string2;
        if (iFeature == null) {
            string2 = string;
        } else {
            PluginVersionIdentifier pluginVersionIdentifier = iFeature.getVersionedIdentifier().getVersion();
            string2 = NLS.bind((String)Messages.ActivityConstraints_childMessage, (Object[])new String[]{iFeature.getLabel(), pluginVersionIdentifier.toString(), string});
        }
        return new FeatureStatus(iFeature, 4, UpdateCore.getPlugin().getBundle().getSymbolicName(), n, string2, null);
    }

    private static IStatus createCombinedReportStatus(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() == 0) {
            if (arrayList2.size() == 0) {
                return null;
            }
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessage, arrayList2, 4);
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        if (OperationValidator.isBetterStatus(arrayList, arrayList2)) {
            return OperationValidator.createMultiStatus(Messages.ActivityConstraints_warning, arrayList, 2);
        }
        ArrayList<IStatus> arrayList3 = new ArrayList<IStatus>();
        arrayList3.add(OperationValidator.createMultiStatus(Messages.ActivityConstraints_beforeMessage, arrayList, 4));
        arrayList3.add(OperationValidator.createMultiStatus(Messages.ActivityConstraints_afterMessage, arrayList2, 4));
        return OperationValidator.createMultiStatus(Messages.ActivityConstraints_rootMessageInitial, arrayList3, 4);
    }

    private static ArrayList createList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("")) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static boolean isBetterStatus(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2 == null || arrayList2.size() == 0) {
            return true;
        }
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        if (arrayList.size() < arrayList2.size()) {
            return false;
        }
        int n = 0;
        while (n < arrayList2.size()) {
            IStatus iStatus = (IStatus)arrayList2.get(n);
            if (!(iStatus instanceof FeatureStatus)) {
                return false;
            }
            FeatureStatus featureStatus = (FeatureStatus)iStatus;
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < arrayList.size()) {
                if (featureStatus.equals(arrayList.get(n2))) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public class RequiredFeaturesResult {
        private IStatus status;
        private Set requiredFeatures;

        public Set getRequiredFeatures() {
            return this.requiredFeatures;
        }

        public void setRequiredFeatures(Set set) {
            this.requiredFeatures = set;
        }

        public void addRequiredFeatures(Set hashSet) {
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            this.requiredFeatures.addAll(hashSet);
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus iStatus) {
            this.status = iStatus;
        }
    }

    public static class InternalImport {
        private IImport iimport;

        public InternalImport(IImport iImport) {
            this.iimport = iImport;
        }

        public IImport getImport() {
            return this.iimport;
        }

        public void setImport(IImport iImport) {
            this.iimport = iImport;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InternalImport)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return this.iimport.getVersionedIdentifier().equals(((InternalImport)object).getImport().getVersionedIdentifier()) && this.getImport().getRule() == ((InternalImport)object).getImport().getRule();
        }

        public int hashCode() {
            return this.iimport.getVersionedIdentifier().hashCode() * this.iimport.getRule();
        }
    }
}

