/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.osgi.framework.Bundle;

public class Log
implements ILog {
    Bundle bundle;
    Set logListeners = new HashSet(5);

    public Log(Bundle bundle) {
        this.bundle = bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(ILogListener iLogListener) {
        Set set = this.logListeners;
        synchronized (set) {
            this.logListeners.add(iLogListener);
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(final IStatus iStatus) {
        ILogListener[] iLogListenerArray;
        InternalPlatform.getDefault().log(iStatus);
        Set set = this.logListeners;
        synchronized (set) {
            iLogListenerArray = this.logListeners.toArray(new ILogListener[this.logListeners.size()]);
        }
        int n = 0;
        while (n < iLogListenerArray.length) {
            final ILogListener iLogListener = iLogListenerArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    iLogListener.logging(iStatus, Log.this.bundle.getSymbolicName());
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(ILogListener iLogListener) {
        Set set = this.logListeners;
        synchronized (set) {
            this.logListeners.remove(iLogListener);
        }
    }
}

