/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.core.connection.HttpResponse;
import org.eclipse.update.internal.core.connection.IResponse;

public class ContentReference {
    public static final long UNKNOWN_SIZE = -1L;
    public static final int DEFAULT_EXECUTABLE_PERMISSION = -1;
    private static final String FILE_URL_PROTOCOL = "file";
    private String id;
    private URL url;
    private File file;
    private IResponse response;
    private int permission;
    private long length;
    private boolean tempLocal = false;
    private long lastModified;

    private ContentReference() {
    }

    public ContentReference(String string, URL uRL) {
        this.id = string == null ? "" : string;
        this.url = uRL;
        this.file = null;
    }

    public ContentReference(String string, File file) {
        this.id = string == null ? "" : string;
        this.file = file;
        this.url = null;
    }

    public ContentReference createContentReference(String string, File file) {
        return new ContentReference(string, file, true);
    }

    private ContentReference(String string, File file, boolean bl) {
        this(string, file);
        this.setTempLocal(bl);
    }

    public String getIdentifier() {
        return this.id;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.url != null) {
            Object object;
            if (this.response == null) {
                object = URLEncoder.encode(this.url);
                this.response = ConnectionFactory.get((URL)object);
                UpdateManagerUtils.checkConnectionResult(this.response, (URL)object);
            }
            object = this.response.getInputStream();
            this.length = this.response.getContentLength();
            return object;
        }
        throw new IOException(NLS.bind((String)Messages.ContentReference_UnableToCreateInputStream, (Object[])new String[]{this.toString()}));
    }

    InputStream getPartialInputStream(long l) throws IOException {
        if (this.url != null && "http".equals(this.url.getProtocol())) {
            URL uRL = URLEncoder.encode(this.url);
            this.response = ConnectionFactory.get(uRL);
            if (this.response instanceof HttpResponse) {
                ((HttpResponse)this.response).setOffset(l);
            }
            UpdateManagerUtils.checkConnectionResult(this.response, uRL);
            InputStream inputStream = this.response.getInputStream();
            this.length = l + this.response.getContentLength();
            return inputStream;
        }
        throw new IOException(NLS.bind((String)Messages.ContentReference_UnableToCreateInputStream, (Object[])new String[]{this.toString()}));
    }

    public long getInputSize() throws IOException {
        if (this.length > 0L) {
            return this.length;
        }
        if (this.file != null) {
            return this.file.length();
        }
        if (this.url != null) {
            long l;
            if (this.response == null) {
                URL uRL = null;
                try {
                    uRL = URLEncoder.encode(this.url);
                    this.response = ConnectionFactory.get(uRL);
                }
                catch (IOException iOException) {
                    return -1L;
                }
                UpdateManagerUtils.checkConnectionResult(this.response, uRL);
            }
            return (l = this.response.getContentLength()) == -1L ? -1L : l;
        }
        return -1L;
    }

    public boolean isLocalReference() {
        return this.tempLocal;
    }

    public File asFile() throws IOException {
        if (this.file != null) {
            return this.file;
        }
        if (this.url != null && FILE_URL_PROTOCOL.equals(this.url.getProtocol())) {
            File file = new File(this.url.getFile());
            if (file.exists()) {
                return file;
            }
            throw new IOException(NLS.bind((String)Messages.ContentReference_FileDoesNotExist, (Object[])new String[]{this.toString()}));
        }
        throw new IOException(NLS.bind((String)Messages.ContentReference_UnableToReturnReferenceAsFile, (Object[])new String[]{this.toString()}));
    }

    public URL asURL() throws IOException {
        if (this.url != null) {
            return this.url;
        }
        if (this.file != null) {
            return this.file.toURL();
        }
        throw new IOException(NLS.bind((String)Messages.ContentReference_UnableToReturnReferenceAsURL, (Object[])new String[]{this.toString()}));
    }

    public String toString() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return this.url.toExternalForm();
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int n) {
        this.permission = n;
    }

    protected void setTempLocal(boolean bl) {
        this.tempLocal = bl;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            if (this.file != null) {
                this.lastModified = this.file.lastModified();
            } else if (this.url != null) {
                if (this.response == null) {
                    try {
                        URL uRL = URLEncoder.encode(this.url);
                        this.response = ConnectionFactory.get(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (IOException iOException) {}
                }
                this.lastModified = this.response.getLastModified();
            }
        }
        return this.lastModified;
    }
}

