/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.layout.CellData;

class CellLayoutUtil {
    private static Point zero = new Point(0, 0);
    private static Point minimumShellSize;
    private static CellData defaultData;

    static {
        defaultData = new CellData();
    }

    CellLayoutUtil() {
    }

    static Point computeMinimumSize(Composite composite) {
        if (composite instanceof Shell) {
            if (minimumShellSize == null) {
                Shell shell = new Shell((Shell)composite, 2160);
                shell.setSize(0, 0);
                minimumShellSize = shell.getSize();
                shell.dispose();
            }
            return minimumShellSize;
        }
        return zero;
    }

    static CellData getData(Control control) {
        Object object = control.getLayoutData();
        CellData cellData = null;
        if (object instanceof CellData) {
            cellData = (CellData)object;
        } else if (object instanceof GridData) {
            cellData = new CellData((GridData)object);
        }
        if (cellData == null) {
            cellData = defaultData;
        }
        return cellData;
    }
}

