/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.launcher.Main;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected URL installLocation = null;
    protected URL configurationLocation = null;
    protected String parentConfigurationLocation = null;
    protected String framework = "org.eclipse.osgi";
    protected String devClassPath = null;
    protected boolean inDevelopmentMode = false;
    private String exitData = null;
    private String name = null;
    private String launcher = null;
    private String vm = null;
    private String[] vmargs = null;
    private String[] commands = null;
    private String[] extensionPaths = null;
    private String showSplash = null;
    private String endSplash = null;
    private boolean initialize = false;
    private Process showProcess = null;
    private boolean splashDown = false;
    private final Thread endSplashHandler = new Thread(){

        public void run() {
            Main.this.takeDownSplash();
        }
    };
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String CONFIGURATION = "-configuration";
    private static final String EXITDATA = "-exitdata";
    private static final String NOSPLASH = "-nosplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String NAME = "-name";
    private static final String LAUNCHER = "-launcher";
    private static final String NL = "-nl";
    private static final String ENDSPLASH = "-endsplash";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String CLEAN = "-clean";
    private static final String NOEXIT = "-noExit";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String FILE_SCHEME = "file:";
    protected static final String REFERENCE_SCHEME = "reference:";
    protected static final String JAR_SCHEME = "jar:";
    private static final String DEFAULT_JRE_REQUIRED = "1.4.1";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    private static final String PROP_BASE_CONFIG_AREA = "osgi.baseConfiguration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    protected static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_SPLASHPATH = "osgi.splashPath";
    private static final String PROP_SPLASHLOCATION = "osgi.splashLocation";
    private static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    private static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_FRAMEWORK_SYSPATH = "osgi.syspath";
    private static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    private static final String PROP_LOGFILE = "osgi.logfile";
    private static final String PROP_REQUIRED_JAVA_VERSION = "osgi.requiredJavaVersion";
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PROP_EOF = "eof";
    private static final String PROP_NL = "osgi.nl";
    private static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_DEBUG = "osgi.debug";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_ECLIPSESECURITY = "eclipse.security";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_BOOT = "boot";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.core.launcher";
    protected File logFile = null;
    protected BufferedWriter log = null;
    protected boolean newSession = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void basicRun(String[] stringArray) throws Exception {
        System.getProperties().setProperty("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        this.commands = stringArray;
        String[] stringArray2 = this.processCommandLine(stringArray);
        if (!this.debug) {
            this.debug = System.getProperty(PROP_DEBUG) != null;
        }
        this.setupVMProperties();
        this.processConfiguration();
        if (!this.checkVersion(System.getProperty("java.version"), System.getProperty(PROP_REQUIRED_JAVA_VERSION, DEFAULT_JRE_REQUIRED))) {
            return;
        }
        this.getInstallLocation();
        URL[] uRLArray = this.getBootPath(this.bootLocation);
        this.setSecurityPolicy(uRLArray);
        this.handleSplash(uRLArray);
        this.invokeFramework(stringArray2, uRLArray);
    }

    protected void setSecurityPolicy(URL[] uRLArray) {
        String string = System.getProperty(PROP_ECLIPSESECURITY);
        if (string != null) {
            Class<?> clazz;
            Object object;
            SecurityManager securityManager = System.getSecurityManager();
            boolean bl = false;
            if (securityManager == null) {
                if (string.length() < 1) {
                    string = "java.lang.SecurityManager";
                }
                try {
                    object = Class.forName(string);
                    securityManager = (SecurityManager)((Class)object).newInstance();
                    bl = true;
                }
                catch (Throwable throwable) {
                    System.getProperties().setProperty("java.security.manager", string);
                }
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.launcher.Main");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = clazz.getProtectionDomain();
            CodeSource codeSource = null;
            if (object != null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.core.launcher.Main");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                codeSource = clazz2.getProtectionDomain().getCodeSource();
            }
            if (object == null || codeSource == null) {
                this.log("Can not automatically set the security manager. Please use a policy file.");
                return;
            }
            URL[] uRLArray2 = new URL[uRLArray.length + 1];
            uRLArray2[0] = codeSource.getLocation();
            System.arraycopy(uRLArray, 0, uRLArray2, 1, uRLArray.length);
            EclipsePolicy eclipsePolicy = new EclipsePolicy(Policy.getPolicy(), uRLArray2);
            Policy.setPolicy(eclipsePolicy);
            if (bl) {
                System.setSecurityManager(securityManager);
            }
        }
    }

    private void invokeFramework(String[] stringArray, URL[] uRLArray) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, Error, Exception, InvocationTargetException {
        ClassLoader classLoader;
        String string = System.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT);
        ClassLoader classLoader2 = null;
        if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(string)) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(string) && (classLoader = ClassLoader.getSystemClassLoader()) != null) {
            classLoader2 = classLoader.getParent();
        }
        classLoader = new StartupClassLoader(uRLArray, classLoader2);
        Class<?> clazz = classLoader.loadClass(STARTER);
        Class[] classArray = new Class[2];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Runnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            method.invoke(clazz, stringArray, this.endSplashHandler);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Exception) {
                throw (Exception)invocationTargetException.getTargetException();
            }
            throw invocationTargetException;
        }
    }

    private boolean checkVersion(String string, String string2) {
        if (string2 == null || string == null) {
            return true;
        }
        try {
            Identifier identifier = new Identifier(string2);
            Identifier identifier2 = new Identifier(string);
            boolean bl = identifier2.isGreaterEqualTo(identifier);
            if (!bl) {
                System.getProperties().put(PROP_EXITCODE, "14");
                System.getProperties().put(PROP_EXITDATA, "Required Java version: " + string2 + ". Available: " + string + '.');
            }
            return bl;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    protected String decode(String string) {
        char c;
        int n;
        Object object;
        Object object2;
        try {
            Object object3;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            object2 = clazz2.getDeclaredMethod("decode", classArray);
            if (string.indexOf(43) >= 0) {
                int n2 = string.length();
                object = new StringBuffer(n2);
                n = 0;
                while (n < n2) {
                    c = string.charAt(n);
                    if (c == '+') {
                        ((StringBuffer)object).append("%2B");
                    } else {
                        ((StringBuffer)object).append(c);
                    }
                    ++n;
                }
                string = ((StringBuffer)object).toString();
            }
            if ((object3 = ((Method)object2).invoke(null, string, "UTF-8")) != null) {
                return (String)object3;
            }
        }
        catch (Exception exception) {}
        boolean bl = false;
        object2 = string.getBytes();
        char c2 = ((byte[])object2).length;
        object = new byte[c2];
        n = 0;
        c = '\u0000';
        while (c < c2) {
            byte by = object2[c];
            if (by == 37) {
                byte by2 = object2[++c];
                byte by3 = object2[++c];
                by = (byte)((this.hexToByte(by2) << 4) + this.hexToByte(by3));
                bl = true;
            }
            object[n++] = by;
            ++c;
        }
        if (!bl) {
            return string;
        }
        try {
            return new String((byte[])object, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String((byte[])object, 0, n);
        }
    }

    protected String[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new String[]{} : vector.toArray(new String[vector.size()]);
    }

    private URL[] getDevPath(URL uRL) throws IOException {
        ArrayList arrayList = new ArrayList(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(uRL, arrayList);
        }
        this.addBaseJars(uRL, arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    URL constructURL(URL uRL, String string) {
        String string2 = uRL.toExternalForm();
        if (string2.endsWith(".jar")) {
            try {
                return new URL(JAR_SCHEME + uRL + "!/" + string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void readFrameworkExtensions(URL uRL, ArrayList arrayList) throws IOException {
        String[] stringArray = this.getArrayFromList(System.getProperties().getProperty(PROP_EXTENSIONS));
        String string = new File(uRL.getFile()).getParent().toString();
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = this.searchFor(stringArray[n], string);
            if (string2 == null) {
                this.log("Could not find extension: " + stringArray[n]);
            } else {
                String[] stringArray2;
                Properties properties;
                URL uRL2;
                block14: {
                    if (this.debug) {
                        System.out.println("Loading extension: " + stringArray[n]);
                    }
                    uRL2 = null;
                    if (this.installLocation.getProtocol().equals("file")) {
                        arrayList2.add(string2);
                        uRL2 = new File(string2).toURL();
                    } else {
                        uRL2 = new URL(this.installLocation.getProtocol(), this.installLocation.getHost(), this.installLocation.getPort(), string2);
                    }
                    properties = null;
                    try {
                        properties = this.loadProperties(this.constructURL(uRL2, ECLIPSE_PROPERTIES));
                    }
                    catch (IOException iOException) {
                        if (!this.debug) break block14;
                        System.out.println("\teclipse.properties not found");
                    }
                }
                String string3 = null;
                if (properties != null) {
                    string3 = properties.getProperty(PROP_CLASSPATH);
                } else {
                    properties = new Properties();
                }
                if (string3 == null || string3.length() == 0) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = "";
                } else {
                    stringArray2 = this.getArrayFromList(string3);
                }
                String[] stringArray4 = stringArray2;
                String string4 = System.getProperty(PROP_CLASSPATH) == null ? "." : "";
                int n2 = 0;
                while (n2 < stringArray4.length) {
                    string4 = String.valueOf(string4) + ", file:" + string2 + stringArray4[n2];
                    ++n2;
                }
                properties.put(PROP_CLASSPATH, string4);
                this.mergeProperties(System.getProperties(), properties);
                if (this.inDevelopmentMode) {
                    this.addDevEntries(uRL2, arrayList);
                }
            }
            ++n;
        }
        this.extensionPaths = arrayList2.toArray(new String[arrayList2.size()]);
    }

    private void addBaseJars(URL uRL, ArrayList arrayList) throws IOException {
        Object[] objectArray;
        File file;
        boolean bl;
        String string = System.getProperty(PROP_CLASSPATH);
        if (string == null) {
            this.readFrameworkExtensions(uRL, arrayList);
            string = System.getProperties().getProperty(PROP_CLASSPATH);
        }
        if (bl = (file = new File(uRL.getFile())).isDirectory()) {
            System.getProperties().setProperty(PROP_FRAMEWORK_SHAPE, "folder");
        } else {
            System.getProperties().setProperty(PROP_FRAMEWORK_SHAPE, "jar");
        }
        String string2 = new File(uRL.getFile()).getParentFile().getAbsolutePath();
        if (Character.isUpperCase(string2.charAt(0))) {
            objectArray = string2.toCharArray();
            objectArray[0] = Character.toLowerCase(objectArray[0]);
            string2 = new String((char[])objectArray);
        }
        System.getProperties().setProperty(PROP_FRAMEWORK_SYSPATH, string2);
        objectArray = this.getArrayFromList(string);
        if (objectArray.length == 0) {
            if (!this.inDevelopmentMode && new File(uRL.getFile()).isDirectory()) {
                throw new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            this.addEntry(uRL, arrayList);
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            char c = objectArray[n];
            try {
                if (c.equals(".")) {
                    this.addEntry(uRL, arrayList);
                }
                URL uRL2 = null;
                uRL2 = c.startsWith(FILE_SCHEME) ? new File(c.substring(5)).toURL() : new URL((String)c);
                this.addEntry(uRL2, arrayList);
            }
            catch (MalformedURLException malformedURLException) {
                this.addEntry(new URL(uRL, (String)c), arrayList);
            }
            ++n;
        }
    }

    protected void addEntry(URL uRL, List list) {
        if (new File(uRL.getFile()).exists()) {
            list.add(uRL);
        }
    }

    private void addDevEntries(URL uRL, List list) throws MalformedURLException {
        String[] stringArray = this.getArrayFromList(this.devClassPath);
        int n = 0;
        while (n < stringArray.length) {
            URL uRL2;
            String string = stringArray[n];
            File file = new File(string);
            if (file.isAbsolute()) {
                uRL2 = file.toURL();
            } else {
                char c = string.charAt(string.length() - 1);
                uRL2 = string.endsWith(".jar") || c == '/' || c == '\\' ? new URL(uRL, string) : new URL(uRL, String.valueOf(string) + "/");
            }
            this.addEntry(uRL2, list);
            ++n;
        }
    }

    protected URL[] getBootPath(String string) throws IOException {
        URL[] uRLArray;
        URL uRL = null;
        if (string != null) {
            uRL = Main.buildURL(string, true);
        } else {
            uRL = this.getInstallLocation();
            uRLArray = new File(uRL.getFile(), "plugins").toString();
            if ((uRLArray = this.searchFor(this.framework, (String)uRLArray)) == null) {
                throw new RuntimeException("Could not find framework");
            }
            uRL = uRL.getProtocol().equals("file") ? new File((String)uRLArray).toURL() : new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)uRLArray);
        }
        if (System.getProperty(PROP_FRAMEWORK) == null) {
            System.getProperties().put(PROP_FRAMEWORK, uRL.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + uRL.toExternalForm());
        }
        uRLArray = this.getDevPath(uRL);
        if (this.debug) {
            System.out.println("Framework classpath:");
            int n = 0;
            while (n < uRLArray.length) {
                System.out.println("    " + uRLArray[n].toExternalForm());
                ++n;
            }
        }
        return uRLArray;
    }

    protected String searchFor(String string, String string2) {
        String[] stringArray;
        String string3 = String.valueOf(string) + '_';
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = new File(string2).listFiles();
        int n = 0;
        while (n < fileArray.length) {
            stringArray = fileArray[n].getName();
            if (stringArray.equals(string) || stringArray.startsWith(string3)) {
                arrayList.add(fileArray[n]);
            }
            ++n;
        }
        File[] fileArray2 = arrayList.toArray(new File[arrayList.size()]);
        if (fileArray2 == null) {
            return null;
        }
        stringArray = new String[fileArray2.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = fileArray2[n2].getName();
            ++n2;
        }
        n2 = this.findMax(stringArray);
        if (n2 == -1) {
            return null;
        }
        return String.valueOf(fileArray2[n2].getAbsolutePath().replace(File.separatorChar, '/')) + (fileArray2[n2].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] stringArray) {
        int n = -1;
        Object[] objectArray = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            String string2 = "";
            int n3 = string.indexOf(95);
            if (n3 != -1) {
                string2 = string.substring(n3 + 1);
            }
            Object[] objectArray2 = this.getVersionElements(string2);
            if (objectArray == null) {
                n = n2;
                objectArray = objectArray2;
            } else if (this.compareVersion(objectArray, objectArray2) < 0) {
                n = n2;
                objectArray = objectArray2;
            }
            ++n2;
        }
        return n;
    }

    private int compareVersion(Object[] objectArray, Object[] objectArray2) {
        int n = ((Integer)objectArray[0]).compareTo((Integer)objectArray2[0]);
        if (n != 0) {
            return n;
        }
        n = ((Integer)objectArray[1]).compareTo((Integer)objectArray2[1]);
        if (n != 0) {
            return n;
        }
        n = ((Integer)objectArray[2]).compareTo((Integer)objectArray2[2]);
        if (n != 0) {
            return n;
        }
        return ((String)objectArray[3]).compareTo((String)objectArray2[3]);
    }

    private Object[] getVersionElements(String string) {
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - 4);
        }
        Object[] objectArray = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 4) {
            String string2 = stringTokenizer.nextToken();
            if (n < 3) {
                try {
                    objectArray[n++] = new Integer(string2);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            objectArray[n++] = string2;
        }
        return objectArray;
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith(FILE_SCHEME);
        try {
            if (bl2) {
                File file = new File(string.substring(5));
                if (file.isDirectory()) {
                    return Main.adjustTrailingSlash(file.toURL(), bl);
                }
                return file.toURL();
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                File file = new File(string);
                if (file.isDirectory()) {
                    return Main.adjustTrailingSlash(file.toURL(), bl);
                }
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        String string = uRL.getFile();
        if (bl == string.endsWith("/")) {
            return uRL;
        }
        string = bl ? String.valueOf(string) + "/" : string.substring(0, string.length() - 1);
        return new URL(uRL.getProtocol(), uRL.getHost(), string);
    }

    /*
     * Exception decompiling
     */
    private URL buildLocation(String var1_1, URL var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 182->185)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String substituteVar(String string, String string2, String string3) {
        String string4 = System.getProperty(string3, "");
        return String.valueOf(string4) + string.substring(string2.length());
    }

    private String computeDefaultConfigurationLocation() {
        File file;
        URL uRL = this.getInstallLocation();
        if (uRL.getProtocol().equals("file") && Main.canWrite(file = new File(uRL.getFile()))) {
            return String.valueOf(file.getAbsolutePath()) + File.separator + CONFIG_DIR;
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    /*
     * Exception decompiling
     */
    private static boolean canWrite(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 56->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String computeDefaultUserAreaLocation(String string) {
        Object object;
        URL uRL = this.getInstallLocation();
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getFile());
        String string2 = ".eclipse";
        File file2 = new File(file, PRODUCT_SITE_MARKER);
        if (file2.exists()) {
            object = new Properties();
            try {
                String string3;
                ((Properties)object).load(new FileInputStream(file2));
                String string4 = ((Properties)object).getProperty(PRODUCT_SITE_ID);
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = ECLIPSE;
                }
                if ((string3 = ((Properties)object).getProperty(PRODUCT_SITE_VERSION)) == null || string3.trim().length() == 0) {
                    string3 = "";
                }
                string2 = String.valueOf(string2) + File.separator + string4 + "_" + string3;
            }
            catch (IOException iOException) {}
        }
        object = System.getProperty(PROP_USER_HOME);
        return new File((String)object, String.valueOf(string2) + "/" + string).getAbsolutePath();
    }

    public static void main(String string) {
        Vector<Object> vector = new Vector<Object>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        Main.main(vector.toArray(new String[vector.size()]));
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 48->52)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] stringArray) {
        int n = 0;
        try {
            try {
                this.basicRun(stringArray);
                String string = System.getProperty(PROP_EXITCODE);
                try {
                    n = string == null ? 0 : Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 17;
                }
            }
            catch (Throwable throwable) {
                if (!"13".equals(System.getProperty(PROP_EXITCODE))) {
                    this.log("Exception launching the Eclipse Platform:");
                    this.log(throwable);
                    String string = "An error has occurred";
                    string = this.logFile == null ? String.valueOf(string) + " and could not be logged: \n" + throwable.getMessage() : String.valueOf(string) + ".  See the log file\n" + this.logFile.getAbsolutePath();
                    System.getProperties().put(PROP_EXITDATA, string);
                }
                n = 13;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.takeDownSplash();
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.takeDownSplash();
            System.getProperties().put(PROP_EXITCODE, Integer.toString(n));
        }
        this.setExitData();
        return n;
    }

    private void setExitData() {
        String string = System.getProperty(PROP_EXITDATA);
        if (this.exitData == null || string == null) {
            return;
        }
        this.runCommand(true, new String[]{EXITDATA, this.exitData, string});
    }

    protected String[] processCommandLine(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            return stringArray;
        }
        int[] nArray = new int[stringArray.length];
        nArray[0] = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            n = 0;
            if (stringArray[n3].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else {
                if (stringArray[n3].equalsIgnoreCase(NOSPLASH)) {
                    this.splashDown = true;
                    n = 1;
                }
                if (stringArray[n3].equalsIgnoreCase(NOEXIT)) {
                    System.getProperties().put(PROP_NOSHUTDOWN, "true");
                    n = 1;
                }
                if (stringArray[n3].equalsIgnoreCase(INITIALIZE)) {
                    this.initialize = true;
                } else if (stringArray[n3].equalsIgnoreCase(DEV) && (n3 + 1 == stringArray.length || n3 + 1 < stringArray.length && stringArray[n3 + 1].startsWith("-"))) {
                    this.inDevelopmentMode = true;
                } else if (n != 0) {
                    nArray[n2++] = n3;
                } else if (stringArray[n3].equalsIgnoreCase(VMARGS)) {
                    stringArray[n3] = null;
                    this.vmargs = new String[stringArray.length - ++n3];
                    int n4 = 0;
                    while (n3 < stringArray.length) {
                        this.vmargs[n4++] = stringArray[n3];
                        stringArray[n3] = null;
                        ++n3;
                    }
                } else if (n3 != stringArray.length - 1 && !stringArray[n3 + 1].startsWith("-")) {
                    String string = stringArray[++n3];
                    if (stringArray[n3 - 1].equalsIgnoreCase(DEV)) {
                        this.inDevelopmentMode = true;
                        this.devClassPath = this.processDevArg(string);
                    } else {
                        if (stringArray[n3 - 1].equalsIgnoreCase(FRAMEWORK)) {
                            this.framework = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(INSTALL)) {
                            System.getProperties().put(PROP_INSTALL_AREA, string);
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(CONFIGURATION)) {
                            System.getProperties().put(PROP_CONFIG_AREA, string);
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(EXITDATA)) {
                            this.exitData = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(SHOWSPLASH)) {
                            this.showSplash = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(NAME)) {
                            this.name = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(LAUNCHER)) {
                            this.launcher = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(ENDSPLASH)) {
                            this.endSplash = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(VM)) {
                            this.vm = string;
                            n = 1;
                        }
                        if (stringArray[n3 - 1].equalsIgnoreCase(NL)) {
                            System.getProperties().put(PROP_NL, string);
                            n = 1;
                        }
                        if (n != 0) {
                            nArray[n2++] = n3 - 1;
                            nArray[n2++] = n3;
                        }
                    }
                }
            }
            ++n3;
        }
        String[] stringArray2 = new String[stringArray.length - n2 - (this.vmargs == null ? 0 : this.vmargs.length + 1)];
        n2 = 0;
        n = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (n5 == nArray[n2]) {
                ++n2;
            } else if (stringArray[n5] != null) {
                stringArray2[n++] = stringArray[n5];
            }
            ++n5;
        }
        return stringArray2;
    }

    private String processDevArg(String string) {
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            Properties properties = this.load(uRL, null);
            String string2 = properties.getProperty(OSGI);
            return string2 == null ? properties.getProperty("*") : string2;
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA, null, "");
        if (this.configurationLocation == null) {
            this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "");
            if (this.configurationLocation == null) {
                this.configurationLocation = Main.buildURL(this.computeDefaultConfigurationLocation(), true);
            }
        }
        if (this.configurationLocation != null) {
            System.getProperties().put(PROP_CONFIG_AREA, this.configurationLocation.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Configuration location:\n    " + this.configurationLocation);
        }
        return this.configurationLocation;
    }

    private void processConfiguration() {
        Object object;
        Object object2;
        URL uRL = null;
        Object object3 = null;
        if (System.getProperty(PROP_CONFIG_AREA) == null) {
            object2 = System.getProperty(PROP_BASE_CONFIG_AREA);
            if (object2 != null) {
                uRL = Main.buildURL((String)object2, true);
            }
            if (uRL == null) {
                try {
                    uRL = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((object3 = this.loadConfiguration(uRL)) != null) {
                object = ((Properties)object3).getProperty(PROP_CONFIG_AREA);
                if (object != null) {
                    System.getProperties().put(PROP_CONFIG_AREA, object);
                }
                if ((object = ((Properties)object3).getProperty(PROP_INSTALL_AREA)) != null && System.getProperty(PROP_INSTALL_AREA) == null) {
                    System.getProperties().put(PROP_INSTALL_AREA, object);
                }
            }
        }
        if ((object2 = object3) == null || !this.getConfigurationLocation().equals(uRL)) {
            object2 = this.loadConfiguration(this.getConfigurationLocation());
        }
        this.mergeProperties(System.getProperties(), (Properties)object2);
        if ("false".equalsIgnoreCase(System.getProperty(PROP_CONFIG_CASCADED))) {
            System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
        } else {
            this.ensureAbsolute(PROP_SHARED_CONFIG_AREA);
            object = this.buildLocation(PROP_SHARED_CONFIG_AREA, null, "");
            if (object == null) {
                try {
                    object = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (object != null) {
                if (((URL)object).equals(this.getConfigurationLocation())) {
                    System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
                } else {
                    object2 = object3;
                    if (!((URL)object).equals(uRL)) {
                        object2 = this.loadConfiguration((URL)object);
                    }
                    this.mergeProperties(System.getProperties(), (Properties)object2);
                    System.getProperties().put(PROP_SHARED_CONFIG_AREA, ((URL)object).toExternalForm());
                    if (this.debug) {
                        System.out.println("Shared configuration location:\n    " + ((URL)object).toExternalForm());
                    }
                }
            }
        }
        object = System.getProperty(PROP_FRAMEWORK, null);
        if (object != null) {
            URL uRL2 = Main.buildURL((String)object, true);
            System.getProperties().put(PROP_FRAMEWORK, uRL2.toExternalForm());
            this.bootLocation = this.resolve((String)object);
        }
    }

    private void ensureAbsolute(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String string3 = uRL.getPath();
        if (string3.startsWith("/")) {
            return;
        }
        URL uRL2 = this.getInstallLocation();
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return;
        }
        try {
            URL uRL3 = new URL(uRL2, string3);
            System.getProperties().put(string, uRL3.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private URL getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        String string = System.getProperty(PROP_INSTALL_AREA);
        if (string != null) {
            this.installLocation = Main.buildURL(string, true);
            if (this.installLocation == null) {
                throw new IllegalStateException("Install location is invalid: " + string);
            }
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
            if (this.debug) {
                System.out.println("Install location:\n    " + this.installLocation);
            }
            return this.installLocation;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.launcher.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = null;
        URL uRL = null;
        if (protectionDomain != null) {
            codeSource = protectionDomain.getCodeSource();
        }
        if (codeSource == null || protectionDomain == null) {
            if (this.debug) {
                System.out.println("CodeSource location is null. Defaulting the install location to file:startup.jar");
            }
            try {
                uRL = new URL("file:startup.jar");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        String string2 = this.decode(uRL.getFile());
        File file = new File(string2);
        string2 = file.toString().replace('\\', '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(string2.charAt(0))) {
            char[] cArray = string2.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            string2 = new String(cArray);
        }
        if (string2.toLowerCase().endsWith(".jar")) {
            string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
        }
        try {
            try {
                string2 = new File(string2).toURL().getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            this.installLocation = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        if (this.debug) {
            System.out.println("Install location:\n    " + this.installLocation);
        }
        return this.installLocation;
    }

    private Properties loadConfiguration(URL uRL) {
        Properties properties;
        block6: {
            properties = null;
            try {
                uRL = new URL(uRL, CONFIG_FILE);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                if (this.debug) {
                    System.out.print("Configuration file:\n    " + uRL.toString());
                }
                properties = this.loadProperties(uRL);
                if (this.debug) {
                    System.out.println(" loaded");
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break block6;
                System.out.println(" not found or not read");
            }
        }
        return properties;
    }

    private Properties loadProperties(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        Properties properties = null;
        IOException iOException = null;
        try {
            properties = this.load(uRL, null);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            try {
                properties = this.load(uRL, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException3) {
                try {
                    properties = this.load(uRL, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException4) {
                    throw iOException;
                }
            }
        }
        return properties;
    }

    /*
     * Exception decompiling
     */
    private Properties load(URL var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 107->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleSplash(URL[] uRLArray) {
        if (this.initialize || this.splashDown) {
            this.showSplash = null;
            this.endSplash = null;
            return;
        }
        if (this.showSplash != null || this.endSplash != null) {
            try {
                Runtime.getRuntime().addShutdownHook(this.endSplashHandler);
            }
            catch (Exception exception) {
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        }
        if (this.endSplash != null) {
            this.showSplash = null;
            return;
        }
        if (this.showSplash == null) {
            return;
        }
        String string = this.getSplashLocation(uRLArray);
        if (this.debug) {
            System.out.println("Splash location:\n    " + string);
        }
        if (string == null) {
            return;
        }
        this.showProcess = this.runCommand(false, new String[]{SHOWSPLASH, this.showSplash, string});
    }

    private Process runCommand(boolean bl, String[] stringArray) {
        String[] stringArray2 = new String[3 + stringArray.length];
        stringArray2[0] = this.launcher;
        stringArray2[1] = NAME;
        stringArray2[2] = this.name;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 3] = stringArray[n];
            ++n;
        }
        if (this.debug) {
            System.out.print("runCommand:\n    ");
            n = 0;
            while (n < stringArray2.length) {
                System.out.print(String.valueOf('<') + stringArray2[n] + '>');
                ++n;
            }
            System.out.println();
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray2);
            if (bl) {
                process.waitFor();
            }
        }
        catch (Exception exception) {
            this.log("Exception running command: " + stringArray != null && stringArray.length > 0 ? stringArray[0] : null);
            this.log(exception);
        }
        return process;
    }

    protected void takeDownSplash() {
        if (this.splashDown) {
            return;
        }
        if (this.endSplash != null) {
            try {
                Runtime.getRuntime().exec(this.endSplash);
            }
            catch (Exception exception) {}
        }
        if (this.showProcess != null) {
            this.showProcess.destroy();
            this.showProcess = null;
        }
        this.splashDown = true;
        try {
            Runtime.getRuntime().removeShutdownHook(this.endSplashHandler);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NoSuchMethodError noSuchMethodError) {}
    }

    private String getSplashLocation(URL[] uRLArray) {
        int n;
        Object object;
        String string = System.getProperty(PROP_SPLASHLOCATION);
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty(PROP_SPLASHPATH);
        if (string2 != null) {
            object = this.getArrayFromList(string2);
            ArrayList<String> arrayList = new ArrayList<String>(((String[])object).length);
            n = 0;
            while (n < ((Object)object).length) {
                String string3 = this.resolve((String)object[n]);
                if (string3 == null || string3.startsWith(FILE_SCHEME)) {
                    File file = new File(string3.substring(5).replace('/', File.separatorChar));
                    if ((string3 = this.searchFor(file.getName(), file.getParent())) != null) {
                        arrayList.add(string3);
                    }
                } else {
                    this.log("Invalid splash path entry: " + (String)object[n]);
                }
                ++n;
            }
            string = this.searchForSplash(arrayList.toArray(new String[arrayList.size()]));
            if (string != null) {
                System.getProperties().put(PROP_SPLASHLOCATION, string);
                return string;
            }
        }
        object = uRLArray[0].getFile();
        int n2 = ((String)(object = ((String)object).replace('/', File.separatorChar))).lastIndexOf("plugins" + File.separator);
        if (n2 != -1 && (n = ((String)object).indexOf(File.separator, n2 + 8)) != -1 && (string = this.searchForSplash(new String[]{object = ((String)object).substring(0, n)})) != null) {
            System.getProperties().put(PROP_SPLASHLOCATION, string);
        }
        return string;
    }

    private String searchForSplash(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String string = (String)System.getProperties().get(PROP_NL);
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        String[] stringArray2 = Main.buildNLVariants(string);
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2;
                if (this.isJAR(stringArray[n2])) {
                    string2 = this.extractSplashFromJAR(stringArray[n2], stringArray2[n]);
                    if (string2 != null) {
                        return string2;
                    }
                } else {
                    File file;
                    string2 = stringArray[n2];
                    if (!string2.endsWith(File.separator)) {
                        string2 = String.valueOf(string2) + File.separator;
                    }
                    if ((file = new File(string2 = String.valueOf(string2) + stringArray2[n])).exists()) {
                        return file.getAbsolutePath();
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void transferStreams(InputStream var0, OutputStream var1_1) {
        var2_2 = new byte[8096];
        try {
            while (true) {
                var3_3 = -1;
                try {
                    var3_3 = var0.read(var2_2);
                    ** GOTO lbl11
                }
                catch (IOException v0) {
                    block25: {
                        break block25;
lbl11:
                        // 1 sources

                        if (var3_3 == -1) break;
                        try {
                            var1_1.write(var2_2, 0, var3_3);
                            continue;
                        }
                        catch (IOException v1) {}
                        break block25;
                        continue;
                    }
                    var4_4 = null;
                    try {
                        try {
                            var0.close();
                        }
                        catch (IOException v2) {}
                        var6_11 = null;
                    }
                    catch (Throwable var7_7) {
                        var6_10 = null;
                        try {
                            var1_1.close();
                            throw var7_7;
                        }
                        catch (IOException v3) {}
                        throw var7_7;
                    }
                    try {}
                    catch (IOException v4) {}
                    var1_1.close();
                    return;
                    return;
                }
                break;
            }
            var4_6 = null;
        }
        catch (Throwable var5_16) {
            var4_5 = null;
            try {}
            catch (Throwable var7_8) {
                var6_12 = null;
                try {}
                catch (IOException v5) {}
                var1_1.close();
                throw var7_8;
                throw var7_8;
            }
            try {}
            catch (IOException v6) {}
            var0.close();
            var6_13 = null;
            try {}
            catch (IOException v7) {}
            var1_1.close();
            throw var5_16;
            throw var5_16;
        }
        try {}
        catch (Throwable var7_9) {
            var6_14 = null;
            try {}
            catch (IOException v8) {}
            var1_1.close();
            throw var7_9;
            throw var7_9;
        }
        try {}
        catch (IOException v9) {}
        var0.close();
        var6_15 = null;
        try {}
        catch (IOException v10) {
            return;
        }
        var1_1.close();
    }

    private String extractSplashFromJAR(String string, String string2) {
        BufferedOutputStream bufferedOutputStream;
        ZipFile zipFile;
        String string3 = System.getProperty(PROP_CONFIG_AREA);
        if (string3 == null) {
            this.log("Configuration area not set yet. Unable to extract splash from JAR'd plug-in: " + string);
            return null;
        }
        URL uRL = Main.buildURL(string3, false);
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getPath(), OSGI);
        if ((file = new File(file, string2)).exists()) {
            boolean bl = false;
            int n = 0;
            while (n < this.commands.length) {
                if (CLEAN.equalsIgnoreCase(this.commands[n])) {
                    bl = true;
                    file.delete();
                    break;
                }
                ++n;
            }
            if (!bl) {
                return file.getAbsolutePath();
            }
        }
        try {
            zipFile = new ZipFile(string);
        }
        catch (IOException iOException) {
            this.log("Exception looking for splash  in JAR file: " + string);
            this.log(iOException);
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(string2.replace(File.separatorChar, '/'));
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            this.log("Exception opening splash: " + zipEntry.getName() + " in JAR file: " + string);
            this.log(iOException);
            return null;
        }
        file.getParentFile().mkdirs();
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        Main.transferStreams(inputStream, bufferedOutputStream);
        return file.exists() ? file.getAbsolutePath() : null;
    }

    private boolean isJAR(String string) {
        if (string.endsWith(File.separator)) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        if (++n >= string.length()) {
            return false;
        }
        return "JAR".equalsIgnoreCase(string.substring(n));
    }

    private static String[] buildNLVariants(String string) {
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>(4);
        while (true) {
            arrayList.add("nl" + File.separatorChar + string2.replace('_', File.separatorChar) + File.separatorChar + SPLASH_IMAGE);
            int n = string2.lastIndexOf(95);
            if (n == -1) break;
            string2 = string2.substring(0, n);
        }
        arrayList.add(SPLASH_IMAGE);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String resolve(String string) {
        if (string.startsWith(REFERENCE_SCHEME)) {
            string = string.substring(10);
            System.getProperties().put(PROP_FRAMEWORK, string);
        }
        if (string.startsWith(PLATFORM_URL)) {
            String string2 = string.substring(PLATFORM_URL.length());
            return this.getInstallLocation() + string2;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void log(Object object) {
        if (object == null) {
            return;
        }
        try {
            block16: {
                try {
                    block15: {
                        this.openLogFile();
                        try {
                            if (this.newSession) {
                                this.log.write(SESSION);
                                this.log.write(32);
                                String string = new Date().toString();
                                this.log.write(string);
                                this.log.write(32);
                                int n = SESSION.length() + string.length();
                                while (true) {
                                    if (n >= 78) {
                                        this.log.newLine();
                                        this.newSession = false;
                                        break;
                                    }
                                    this.log.write(45);
                                    ++n;
                                }
                            }
                            this.write(object);
                            Object var4_8 = null;
                            if (this.logFile != null) break block15;
                            if (this.log == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            if (this.logFile == null) {
                                if (this.log == null) throw throwable;
                                this.log.flush();
                                throw throwable;
                            }
                            this.closeLogFile();
                            throw throwable;
                        }
                        this.log.flush();
                        break block16;
                    }
                    this.closeLogFile();
                }
                catch (Exception exception) {
                    System.err.println("An exception occurred while writing to the platform log:");
                    exception.printStackTrace(System.err);
                    System.err.println("Logging to the console instead.");
                    try {
                        this.log = this.logForStream(System.err);
                        this.write(object);
                        this.log.flush();
                    }
                    catch (Exception exception2) {
                        System.err.println("An exception occurred while logging to the console:");
                        exception2.printStackTrace(System.err);
                    }
                }
            }
            Object var6_11 = null;
            this.log = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.log = null;
            throw throwable;
        }
    }

    private void write(Object object) throws IOException {
        if (object == null) {
            return;
        }
        if (object instanceof Throwable) {
            this.log.write(STACK);
            this.log.newLine();
            ((Throwable)object).printStackTrace(new PrintWriter(this.log));
        } else {
            this.log.write(ENTRY);
            this.log.write(32);
            this.log.write(PLUGIN_ID);
            this.log.write(32);
            this.log.write(String.valueOf(4));
            this.log.write(32);
            this.log.write(String.valueOf(0));
            this.log.write(32);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
                this.log.write(simpleDateFormat.format(new Date()));
            }
            catch (Exception exception) {
                this.log.write(Long.toString(System.currentTimeMillis()));
            }
            this.log.newLine();
            this.log.write(MESSAGE);
            this.log.write(32);
            this.log.write(String.valueOf(object));
        }
        this.log.newLine();
    }

    private void computeLogFileLocation() {
        String string = System.getProperty(PROP_LOGFILE);
        if (string != null) {
            if (this.logFile == null || !string.equals(this.logFile.getAbsolutePath())) {
                this.logFile = new File(string);
                this.logFile.getParentFile().mkdirs();
            }
            return;
        }
        URL uRL = Main.buildURL(System.getProperty(PROP_CONFIG_AREA), false);
        if (uRL == null) {
            return;
        }
        this.logFile = new File(uRL.getPath(), String.valueOf(Long.toString(System.currentTimeMillis())) + ".log");
        this.logFile.getParentFile().mkdirs();
        System.getProperties().setProperty(PROP_LOGFILE, this.logFile.getAbsolutePath());
    }

    private int hexToByte(byte by) {
        switch (by) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    private void openLogFile() throws IOException {
        this.computeLogFileLocation();
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException iOException) {
            this.logFile = null;
            throw iOException;
        }
    }

    private BufferedWriter logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.log = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.log = null;
            return;
        }
    }

    private void mergeProperties(Properties properties, Properties properties2) {
        if (properties == null || properties2 == null) {
            return;
        }
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals(PROP_CLASSPATH)) {
                string = properties.getProperty(PROP_CLASSPATH);
                String string3 = properties2.getProperty(PROP_CLASSPATH);
                string = string == null ? string3 : String.valueOf(string) + string3;
                properties.put(PROP_CLASSPATH, string);
                continue;
            }
            if (string2.equals(PROP_EOF)) continue;
            string = properties2.getProperty(string2);
            if (properties.getProperty(string2) != null) continue;
            properties.put(string2, string);
        }
    }

    private void setupVMProperties() {
        if (this.vm != null) {
            System.getProperties().put(PROP_VM, this.vm);
        }
        this.setMultiValueProperty(PROP_VMARGS, this.vmargs);
        this.setMultiValueProperty(PROP_COMMANDS, this.commands);
    }

    private void setMultiValueProperty(String string, String[] stringArray) {
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer(300);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append('\n');
                }
                ++n;
            }
            System.getProperties().put(string, stringBuffer.toString());
        }
    }

    static class Identifier {
        private static final String DELIM = ". _-";
        private int major;
        private int minor;
        private int service;

        Identifier(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.service = n3;
        }

        Identifier(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
            if (stringTokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.minor = Integer.parseInt(stringTokenizer.nextToken());
            }
            try {
                if (stringTokenizer.hasMoreTokens()) {
                    this.service = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        boolean isGreaterEqualTo(Identifier identifier) {
            if (this.major < identifier.major) {
                return false;
            }
            if (this.major > identifier.major) {
                return true;
            }
            if (this.minor < identifier.minor) {
                return false;
            }
            if (this.minor > identifier.minor) {
                return true;
            }
            return this.service >= identifier.service;
        }
    }

    private class EclipsePolicy
    extends Policy {
        private Policy policy;
        private URL[] urls;
        private PermissionCollection allPermissions;
        private Permission allPermission = new AllPermission();

        EclipsePolicy(Policy policy, URL[] uRLArray) {
            this.policy = policy;
            this.urls = uRLArray;
            this.allPermissions = new PermissionCollection(this){
                private static final long serialVersionUID = 3258131349494708277L;
                final /* synthetic */ EclipsePolicy this$1;
                {
                    this.this$1 = eclipsePolicy;
                }

                public void add(Permission permission) {
                }

                public boolean implies(Permission permission) {
                    return true;
                }

                public Enumeration elements() {
                    return new Enumeration(this){
                        int cur;
                        final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = var1_1;
                            this.cur = 0;
                        }

                        public boolean hasMoreElements() {
                            return this.cur < 1;
                        }

                        public Object nextElement() {
                            if (this.cur == 0) {
                                this.cur = 1;
                                return EclipsePolicy.access$0(2.access$0(this.this$2));
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }

                static /* synthetic */ EclipsePolicy access$0(2 var0) {
                    return var0.this$1;
                }
            };
        }

        public PermissionCollection getPermissions(CodeSource codeSource) {
            if (this.contains(codeSource.getLocation())) {
                return this.allPermissions;
            }
            return this.policy == null ? this.allPermissions : this.policy.getPermissions(codeSource);
        }

        public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
            return this.allPermissions;
        }

        public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
            return true;
        }

        public void refresh() {
            if (this.policy != null) {
                this.policy.refresh();
            }
        }

        private boolean contains(URL uRL) {
            int n = 0;
            while (n < this.urls.length) {
                if (this.urls[n] == uRL) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        static /* synthetic */ Permission access$0(EclipsePolicy eclipsePolicy) {
            return eclipsePolicy.allPermission;
        }
    }

    private class StartupClassLoader
    extends URLClassLoader {
        public StartupClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public StartupClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public StartupClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
            super(uRLArray, classLoader, uRLStreamHandlerFactory);
        }

        protected String findLibrary(String string) {
            if (Main.this.extensionPaths == null) {
                return super.findLibrary(string);
            }
            String string2 = System.mapLibraryName(string);
            int n = 0;
            while (n < Main.this.extensionPaths.length) {
                File file = new File(Main.this.extensionPaths[n], string2);
                if (file.isFile()) {
                    return file.getAbsolutePath();
                }
                ++n;
            }
            return super.findLibrary(string);
        }
    }
}

