/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;

public abstract class CompositeExpression
extends Expression {
    private static final Expression[] EMPTY_ARRAY = new Expression[0];
    private static final int HASH_INITIAL;
    protected List fExpressions;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.CompositeExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public void add(Expression expression) {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList(2);
        }
        this.fExpressions.add(expression);
    }

    public Expression[] getChildren() {
        if (this.fExpressions == null) {
            return EMPTY_ARRAY;
        }
        return this.fExpressions.toArray(new Expression[this.fExpressions.size()]);
    }

    protected EvaluationResult evaluateAnd(IEvaluationContext iEvaluationContext) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult evaluationResult = EvaluationResult.TRUE;
        Iterator iterator = this.fExpressions.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if ((evaluationResult = evaluationResult.and(expression.evaluate(iEvaluationContext))) != EvaluationResult.FALSE) continue;
            return evaluationResult;
        }
        return evaluationResult;
    }

    protected EvaluationResult evaluateOr(IEvaluationContext iEvaluationContext) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult evaluationResult = EvaluationResult.FALSE;
        Iterator iterator = this.fExpressions.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if ((evaluationResult = evaluationResult.or(expression.evaluate(iEvaluationContext))) != EvaluationResult.TRUE) continue;
            return evaluationResult;
        }
        return evaluationResult;
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        if (this.fExpressions == null) {
            return;
        }
        Iterator iterator = this.fExpressions.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.collectExpressionInfo(expressionInfo);
        }
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + CompositeExpression.hashCode(this.fExpressions);
    }
}

