/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ViewPane
extends PartPane
implements IPropertyListener {
    private boolean busy = false;
    private boolean fast = false;
    private boolean showFocus = false;
    Composite toolbarWrapper;
    boolean hasFocus;
    private boolean hadViewMenu = false;

    public ViewPane(IViewReference ref, WorkbenchPage page) {
        super(ref, page);
        this.fast = ref.isFastView();
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            return;
        }
        super.createControl(parent);
    }

    private void recreateToolbars() {
        this.updateActionBars();
    }

    protected void createTitleBar() {
        this.updateTitles();
        this.getPartReference().addPropertyListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.dispose();
            this.toolbarWrapper = null;
        }
    }

    public void doHide() {
        this.getPage().hideView(this.getViewReference());
    }

    Rectangle getParentBounds() {
        LayoutPart part;
        Control ctrl = this.getControl();
        if (this.getContainer() != null && this.getContainer() instanceof LayoutPart && (part = (LayoutPart)((Object)this.getContainer())).getControl() != null) {
            ctrl = part.getControl();
        }
        return ctrl.getBounds();
    }

    public void doMakeFast() {
        WorkbenchWindow window = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        window.getShell();
        this.getPage().addFastView(this.getViewReference());
    }

    public void doRemoveFast() {
        this.getControl().getShell();
        this.getParentBounds();
        this.getPage().removeFastView(this.getViewReference());
        IWorkbenchPart toActivate = this.getViewReference().getPart(true);
        if (toActivate != null) {
            this.getPage().activate(toActivate);
        }
        this.getParentBounds();
    }

    protected void doDock() {
        this.getPage().removeFastView(this.getViewReference());
    }

    public void doDetach() {
        this.getPage().detachView(this.getViewReference());
    }

    public void doAttach() {
        this.getPage().attachView(this.getViewReference());
    }

    public String getCompoundId() {
        IViewReference ref = this.getViewReference();
        if (ref != null) {
            return ViewFactory.getKey(ref);
        }
        return super.getCompoundId();
    }

    public Control getDragHandle() {
        return this.control;
    }

    public Control[] getTabList() {
        Control c = this.getControl();
        if (this.getContainer() instanceof ViewStack) {
            ViewStack tf = (ViewStack)this.getContainer();
            return tf.getTabList(this);
        }
        return new Control[]{c};
    }

    public IViewReference getViewReference() {
        return (IViewReference)this.getPartReference();
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            this.updateTitles();
        }
    }

    public void setFast(boolean b) {
        this.fast = b;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    void setActive(boolean active) {
        this.hasFocus = active;
        if (this.getContainer() instanceof PartStack) {
            ((PartStack)this.getContainer()).setActive(active ? 1 : 0);
        }
    }

    public void showFocus(boolean inFocus) {
        this.setActive(inFocus);
    }

    private boolean isFastView() {
        return this.page.isFastView(this.getViewReference());
    }

    boolean isMoveable() {
        return !this.page.isFixedLayout();
    }

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point location) {
        if (!this.hasViewMenu()) {
            return;
        }
        if (this.isFastView() && this.page.getActiveFastView() != this.getViewReference()) {
            return;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    public void updateActionBars() {
    }

    public void updateTitles() {
    }

    protected void doZoom() {
        if (this.isMoveable()) {
            super.doZoom();
        }
    }

    public void setContainer(ILayoutContainer container) {
        ILayoutContainer oldContainer = this.getContainer();
        if (this.hasFocus) {
            if (oldContainer != null && oldContainer instanceof PartStack) {
                ((PartStack)oldContainer).setActive(0);
            }
            if (container != null && container instanceof PartStack) {
                ((PartStack)container).setActive(1);
            }
        }
        super.setContainer(container);
    }

    public void reparent(Composite newParent) {
        super.reparent(newParent);
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.setParent(newParent);
        }
    }

    public void moveAbove(Control refControl) {
        super.moveAbove(refControl);
    }

    public void setVisible(boolean makeVisible) {
        super.setVisible(makeVisible);
    }

    public void setBusy(boolean isBusy) {
        if (isBusy != this.busy) {
            this.busy = isBusy;
            this.presentableAdapter.firePropertyChange(146);
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void showHighlight() {
        this.presentableAdapter.firePropertyChange(148);
    }

    public String getPlaceHolderId() {
        return ViewFactory.getKey(this.getViewReference());
    }

    public Control getToolBar() {
        return this.toolbarWrapper;
    }

    public boolean isCloseable() {
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return true;
        }
        return perspective.isCloseable(this.getViewReference());
    }
}

