/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ProxyImageDescriptor;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;

public class WorkbenchImages {
    private static Map descriptors;
    private static ImageRegistry imageRegistry;
    private static ReferenceCounter imageCache;
    public static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String PATH_EVIEW = "$nl$/icons/full/eview16/";

    public static ReferenceCounter getImageCache() {
        if (imageCache == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return imageCache;
    }

    private static final void declareImage(String key, String path, boolean shared) {
        ProxyImageDescriptor prxImageDescriptor = new ProxyImageDescriptor(key, path, shared);
        WorkbenchImages.declareImage(key, prxImageDescriptor, shared);
    }

    private static final void declareImages() {
        WorkbenchImages.declareImage("IMG_ETOOL_NEW_PAGE", "$nl$/icons/full/eview16/new_persp.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_DEF_PERSPECTIVE", "$nl$/icons/full/eview16/default_persp.gif", false);
        WorkbenchImages.declareImage("IMG_VIEW_DEFAULTVIEW_MISC", "$nl$/icons/full/eview16/defaultview_misc.gif", false);
        WorkbenchImages.declareImage("IMG_DEF_VIEW", "$nl$/icons/full/eview16/defaultview_misc.gif", true);
    }

    public static void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        if (Policy.DEBUG_DECLARED_IMAGES) {
            Image image = descriptor.createImage(false);
            if (image == null) {
                WorkbenchPlugin.log("Image not found in WorkbenchImages.declaredImage().  symbolicName=" + symbolicName + " descriptor=" + descriptor, new Exception("stack dump"));
            } else {
                image.dispose();
            }
        }
        WorkbenchImages.getDescriptors().put(symbolicName, descriptor);
        if (shared) {
            WorkbenchImages.getImageRegistry().put(symbolicName, descriptor);
        }
    }

    private static Map getDescriptors() {
        if (descriptors == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return descriptors;
    }

    public static Image getImage(String symbolicName) {
        return WorkbenchImages.getImageRegistry().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptor(String symbolicName) {
        return (ImageDescriptor)WorkbenchImages.getDescriptors().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptorFromProgram(String filename, int offset) {
        Assert.isNotNull(filename);
        String key = String.valueOf(filename) + "*" + offset;
        ImageDescriptor desc = WorkbenchImages.getImageDescriptor(key);
        if (desc == null) {
            desc = new ProgramImageDescriptor(filename, offset);
            WorkbenchImages.getDescriptors().put(key, desc);
        }
        return desc;
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    private static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        descriptors = new HashMap();
        imageCache = new ReferenceCounter();
        WorkbenchImages.declareImages();
    }

    public static void dispose() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
            imageRegistry = null;
            descriptors = null;
            imageCache = null;
        }
    }

    public static ImageDescriptor getWorkbenchImageDescriptor(String relativePath) {
        return ImageDescriptor.createFromURL((URL)BundleUtility.find("org.eclipse.ui", ICONS_PATH + relativePath));
    }
}

