/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.misc.Policy;

public final class HandlerService
implements IHandlerService {
    private final CommandManager commandManager;

    static {
        Command.DEBUG_HANDLERS = Policy.DEBUG_HANDLERS_VERBOSE;
        Command.DEBUG_HANDLERS_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    }

    public HandlerService(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    private final void updateCommand(String commandId, IHandlerActivation activation) {
        Command command = this.commandManager.getCommand(commandId);
        if (activation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(activation.getHandler());
        }
    }

    public final IHandlerActivation activateHandler(String commandId, IHandler handler) {
        HandlerActivation activation = new HandlerActivation(commandId, handler, null, 1, this);
        this.updateCommand(commandId, activation);
        return activation;
    }

    public final IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, int sourcePriority) {
        if (expression == null) {
            throw new NullPointerException("The expression cannot be null");
        }
        HandlerActivation activation = new HandlerActivation(commandId, handler, expression, sourcePriority, this);
        this.updateCommand(commandId, activation);
        return activation;
    }

    public final void deactivateHandler(IHandlerActivation activation) {
        if (activation.getHandlerService() == this) {
            this.updateCommand(activation.getCommandId(), null);
        }
    }

    public final void deactivateHandlers(Collection activations) {
        Iterator activationItr = activations.iterator();
        while (activationItr.hasNext()) {
            IHandlerActivation activation = (IHandlerActivation)activationItr.next();
            this.deactivateHandler(activation);
        }
    }

    public final IEvaluationContext getCurrentState() {
        return null;
    }

    public final void readRegistry() {
    }
}

