/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import com.ibm.ugl.eswt.expanded.OS;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.GIFFileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.widgets.Display;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
    }

    int nativeImageFormat(int format) {
        int imageFormat = 0;
        switch (format) {
            case 2: {
                imageFormat = 1;
                break;
            }
            case 4: {
                imageFormat = 2;
                break;
            }
            case 5: {
                imageFormat = 3;
                break;
            }
            default: {
                SWT.error(42);
            }
        }
        return imageFormat;
    }

    public ImageData[] load(InputStream stream) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        LEDataInputStream lestream = new LEDataInputStream(stream);
        GIFFileFormat gifFileFormat = new GIFFileFormat();
        this.data = FileFormat.load(stream, this);
        if (this.data != null) {
            return this.data;
        }
        try {
            stream.reset();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.data = new ImageDataLoader().load(stream);
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public ImageData[] load(String fileName) {
        block14: {
            if (fileName == null) {
                SWT.error(4);
            }
            this.reset();
            try {
                block15: {
                    FileInputStream is = new FileInputStream(fileName);
                    LEDataInputStream lestream = new LEDataInputStream(is);
                    GIFFileFormat gifFileFormat = new GIFFileFormat();
                    if (!gifFileFormat.isFileFormat(lestream)) break block15;
                    FileInputStream stream = null;
                    stream = new FileInputStream(fileName);
                    ImageData[] imageDataArray = this.load(stream);
                    Object var8_9 = null;
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    {
                        return imageDataArray;
                        catch (IOException e) {
                            SWT.error(39, e);
                            Object var8_10 = null;
                            try {
                                if (stream != null) {
                                    ((InputStream)stream).close();
                                }
                                break block14;
                            }
                            catch (IOException e2) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        try {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                this.data = new ImageDataLoader().load(fileName);
                return this.data;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public void save(OutputStream stream, int format) {
        if (stream == null) {
            SWT.error(4);
        }
        if (format != 5 && format != 2 && format != 4) {
            SWT.error(42);
        }
        FileFormat.save(stream, format, this);
    }

    public void save(String filename, int format) {
        if (filename == null) {
            SWT.error(4);
        }
        int image_format = this.nativeImageFormat(format);
        Image image = new Image((Device)Display.getDefault(), this.data[0]);
        ImageData imgData = this.data[0];
        RGB[] rgbs = imgData.getRGBs();
        int[] colorMap = new int[]{};
        if (rgbs != null) {
            colorMap = new int[rgbs.length];
            for (int i = 0; i < colorMap.length; ++i) {
                colorMap[i] = rgbs[i].hashCode();
            }
        }
        OS.Image_Save(image.internal_handle, filename, imgData.width, imgData.height, imgData.depth, imgData.bytesPerLine, imgData.alpha, imgData.alphaData, colorMap.length, colorMap, imgData.transparentPixel, imgData.data, image_format);
        image.dispose();
    }
}

