/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ercp.xml.io.IOSpecificCall;

public class IanaJavaMap {
    static Hashtable Iana2Java = null;
    static Hashtable Java2Iana = null;
    static /* synthetic */ Class class$0;

    public static String getIana2Java(String ianaEncoding) {
        if (ianaEncoding == null) {
            return null;
        }
        return (String)IanaJavaMap.getIana2JavaEncoding().get(ianaEncoding);
    }

    static Hashtable getIana2JavaEncoding() {
        if (Iana2Java != null) {
            return Iana2Java;
        }
        IanaJavaMap.initializeIana2JavaEncoding();
        return Iana2Java;
    }

    public static String getJava2Iana(String javaEncoding) {
        if (javaEncoding == null) {
            return null;
        }
        return (String)IanaJavaMap.getJava2IanaEncoding().get(javaEncoding);
    }

    static Hashtable getJava2IanaEncoding() {
        if (Java2Iana != null) {
            return Java2Iana;
        }
        IanaJavaMap.initializeJava2IanaEncoding();
        return Java2Iana;
    }

    static void initializeIana2JavaEncoding() {
        Iana2Java = new Hashtable();
        Iana2Java.put("US-ASCII", "US-ASCII");
        Iana2Java.put("Big5", "Big5");
        Iana2Java.put("euc-jp", "eucjis");
        Iana2Java.put("EUC-KR", "EUCKR");
        Iana2Java.put("iso-2020-jp", "JIS");
        Iana2Java.put("Shift_JIS", "SJIS");
        Iana2Java.put("ISO-8859-1", "ISO8859-1");
        Iana2Java.put("UTF-16", "UTF-16");
        Iana2Java.put("UTF-16BE", "UTF-16BE");
        Iana2Java.put("UTF-16LE", "UTF-16LE");
        Iana2Java.put("UTF-8", "UTF-8");
        IOSpecificCall iOSpecificCall = IOSpecificCall.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ercp.xml.io.IanaJavaMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iOSpecificCall.readPropertyFile(clazz, "iana-to-java.properties", Iana2Java);
    }

    static void initializeJava2IanaEncoding() {
        Hashtable ianaTable = IanaJavaMap.getIana2JavaEncoding();
        Java2Iana = new Hashtable();
        Enumeration keys = ianaTable.keys();
        while (keys.hasMoreElements()) {
            String ianaKey = (String)keys.nextElement();
            Java2Iana.put(ianaTable.get(ianaKey), ianaKey);
        }
    }

    public static void appendIana2JavaFile(InputStream stream) {
        IOSpecificCall.getDefault().readPropertyFile(stream, IanaJavaMap.getIana2JavaEncoding());
        IanaJavaMap.updateJava2IanaEncoding();
    }

    static void updateJava2IanaEncoding() {
        Hashtable ianaTable = IanaJavaMap.getIana2JavaEncoding();
        Enumeration keys = ianaTable.keys();
        Hashtable javaTable = IanaJavaMap.getJava2IanaEncoding();
        while (keys.hasMoreElements()) {
            String ianaKey = (String)keys.nextElement();
            String javaKey = (String)ianaTable.get(ianaKey);
            javaTable.put(javaKey, ianaKey);
        }
    }

    public static void putIana2Java(String ianaKey, String javaKey) {
        Hashtable ianaTable = IanaJavaMap.getIana2JavaEncoding();
        Hashtable javaTable = IanaJavaMap.getJava2IanaEncoding();
        ianaTable.put(ianaKey, javaKey);
        javaTable.put(javaKey, ianaKey);
    }
}

