/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;
import org.eclipse.ercp.xml.io.StreamDecoder;
import org.eclipse.ercp.xml.parser.EXmlMsg;

public class StreamDecoder_UTF16BE
extends StreamDecoder {
    public StreamDecoder_UTF16BE(SimpleBufferedInputStream stream) {
        super(stream, "UTF-16BE");
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        if (count <= 0) {
            return count;
        }
        int charOffset = offset;
        byte[] b = new byte[2 * count];
        int available = this.stream.read(b, 0, 2 * count);
        if (available == -1) {
            return -1;
        }
        int pos = 0;
        int end = available - 1;
        while (pos < end) {
            buf[charOffset++] = (char)((0xFF & b[pos++]) << 8 | 0xFF & b[pos++]);
        }
        if (pos != available) {
            throw new IOException(EXmlMsg.getDefault().getString(50, Integer.toHexString(b[available - 1])));
        }
        return charOffset - offset;
    }
}

