/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class DisableCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private IFeature feature;

    public DisableCommand(String featureId, String version, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            IFeature[] features;
            IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
            if (toSite != null) {
                URL toSiteURL = new File(toSite).toURL();
                if (SiteManager.getSite(toSiteURL, null) == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{toSite}));
                }
                this.targetSite = SiteManager.getSite(toSiteURL, null).getCurrentConfiguredSite();
            }
            if (this.targetSite == null) {
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if ((features = UpdateUtils.searchSite(featureId, this.targetSite, true)) == null || features.length == 0) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures3, (Object[])new String[]{featureId}));
            }
            if (version == null || version.trim().length() == 0) {
                this.feature = features[0];
            } else {
                int i = 0;
                while (features != null && i < features.length) {
                    if (features[i].getVersionedIdentifier().getVersion().toString().equals(version)) {
                        this.feature = features[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.feature == null) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures4, (Object[])new String[]{featureId, version}));
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    public boolean run(IProgressMonitor monitor) {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            UpdateCore.log(status);
            return false;
        }
        if (this.isVerifyOnly()) {
            status = OperationsManager.getValidator().validatePendingUnconfig(this.feature);
            if (status != null && status.getCode() == 2) {
                UpdateCore.log(status);
            }
            return status == null || status.getCode() == 2;
        }
        IUnconfigFeatureOperation configOperation = OperationsManager.getOperationFactory().createUnconfigOperation(this.targetSite, this.feature);
        try {
            configOperation.execute(monitor, this);
            return true;
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
        catch (InvocationTargetException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
    }
}

