/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PerspectiveHelper {
    private WorkbenchPage page;
    private Composite parentWidget;
    private ViewSashContainer mainLayout;
    private ArrayList detachedWindowList = new ArrayList(1);
    private ArrayList detachedPlaceHolderList = new ArrayList(1);
    private boolean detachable = false;
    private boolean active = false;
    private static final int MIN_DETACH_WIDTH = 150;
    private static final int MIN_DETACH_HEIGHT = 250;
    private Perspective perspective;

    public PerspectiveHelper(WorkbenchPage workbenchPage, ViewSashContainer viewSashContainer, Perspective perspective) {
        this.page = workbenchPage;
        this.mainLayout = viewSashContainer;
        this.perspective = perspective;
        this.detachable = false;
        Composite composite = workbenchPage.getClientComposite();
        if (composite != null) {
            Composite composite2 = new Composite(composite, 0);
            this.detachable = composite2.isReparentable();
            composite2.dispose();
        }
    }

    public void activate(Composite composite) {
        if (this.active) {
            return;
        }
        this.parentWidget = composite;
        Vector vector = new Vector();
        this.collectViewPanes(vector, this.mainLayout.getChildren());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart layoutPart = (LayoutPart)enumeration.nextElement();
            layoutPart.reparent(composite);
        }
        this.mainLayout.createControl(composite);
        this.active = true;
    }

    public void addPart(LayoutPart layoutPart) {
        Object object;
        Object object2;
        LayoutPart layoutPart2 = null;
        LayoutPart layoutPart3 = null;
        String string = layoutPart.getID();
        String string2 = null;
        if (layoutPart instanceof ViewPane) {
            object2 = (ViewPane)layoutPart;
            object = (IViewReference)((PartPane)object2).getPartReference();
            string2 = object.getSecondaryId();
        }
        if ((layoutPart3 = string2 != null ? this.findPart(string, string2) : this.findPart(string)) != null && layoutPart3 instanceof PartPlaceholder) {
            layoutPart2 = (PartPlaceholder)layoutPart3;
        }
        if (layoutPart2 == null) {
            layoutPart.reparent(this.mainLayout.getParent());
            object2 = this.mainLayout.findBottomRight();
            if (object2 != null && object2 instanceof ILayoutContainer) {
                object = (ILayoutContainer)object2;
                if (object.allowsAdd(layoutPart)) {
                    this.mainLayout.stack(layoutPart, (ILayoutContainer)object);
                } else {
                    this.mainLayout.add(layoutPart);
                }
            } else {
                this.mainLayout.add(layoutPart);
            }
        } else {
            object2 = layoutPart2.getContainer();
            if (object2 != null) {
                if (object2 instanceof ContainerPlaceholder) {
                    object = (ContainerPlaceholder)object2;
                    ILayoutContainer iLayoutContainer = ((LayoutPart)object).getContainer();
                    object2 = (ILayoutContainer)((Object)((ContainerPlaceholder)object).getRealContainer());
                    if (object2 instanceof LayoutPart) {
                        iLayoutContainer.replace((LayoutPart)object, (LayoutPart)object2);
                    }
                    ((ContainerPlaceholder)object).setRealContainer(null);
                }
                if (!(object2 instanceof ViewStack)) {
                    layoutPart.reparent(this.mainLayout.getParent());
                }
                if (((PartPlaceholder)layoutPart2).hasWildCard()) {
                    object2.add(layoutPart);
                } else {
                    object2.replace(layoutPart2, layoutPart);
                }
            }
        }
    }

    public void attachPart(IViewReference iViewReference) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        this.derefPart(viewPane);
        this.addPart(viewPane);
        this.bringPartToTop(viewPane);
        viewPane.setFocus();
    }

    public boolean canDetach() {
        return this.detachable;
    }

    public boolean bringPartToTop(LayoutPart layoutPart) {
        PartStack partStack;
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null && iLayoutContainer instanceof PartStack && (partStack = (PartStack)iLayoutContainer).getVisiblePart() != layoutPart) {
            partStack.setSelection(layoutPart);
            return true;
        }
        return false;
    }

    public boolean isPartVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        LayoutPart layoutPart = iWorkbenchPartReference instanceof IViewReference ? this.findPart(iWorkbenchPartReference.getId(), ((IViewReference)iWorkbenchPartReference).getSecondaryId()) : this.findPart(iWorkbenchPartReference.getId());
        if (layoutPart == null) {
            return false;
        }
        if (layoutPart instanceof PartPlaceholder) {
            return false;
        }
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer instanceof ContainerPlaceholder) {
            return false;
        }
        if (iLayoutContainer instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)iLayoutContainer;
            PartPane partPane = viewStack.getVisiblePart();
            if (partPane == null) {
                return false;
            }
            return iWorkbenchPartReference.equals(partPane.getPartReference());
        }
        return true;
    }

    public boolean willPartBeVisible(String string) {
        return this.willPartBeVisible(string, null);
    }

    public boolean willPartBeVisible(String string, String string2) {
        LayoutPart layoutPart = this.findPart(string, string2);
        if (layoutPart == null) {
            return false;
        }
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null && iLayoutContainer instanceof ContainerPlaceholder) {
            iLayoutContainer = (ILayoutContainer)((Object)((ContainerPlaceholder)iLayoutContainer).getRealContainer());
        }
        if (iLayoutContainer != null && iLayoutContainer instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)iLayoutContainer;
            if (viewStack.getVisiblePart() == null) {
                return false;
            }
            return layoutPart.getCompoundId().equals(viewStack.getVisiblePart().getCompoundId());
        }
        return true;
    }

    private PartPlaceholder[] collectPlaceholders() {
        PartPlaceholder[] partPlaceholderArray = this.collectPlaceholders(this.mainLayout.getChildren());
        return partPlaceholderArray;
    }

    private PartPlaceholder[] collectPlaceholders(LayoutPart[] layoutPartArray) {
        PartPlaceholder[] partPlaceholderArray = new PartPlaceholder[]{};
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            PartPlaceholder[] partPlaceholderArray2;
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ILayoutContainer) {
                partPlaceholderArray2 = this.collectPlaceholders(((ILayoutContainer)((Object)layoutPart)).getChildren());
                PartPlaceholder[] partPlaceholderArray3 = new PartPlaceholder[partPlaceholderArray.length + partPlaceholderArray2.length];
                System.arraycopy(partPlaceholderArray, 0, partPlaceholderArray3, 0, partPlaceholderArray.length);
                System.arraycopy(partPlaceholderArray2, 0, partPlaceholderArray3, partPlaceholderArray.length, partPlaceholderArray2.length);
                partPlaceholderArray = partPlaceholderArray3;
            } else if (layoutPart instanceof PartPlaceholder) {
                partPlaceholderArray2 = new PartPlaceholder[partPlaceholderArray.length + 1];
                System.arraycopy(partPlaceholderArray, 0, partPlaceholderArray2, 0, partPlaceholderArray.length);
                partPlaceholderArray2[partPlaceholderArray.length] = (PartPlaceholder)layoutPart;
                partPlaceholderArray = partPlaceholderArray2;
            }
            ++n;
        }
        return partPlaceholderArray;
    }

    public void collectViewPanes(List list) {
        this.collectViewPanes(list, this.mainLayout.getChildren());
    }

    private void collectViewPanes(List list, LayoutPart[] layoutPartArray) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ViewPane) {
                list.add(layoutPart);
            } else if (layoutPart instanceof ILayoutContainer) {
                this.collectViewPanes(list, ((ILayoutContainer)((Object)layoutPart)).getChildren());
            }
            ++n;
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.disableAllDrag();
        Composite composite = this.mainLayout.getParent();
        Vector vector = new Vector();
        this.collectViewPanes(vector, this.mainLayout.getChildren());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart layoutPart = (LayoutPart)enumeration.nextElement();
            layoutPart.reparent(composite);
        }
        this.mainLayout.dispose();
        this.active = false;
    }

    public void describeLayout(StringBuffer stringBuffer) {
        if (this.detachable && this.detachedWindowList.size() != 0) {
            stringBuffer.append("detachedWindows (");
        }
        this.getLayout().describeLayout(stringBuffer);
    }

    void derefPart(LayoutPart layoutPart) {
        if (layoutPart instanceof ViewPane) {
            this.page.removeFastView(((ViewPane)layoutPart).getViewReference());
        }
        boolean bl = layoutPart.isDocked();
        layoutPart.getShell();
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        layoutPart.reparent(this.mainLayout.getParent());
        if (iLayoutContainer == null) {
            return;
        }
        iLayoutContainer.remove(layoutPart);
        LayoutPart[] layoutPartArray = iLayoutContainer.getChildren();
        if (bl) {
            LayoutPart layoutPart2;
            ILayoutContainer iLayoutContainer2;
            boolean bl2;
            boolean bl3 = bl2 = layoutPartArray != null && layoutPartArray.length > 0;
            if (bl2) {
                int n = 0;
                int n2 = 0;
                while (n2 < layoutPartArray.length) {
                    if (layoutPartArray[n2].getControl() != null) {
                        ++n;
                    }
                    ++n2;
                }
                if (iLayoutContainer instanceof ViewStack) {
                    ViewStack viewStack = (ViewStack)iLayoutContainer;
                    if (n == 0) {
                        ILayoutContainer iLayoutContainer3 = viewStack.getContainer();
                        int n3 = 0;
                        while (n3 < layoutPartArray.length) {
                            viewStack.remove(layoutPartArray[n3]);
                            iLayoutContainer3.add(layoutPartArray[n3]);
                            ++n3;
                        }
                        bl2 = false;
                    }
                }
            }
            if (!bl2 && iLayoutContainer instanceof LayoutPart && (iLayoutContainer2 = (layoutPart2 = (LayoutPart)((Object)iLayoutContainer)).getContainer()) != null) {
                iLayoutContainer2.remove(layoutPart2);
                layoutPart2.dispose();
            }
        } else if (!bl && layoutPartArray != null && layoutPartArray.length != 0) {
            boolean bl4 = true;
            int n = 0;
            int n4 = layoutPartArray.length;
            while (n < n4) {
                if (!(layoutPartArray[n] instanceof PartPlaceholder)) {
                    bl4 = false;
                    break;
                }
                ++n;
            }
        }
    }

    private void detach(LayoutPart layoutPart, int n, int n2) {
    }

    public void detachPart(IViewReference iViewReference) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        if (this.canDetach() && viewPane != null) {
            Rectangle rectangle = viewPane.getParentBounds();
            this.detach(viewPane, rectangle.x, rectangle.y);
        }
    }

    public void addDetachedPart(LayoutPart layoutPart) {
        Rectangle rectangle = this.parentWidget.getShell().getBounds();
        rectangle.x += (rectangle.width - 300) / 2;
        rectangle.y += (rectangle.height - 300) / 2;
        this.addDetachedPart(layoutPart, rectangle);
    }

    public void addDetachedPart(LayoutPart layoutPart, Rectangle rectangle) {
        if (!this.detachable) {
            this.addPart(layoutPart);
            return;
        }
    }

    private void disableAllDrag() {
    }

    private void enableAllDrag() {
    }

    private LayoutPart findPart(String string) {
        return this.findPart(string, null);
    }

    private LayoutPart findPart(String string, String string2) {
        LayoutPart layoutPart;
        ArrayList arrayList = new ArrayList();
        LayoutPart layoutPart2 = layoutPart = string2 != null ? this.findPart(string, string2, this.mainLayout.getChildren(), arrayList) : this.findPart(string, this.mainLayout.getChildren(), arrayList);
        if (layoutPart != null) {
            return layoutPart;
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            MatchingPart matchingPart = (MatchingPart)arrayList.get(0);
            if (matchingPart != null) {
                return matchingPart.part;
            }
        }
        return null;
    }

    private LayoutPart findPart(String string, LayoutPart[] layoutPartArray, ArrayList arrayList) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            Object object;
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart.getID().equals(string)) {
                IViewReference iViewReference;
                if (!(layoutPart instanceof ViewPane) || (iViewReference = (IViewReference)((PartPane)(object = (ViewPane)layoutPart)).getPartReference()).getSecondaryId() == null) {
                    return layoutPart;
                }
            } else if (layoutPart instanceof PartPlaceholder && ((PartPlaceholder)layoutPart).hasWildCard()) {
                object = new StringMatcher(layoutPart.getID(), true, false);
                if (((StringMatcher)object).match(string)) {
                    arrayList.add(new MatchingPart(layoutPart.getID(), null, layoutPart));
                }
            } else if (layoutPart instanceof ILayoutContainer && (layoutPart = this.findPart(string, ((ILayoutContainer)((Object)layoutPart)).getChildren(), arrayList)) != null) {
                return layoutPart;
            }
            ++n;
        }
        return null;
    }

    private LayoutPart findPart(String string, String string2, LayoutPart[] layoutPartArray, ArrayList arrayList) {
        int n = 0;
        int n2 = layoutPartArray.length;
        while (n < n2) {
            Object object;
            Object object2;
            LayoutPart layoutPart = layoutPartArray[n];
            if (layoutPart instanceof ILayoutContainer && (object2 = this.findPart(string, string2, ((ILayoutContainer)((Object)layoutPart)).getChildren(), arrayList)) != null) {
                return object2;
            }
            if (layoutPart instanceof ViewPane) {
                object2 = (ViewPane)layoutPart;
                object = (IViewReference)((PartPane)object2).getPartReference();
                if (object.getId().equals(string) && object.getSecondaryId() != null && object.getSecondaryId().equals(string2)) {
                    return layoutPart;
                }
            } else if (layoutPartArray[n] instanceof PartPlaceholder) {
                object2 = layoutPart.getID();
                object = ViewFactory.extractSecondaryId((String)object2);
                if (object == null) {
                    if (((String)object2).equals(PartPlaceholder.WILD_CARD)) {
                        arrayList.add(new MatchingPart((String)object2, null, layoutPart));
                    }
                } else {
                    String string3 = ViewFactory.extractPrimaryId((String)object2);
                    if (string3.equals(string) && ((String)object).equals(string2)) {
                        return layoutPart;
                    }
                    StringMatcher stringMatcher = new StringMatcher(string3, true, false);
                    if (stringMatcher.match(string) && (stringMatcher = new StringMatcher((String)object, true, false)).match(string2)) {
                        arrayList.add(new MatchingPart(string3, (String)object, layoutPart));
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public boolean hasPlaceholder(String string) {
        return this.hasPlaceholder(string, null);
    }

    public boolean hasPlaceholder(String string, String string2) {
        LayoutPart layoutPart = string2 == null ? this.findPart(string) : this.findPart(string, string2);
        return layoutPart != null && layoutPart instanceof PartPlaceholder;
    }

    public ViewSashContainer getLayout() {
        return this.mainLayout;
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean isFastView(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference instanceof IViewReference) {
            WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPartReference.getPage();
            return workbenchPage.isFastView((IViewReference)iWorkbenchPartReference);
        }
        return false;
    }

    public boolean isZoomed() {
        return false;
    }

    public static float getDockingRatio(LayoutPart layoutPart, LayoutPart layoutPart2) {
        return 0.5f;
    }

    public boolean partChangeAffectsZoom(LayoutPart layoutPart) {
        return layoutPart.isObscuredByZoom();
    }

    public void removePart(LayoutPart layoutPart) {
        Composite composite = this.mainLayout.getParent();
        layoutPart.reparent(composite);
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null) {
            String string = layoutPart.getPlaceHolderId();
            iLayoutContainer.replace(layoutPart, new PartPlaceholder(string));
            if (iLayoutContainer == this.mainLayout) {
                return;
            }
            LayoutPart[] layoutPartArray = iLayoutContainer.getChildren();
            if (layoutPartArray != null) {
                int n = 0;
                int n2 = layoutPartArray.length;
                while (n < n2) {
                    if (!(layoutPartArray[n] instanceof PartPlaceholder)) break;
                    ++n;
                }
            }
        }
    }

    public void replacePlaceholderWithPart(LayoutPart layoutPart) {
        PartPlaceholder[] partPlaceholderArray = this.collectPlaceholders();
        int n = 0;
        int n2 = partPlaceholderArray.length;
        while (n < n2) {
            ILayoutContainer iLayoutContainer;
            if (partPlaceholderArray[n].getCompoundId().equals(layoutPart.getCompoundId()) && (iLayoutContainer = partPlaceholderArray[n].getContainer()) != null) {
                if (iLayoutContainer instanceof ContainerPlaceholder) {
                    ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)iLayoutContainer;
                    ILayoutContainer iLayoutContainer2 = containerPlaceholder.getContainer();
                    iLayoutContainer = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                    if (iLayoutContainer instanceof LayoutPart) {
                        iLayoutContainer2.replace(containerPlaceholder, (LayoutPart)((Object)iLayoutContainer));
                    }
                    containerPlaceholder.setRealContainer(null);
                }
                iLayoutContainer.replace(partPlaceholderArray[n], layoutPart);
                return;
            }
            ++n;
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("mainWindow");
        IStatus iStatus = this.mainLayout.restoreState(iMemento2);
        return iStatus;
    }

    public IStatus saveState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild("mainWindow");
        IStatus iStatus = this.mainLayout.saveState(iMemento2);
        return iStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void zoomIn(IWorkbenchPartReference iWorkbenchPartReference) {
        PartPane partPane = ((WorkbenchPartReference)iWorkbenchPartReference).getPane();
        this.parentWidget.setRedraw(false);
        try {
            partPane.requestZoomIn();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parentWidget.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.parentWidget.setRedraw(true);
    }

    public void zoomOut() {
        LayoutPart layoutPart = this.mainLayout.getZoomedPart();
        if (layoutPart != null) {
            layoutPart.requestZoomOut();
        }
    }

    private class MatchingPart
    implements Comparable {
        String pid;
        String sid;
        LayoutPart part;
        boolean hasWildcard;
        int len;

        MatchingPart(String string, String string2, LayoutPart layoutPart) {
            this.pid = string;
            this.sid = string2;
            this.part = layoutPart;
            this.len = (string == null ? 0 : string.length()) + (string2 == null ? 0 : string2.length());
            this.hasWildcard = string != null && string.indexOf(PartPlaceholder.WILD_CARD) != -1 || string2 != null && string2.indexOf(PartPlaceholder.WILD_CARD) != -1;
        }

        public int compareTo(Object object) {
            MatchingPart matchingPart = (MatchingPart)object;
            if (this.hasWildcard && !matchingPart.hasWildcard) {
                return -1;
            }
            if (!this.hasWildcard && matchingPart.hasWildcard) {
                return 1;
            }
            return matchingPart.len - this.len;
        }
    }
}

