/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.core.Messages;

public class InstallMonitor
implements IProgressMonitor {
    protected IProgressMonitor monitor;
    protected Stack tasks;
    protected String taskString;
    protected String subTaskString;
    protected boolean showDetails;
    protected long totalCopyCount;
    protected long currentCount = 0L;

    protected InstallMonitor() {
    }

    public InstallMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
        this.tasks = new Stack();
        this.taskString = "";
        this.subTaskString = "";
        this.showDetails = false;
        this.totalCopyCount = 0L;
    }

    public void beginTask(String string, int n) {
        this.taskString = string;
        this.monitor.beginTask(string, n);
    }

    public void done() {
        this.monitor.done();
    }

    public void internalWorked(double d) {
        this.monitor.internalWorked(d);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean bl) {
        this.monitor.setCanceled(bl);
    }

    public void setTaskName(String string) {
        this.taskString = string;
        this.subTaskString = "";
        this.showDetails = false;
        this.totalCopyCount = 0L;
        this.monitor.subTask("");
        this.monitor.setTaskName(string);
    }

    public void subTask(String string) {
        this.subTaskString = string;
        this.showDetails = false;
        this.totalCopyCount = 0L;
        this.monitor.subTask(string);
    }

    public void worked(int n) {
        this.monitor.worked(n);
    }

    public void saveState() {
        this.tasks.push(new MonitorState(this.taskString, this.subTaskString, this.showDetails, this.currentCount, this.totalCopyCount));
    }

    public void restoreState() {
        if (this.tasks.size() > 0) {
            MonitorState monitorState = (MonitorState)this.tasks.pop();
            this.setTaskName(monitorState.getTaskString());
            this.subTask(monitorState.getSubTaskString());
            this.showDetails = monitorState.getShowDetails();
            this.currentCount = monitorState.getCurrentCount();
            this.totalCopyCount = monitorState.getTotalCopyCount();
        }
    }

    public void showCopyDetails(boolean bl) {
        this.showDetails = bl;
    }

    public void setTotalCount(long l) {
        this.totalCopyCount = l;
    }

    public void setCopyCount(long l) {
        if (this.showDetails && l > 0L) {
            this.currentCount = l;
            long l2 = l / 1024L;
            long l3 = this.totalCopyCount / 1024L;
            String string = l3 <= 0L ? NLS.bind((String)Messages.InstallMonitor_DownloadSize, (Object[])new String[]{Long.toString(l2)}) : NLS.bind((String)Messages.InstallMonitor_DownloadSizeLong, (Object[])new String[]{Long.toString(l2), Long.toString(l3)});
            this.monitor.subTask(String.valueOf(this.subTaskString) + string);
        }
    }

    public void incrementCount(long l) {
        this.setCopyCount(this.currentCount + l);
    }

    protected class MonitorState {
        private String taskString;
        private String subTaskString;
        private boolean showDetails;
        private long totalCopyCount;
        private long currentCount;

        private MonitorState(String string, String string2, boolean bl, long l, long l2) {
            this.taskString = string;
            this.subTaskString = string2;
            this.showDetails = bl;
            this.currentCount = l;
            this.totalCopyCount = l2;
        }

        private String getTaskString() {
            return this.taskString;
        }

        private String getSubTaskString() {
            return this.subTaskString;
        }

        private boolean getShowDetails() {
            return this.showDetails;
        }

        private long getCurrentCount() {
            return this.currentCount;
        }

        private long getTotalCopyCount() {
            return this.totalCopyCount;
        }
    }
}

