/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.internal.preferences.IPropertyMapListener;

public final class PropertyListenerList {
    private Map listeners;
    private List globalListeners;
    private static String[] singlePropertyDelta;
    private static Object mutex;

    static {
        mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String string) {
        String[] stringArray;
        Object object = mutex;
        synchronized (object) {
            if (singlePropertyDelta != null) {
                stringArray = singlePropertyDelta;
                singlePropertyDelta = null;
            } else {
                stringArray = new String[]{string};
            }
        }
        stringArray[0] = string;
        this.firePropertyChange(stringArray);
        if (singlePropertyDelta == null) {
            object = mutex;
            synchronized (object) {
                singlePropertyDelta = stringArray;
            }
        }
    }

    public void firePropertyChange(String[] stringArray) {
        Object object;
        Object object2;
        if (this.globalListeners != null) {
            object2 = this.globalListeners.iterator();
            while (object2.hasNext()) {
                object = (IPropertyMapListener)object2.next();
                object.propertyChanged(stringArray);
            }
        }
        if (this.listeners != null) {
            Object object3;
            object2 = Collections.EMPTY_SET;
            object = null;
            int n = 0;
            while (n < stringArray.length) {
                object3 = stringArray[n];
                List list = (List)this.listeners.get(object3);
                if (list != null) {
                    if (object2 == Collections.EMPTY_SET) {
                        object2 = list;
                    } else {
                        if (object == null) {
                            object = new HashSet();
                            ((AbstractCollection)object).addAll(object2);
                            object2 = object;
                        }
                        ((AbstractCollection)object).addAll(list);
                    }
                }
                ++n;
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = (IPropertyMapListener)iterator.next();
                object3.propertyChanged(stringArray);
            }
        }
    }

    public void add(IPropertyMapListener iPropertyMapListener) {
        if (this.globalListeners == null) {
            this.globalListeners = new ArrayList();
        }
        this.globalListeners.add(iPropertyMapListener);
        iPropertyMapListener.listenerAttached();
    }

    private void addInternal(String string, IPropertyMapListener iPropertyMapListener) {
        ArrayList<IPropertyMapListener> arrayList;
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        if ((arrayList = (ArrayList<IPropertyMapListener>)this.listeners.get(string)) == null) {
            arrayList = new ArrayList<IPropertyMapListener>(1);
            this.listeners.put(string, arrayList);
        }
        if (!arrayList.contains(iPropertyMapListener)) {
            arrayList.add(iPropertyMapListener);
        }
    }

    public void add(String[] stringArray, IPropertyMapListener iPropertyMapListener) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.addInternal(string, iPropertyMapListener);
            ++n;
        }
        iPropertyMapListener.listenerAttached();
    }

    public void remove(String string, IPropertyMapListener iPropertyMapListener) {
        if (this.listeners == null) {
            return;
        }
        List list = (List)this.listeners.get(string);
        if (list != null) {
            list.remove(iPropertyMapListener);
            if (list.isEmpty()) {
                this.listeners.remove(string);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    public void removeAll() {
        this.globalListeners = null;
        this.listeners = null;
    }

    public void remove(IPropertyMapListener iPropertyMapListener) {
        if (this.globalListeners != null) {
            this.globalListeners.remove(iPropertyMapListener);
            if (this.globalListeners.isEmpty()) {
                this.globalListeners = null;
            }
        }
        if (this.listeners != null) {
            Iterator iterator = this.listeners.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.remove(string, iPropertyMapListener);
            }
        }
    }

    public boolean isEmpty() {
        return this.globalListeners == null && this.listeners == null;
    }
}

