/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.OptionalFeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class ConfigOperation
extends OptionalFeatureOperation
implements IConfigFeatureOperation {
    boolean bBatchConfigOperation = false;

    public ConfigOperation(IConfiguredSite iConfiguredSite, IFeature iFeature) {
        this(iConfiguredSite, iFeature, null, null);
    }

    public ConfigOperation(IConfiguredSite iConfiguredSite, IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IFeature[] iFeatureArray) {
        super(iConfiguredSite, iFeature);
        IFeature[] iFeatureArray2 = UpdateUtils.getInstalledFeatures(iFeature);
        if (iFeatureArray2.length > 0) {
            this.oldFeature = iFeatureArray2[0];
        }
        this.unconfiguredOptionalFeatures = iFeatureArray;
        this.optionalFeatures = iFeatureReferenceArray;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException {
        Object object;
        IStatus iStatus;
        if (!this.bBatchConfigOperation && (iStatus = OperationsManager.getValidator().validatePendingConfig(this.feature)) != null && iStatus.getCode() == 4) {
            throw new CoreException(iStatus);
        }
        if (this.isManagedOnly()) {
            this.setOptionalFeatures();
        }
        if (this.oldFeature != null && this.isManagedOnly()) {
            this.preserveOptionalState();
            boolean bl = ConfigOperation.unconfigure(this.oldFeature, null);
            if (!bl && !UpdateUtils.isNestedChild((IInstallConfiguration)(object = SiteManager.getLocalSite().getCurrentConfiguration()), this.oldFeature)) {
                String string = NLS.bind((String)Messages.OperationsManager_error_old, (Object[])new String[]{this.oldFeature.getLabel()});
                Status status = new Status(4, UpdateUtils.getPluginId(), 0, string, null);
                throw new CoreException((IStatus)status);
            }
        }
        this.targetSite.configure(this.feature, this.optionalFeatures, iProgressMonitor);
        try {
            boolean bl = false;
            object = OperationsManager.findPendingOperation(this.feature);
            if (object instanceof IUnconfigFeatureOperation) {
                OperationsManager.removePendingOperation((IOperation)object);
            } else {
                OperationsManager.addPendingOperation(this);
            }
            this.markProcessed();
            if (iOperationListener != null) {
                iOperationListener.afterExecute(this, null);
            }
            if (!this.bBatchConfigOperation) {
                bl = SiteManager.getLocalSite().save() && bl;
            }
            OperationsManager.fireObjectChanged(this.feature, null);
            return bl;
        }
        catch (CoreException coreException) {
            this.undo();
            UpdateUtils.logException(coreException);
            throw coreException;
        }
    }

    void setBatchConfigOperation() {
        this.bBatchConfigOperation = true;
    }

    public void undo() throws CoreException {
        this.targetSite.unconfigure(this.feature);
    }
}

