/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class SiteSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries = new IUpdateSearchQuery[]{new Query()};
    private boolean liteFeaturesAreOK;
    private static final String CATEGORY_ID = "org.eclipse.update.core.unified-search";

    public SiteSearchCategory() {
        super(CATEGORY_ID);
    }

    public SiteSearchCategory(boolean bl) {
        this();
        this.liteFeaturesAreOK = bl;
        this.queries = new IUpdateSearchQuery[]{new Query(bl)};
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    public boolean isLiteFeaturesAreOK() {
        return this.liteFeaturesAreOK;
    }

    public void setLiteFeaturesAreOK(boolean bl) {
        this.liteFeaturesAreOK = bl;
        int n = 0;
        while (n < this.queries.length) {
            ((Query)this.queries[n]).setLiteFeaturesAreOK(bl);
            ++n;
        }
    }

    private static class Query
    implements IUpdateSearchQuery {
        private boolean liteFeaturesAreOK;

        public Query() {
            this.liteFeaturesAreOK = false;
        }

        public Query(boolean bl) {
            this.liteFeaturesAreOK = bl;
        }

        public boolean isLiteFeaturesAreOK() {
            return this.liteFeaturesAreOK;
        }

        public void setLiteFeaturesAreOK(boolean bl) {
            this.liteFeaturesAreOK = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ISite iSite, String[] stringArray, IUpdateSearchFilter iUpdateSearchFilter, IUpdateSearchResultCollector iUpdateSearchResultCollector, IProgressMonitor iProgressMonitor) {
            Object object;
            ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getFeatureReferences();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<VersionedIdentifier, LiteFeature> hashMap = new HashMap<VersionedIdentifier, LiteFeature>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    hashSet.add(stringArray[n]);
                    ++n;
                }
            }
            ArrayList<ISiteFeatureReference> arrayList = new ArrayList<ISiteFeatureReference>(Arrays.asList(iSiteFeatureReferenceArray));
            if (this.liteFeaturesAreOK && iSite instanceof ExtendedSite) {
                object = (ExtendedSite)iSite;
                LiteFeature[] liteFeatureArray = ((ExtendedSite)object).getLiteFeatures();
                if (liteFeatureArray != null && liteFeatureArray.length != 0) {
                    int n = 0;
                    while (n < liteFeatureArray.length) {
                        hashMap.put(liteFeatureArray[n].getVersionedIdentifier(), liteFeatureArray[n]);
                        ++n;
                    }
                    new FeatureDownloader(arrayList, iUpdateSearchResultCollector, iUpdateSearchFilter, hashSet, iProgressMonitor, true, hashMap).run();
                    return;
                }
                this.liteFeaturesAreOK = false;
            }
            iProgressMonitor.beginTask("", iSiteFeatureReferenceArray.length);
            object = new ThreadGroup("FeatureDownloader");
            int n = iSiteFeatureReferenceArray.length > 5 ? 5 : iSiteFeatureReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Thread thread = new Thread((ThreadGroup)object, new FeatureDownloader(arrayList, iUpdateSearchResultCollector, iUpdateSearchFilter, hashSet, iProgressMonitor));
                thread.start();
                ++n2;
            }
            while (((ThreadGroup)object).activeCount() != 0) {
                if (iProgressMonitor.isCanceled()) {
                    ArrayList<ISiteFeatureReference> arrayList2 = arrayList;
                    synchronized (arrayList2) {
                        arrayList.clear();
                    }
                }
                Thread[] threadArray = new Thread[((ThreadGroup)object).activeCount()];
                ((ThreadGroup)object).enumerate(threadArray);
                if (threadArray[0] == null) continue;
                try {
                    threadArray[0].join(250L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }

    private static class FeatureDownloader
    implements Runnable {
        private List siteFeatureReferences;
        private IProgressMonitor monitor;
        private IUpdateSearchFilter filter;
        private IUpdateSearchResultCollector collector;
        private HashSet ignores;
        private boolean liteFeaturesAreOK;
        private Map liteFeatures;

        private FeatureDownloader() {
        }

        public FeatureDownloader(List list, IUpdateSearchResultCollector iUpdateSearchResultCollector, IUpdateSearchFilter iUpdateSearchFilter, HashSet hashSet, IProgressMonitor iProgressMonitor) {
            this.collector = iUpdateSearchResultCollector;
            this.filter = iUpdateSearchFilter;
            this.ignores = hashSet;
            this.monitor = iProgressMonitor;
            this.siteFeatureReferences = list;
        }

        public FeatureDownloader(List list, IUpdateSearchResultCollector iUpdateSearchResultCollector, IUpdateSearchFilter iUpdateSearchFilter, HashSet hashSet, IProgressMonitor iProgressMonitor, boolean bl, Map map) {
            this(list, iUpdateSearchResultCollector, iUpdateSearchFilter, hashSet, iProgressMonitor);
            this.liteFeaturesAreOK = bl && map != null;
            this.liteFeatures = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ISiteFeatureReference iSiteFeatureReference = null;
            while (this.siteFeatureReferences.size() != 0) {
                ICategory iCategory;
                Object object;
                List list = this.siteFeatureReferences;
                synchronized (list) {
                    iSiteFeatureReference = this.siteFeatureReferences.size() != 0 ? (ISiteFeatureReference)this.siteFeatureReferences.remove(0) : null;
                }
                if (iSiteFeatureReference == null) continue;
                boolean bl = false;
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (this.ignores.size() > 0) {
                    object = iSiteFeatureReference.getCategories();
                    int n = 0;
                    while (n < ((ICategory[])object).length) {
                        iCategory = object[n];
                        if (this.ignores.contains(iCategory.getName())) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                try {
                    block19: {
                        try {
                            if (bl || !this.filter.accept(iSiteFeatureReference)) break block19;
                            object = null;
                            if (this.liteFeaturesAreOK) {
                                object = (IFeature)this.liteFeatures.get(iSiteFeatureReference.getVersionedIdentifier());
                            }
                            if (object == null) {
                                object = iSiteFeatureReference.getFeature(null);
                            }
                            List list2 = this.siteFeatureReferences;
                            synchronized (list2) {
                                if (object != null && this.filter.accept(iSiteFeatureReference)) {
                                    this.collector.accept((IFeature)object);
                                    this.monitor.subTask(object.getLabel());
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            System.out.println((Object)coreException);
                        }
                    }
                    iCategory = null;
                }
                catch (Throwable throwable) {
                    iCategory = null;
                    this.monitor.worked(1);
                    throw throwable;
                }
                this.monitor.worked(1);
            }
        }
    }
}

