/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public final class FeatureTypeFactory {
    private static FeatureTypeFactory inst;
    private Map factories;
    private static final String SIMPLE_EXTENSION_ID = "featureTypes";

    private FeatureTypeFactory() {
    }

    public static FeatureTypeFactory getInstance() {
        if (inst == null) {
            inst = new FeatureTypeFactory();
        }
        return inst;
    }

    public IFeatureFactory getFactory(String string) throws CoreException {
        Object object = this.getFactories().get(string);
        if (object == null) {
            object = this.createFactoryFor(string);
            this.getFactories().put(string, object);
        }
        return (IFeatureFactory)object;
    }

    private IFeatureFactory createFactoryFor(String string) throws CoreException {
        IFeatureFactory iFeatureFactory = null;
        String string2 = UpdateCore.getPlugin().getBundle().getSymbolicName();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string2, SIMPLE_EXTENSION_ID, string);
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureTypeFactory_UnableToFindFeatureFactory, (Object[])new String[]{string}), null);
        }
        IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
        iFeatureFactory = (IFeatureFactory)iConfigurationElement.createExecutableExtension("class");
        return iFeatureFactory;
    }

    private Map getFactories() {
        if (this.factories == null) {
            this.factories = new HashMap();
        }
        return this.factories;
    }
}

