/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.OperationValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationFactory;
import org.eclipse.update.operations.IOperationValidator;
import org.eclipse.update.operations.IUpdateModelChangedListener;

public class OperationsManager {
    private static IOperationValidator validator;
    private static IOperationFactory operationFactory;
    private static Vector listeners;
    private static Vector pendingOperations;
    private static boolean inProgress;

    static {
        listeners = new Vector();
        pendingOperations = new Vector();
    }

    private OperationsManager() {
    }

    public static IOperationFactory getOperationFactory() {
        if (operationFactory == null) {
            operationFactory = new OperationFactory();
        }
        return operationFactory;
    }

    public static IFeatureOperation findPendingOperation(IFeature iFeature) {
        int n = 0;
        while (n < pendingOperations.size()) {
            IFeatureOperation iFeatureOperation = (IFeatureOperation)pendingOperations.elementAt(n);
            if (iFeatureOperation.getFeature().equals(iFeature)) {
                return iFeatureOperation;
            }
            ++n;
        }
        return null;
    }

    public static void addPendingOperation(IOperation iOperation) {
        pendingOperations.add(iOperation);
    }

    public static void removePendingOperation(IOperation iOperation) {
        pendingOperations.remove(iOperation);
    }

    public static void addUpdateModelChangedListener(IUpdateModelChangedListener iUpdateModelChangedListener) {
        if (!listeners.contains(iUpdateModelChangedListener)) {
            listeners.add(iUpdateModelChangedListener);
        }
    }

    public static void removeUpdateModelChangedListener(IUpdateModelChangedListener iUpdateModelChangedListener) {
        if (listeners.contains(iUpdateModelChangedListener)) {
            listeners.remove(iUpdateModelChangedListener);
        }
    }

    public static void fireObjectsAdded(Object object, Object[] objectArray) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            IUpdateModelChangedListener iUpdateModelChangedListener = (IUpdateModelChangedListener)iterator.next();
            iUpdateModelChangedListener.objectsAdded(object, objectArray);
        }
    }

    public static void fireObjectsRemoved(Object object, Object[] objectArray) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            IUpdateModelChangedListener iUpdateModelChangedListener = (IUpdateModelChangedListener)iterator.next();
            iUpdateModelChangedListener.objectsRemoved(object, objectArray);
        }
    }

    public static void fireObjectChanged(Object object, String string) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            IUpdateModelChangedListener iUpdateModelChangedListener = (IUpdateModelChangedListener)iterator.next();
            iUpdateModelChangedListener.objectChanged(object, string);
        }
    }

    public static boolean hasSelectedJobsWithLicenses(IInstallFeatureOperation[] iInstallFeatureOperationArray) {
        int n = 0;
        while (n < iInstallFeatureOperationArray.length) {
            if (UpdateUtils.hasLicense(iInstallFeatureOperationArray[n].getFeature())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean hasSelectedJobsWithOptionalFeatures(IInstallFeatureOperation[] iInstallFeatureOperationArray) {
        int n = 0;
        while (n < iInstallFeatureOperationArray.length) {
            if (UpdateUtils.hasOptionalFeatures(iInstallFeatureOperationArray[n].getFeature())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static IInstallFeatureOperation[] getSelectedJobsWithLicenses(IInstallFeatureOperation[] iInstallFeatureOperationArray) {
        ArrayList<IInstallFeatureOperation> arrayList = new ArrayList<IInstallFeatureOperation>();
        int n = 0;
        while (n < iInstallFeatureOperationArray.length) {
            if (UpdateUtils.hasLicense(iInstallFeatureOperationArray[n].getFeature())) {
                arrayList.add(iInstallFeatureOperationArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IInstallFeatureOperation[arrayList.size()]);
    }

    public static IInstallFeatureOperation[] getSelectedJobsWithOptionalFeatures(IInstallFeatureOperation[] iInstallFeatureOperationArray) {
        ArrayList<IInstallFeatureOperation> arrayList = new ArrayList<IInstallFeatureOperation>();
        int n = 0;
        while (n < iInstallFeatureOperationArray.length) {
            if (UpdateUtils.hasOptionalFeatures(iInstallFeatureOperationArray[n].getFeature())) {
                arrayList.add(iInstallFeatureOperationArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IInstallFeatureOperation[arrayList.size()]);
    }

    public static synchronized void setInProgress(boolean bl) {
        inProgress = bl;
    }

    public static synchronized boolean isInProgress() {
        return inProgress;
    }

    public static IOperationValidator getValidator() {
        if (validator == null) {
            validator = new OperationValidator();
        }
        return validator;
    }

    public static void setValidator(IOperationValidator iOperationValidator) {
        validator = iOperationValidator;
    }

    public static void applyChangesNow() {
        ConfigurationActivator configurationActivator = ConfigurationActivator.getConfigurator();
        configurationActivator.installBundles();
        pendingOperations.clear();
    }
}

